/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.relational.optimizer;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementation;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.sql.relational.CallExpression;
import com.facebook.presto.sql.relational.ConstantExpression;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.sql.relational.InputReferenceExpression;
import com.facebook.presto.sql.relational.RowExpression;
import com.facebook.presto.sql.relational.RowExpressionVisitor;
import com.facebook.presto.sql.relational.Signatures;
import com.facebook.presto.util.ImmutableCollectors;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.List;

public class ExpressionOptimizer {
    private final FunctionRegistry registry;
    private final TypeManager typeManager;
    private final ConnectorSession session;

    public ExpressionOptimizer(FunctionRegistry registry, TypeManager typeManager, Session session) {
        this.registry = registry;
        this.typeManager = typeManager;
        this.session = session.toConnectorSession();
    }

    public RowExpression optimize(RowExpression expression) {
        return expression.accept(new Visitor(), null);
    }

    private class Visitor
    implements RowExpressionVisitor<Void, RowExpression> {
        private Visitor() {
        }

        @Override
        public RowExpression visitInputReference(InputReferenceExpression reference, Void context) {
            return reference;
        }

        @Override
        public RowExpression visitConstant(ConstantExpression literal, Void context) {
            return literal;
        }

        @Override
        public RowExpression visitCall(CallExpression call, Void context) {
            List arguments;
            Signature signature;
            block30: {
                ScalarFunctionImplementation function;
                signature = call.getSignature();
                if (signature.getName().equals(Signatures.CAST)) {
                    Object functionSignature = ExpressionOptimizer.this.registry.getCoercion(call.getArguments().get(0).getType(), call.getType());
                    function = ExpressionOptimizer.this.registry.getScalarFunctionImplementation((Signature)functionSignature);
                } else {
                    switch (signature.getName()) {
                        case "IF": {
                            Preconditions.checkState((call.getArguments().size() == 3 ? 1 : 0) != 0, (Object)("IF function should have 3 arguments. Get " + call.getArguments().size()));
                            RowExpression optimizedOperand = call.getArguments().get(0).accept(this, context);
                            if (optimizedOperand instanceof ConstantExpression) {
                                ConstantExpression constantOperand = (ConstantExpression)optimizedOperand;
                                Preconditions.checkState((boolean)constantOperand.getType().equals(BooleanType.BOOLEAN), (Object)("Operand of IF function should be BOOLEAN type. Get type " + constantOperand.getType().getDisplayName()));
                                if (Boolean.TRUE.equals(constantOperand.getValue())) {
                                    return call.getArguments().get(1).accept(this, context);
                                }
                                return call.getArguments().get(2).accept(this, context);
                            }
                            List arguments2 = (List)call.getArguments().stream().map(argument -> argument.accept(this, null)).collect(ImmutableCollectors.toImmutableList());
                            return Expressions.call(signature, call.getType(), arguments2);
                        }
                        case "TRY": {
                            Preconditions.checkState((call.getArguments().size() == 1 ? 1 : 0) != 0, (Object)"try call expressions must have a single argument");
                            if (!(Iterables.getOnlyElement(call.getArguments()) instanceof CallExpression)) {
                                return ((RowExpression)Iterables.getOnlyElement(call.getArguments())).accept(this, null);
                            }
                            List arguments3 = (List)call.getArguments().stream().map(argument -> argument.accept(this, null)).collect(ImmutableCollectors.toImmutableList());
                            return Expressions.call(signature, call.getType(), arguments3);
                        }
                        case "NULL_IF": 
                        case "SWITCH": 
                        case "WHEN": 
                        case "TRY_CAST": 
                        case "IS_NULL": 
                        case "IS_DISTINCT_FROM": 
                        case "COALESCE": 
                        case "AND": 
                        case "OR": 
                        case "IN": {
                            List arguments4 = (List)call.getArguments().stream().map(argument -> argument.accept(this, null)).collect(ImmutableCollectors.toImmutableList());
                            return Expressions.call(signature, call.getType(), arguments4);
                        }
                    }
                    function = ExpressionOptimizer.this.registry.getScalarFunctionImplementation(signature);
                }
                arguments = (List)call.getArguments().stream().map(argument -> argument.accept(this, context)).collect(ImmutableCollectors.toImmutableList());
                if (Iterables.all((Iterable)arguments, (Predicate)Predicates.instanceOf(ConstantExpression.class)) && function.isDeterministic()) {
                    MethodHandle method = function.getMethodHandle();
                    if (method.type().parameterCount() > 0 && method.type().parameterType(0) == ConnectorSession.class) {
                        method = method.bindTo(ExpressionOptimizer.this.session);
                    }
                    int index = 0;
                    ArrayList<Object> constantArguments = new ArrayList<Object>();
                    for (RowExpression argument2 : arguments) {
                        Object value = ((ConstantExpression)argument2).getValue();
                        if (value == null && !function.getNullableArguments().get(index).booleanValue()) {
                            return Expressions.constantNull(call.getType());
                        }
                        constantArguments.add(value);
                        ++index;
                    }
                    try {
                        return Expressions.constant(method.invokeWithArguments(constantArguments), call.getType());
                    }
                    catch (Throwable e) {
                        if (!(e instanceof InterruptedException)) break block30;
                        Thread.currentThread().interrupt();
                    }
                }
            }
            return Expressions.call(signature, ExpressionOptimizer.this.typeManager.getType(signature.getReturnType()), arguments);
        }
    }
}

