/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.testing;

import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class MaterializedRow {
    private final int precision;
    private final List<Object> values;

    public MaterializedRow(int precision, Object ... values) {
        this(precision, Arrays.asList(Objects.requireNonNull(values, "values is null")));
    }

    public MaterializedRow(int precision, List<Object> values) {
        Preconditions.checkArgument((precision > 0 ? 1 : 0) != 0, (Object)"Need at least one digit of precision");
        this.precision = precision;
        this.values = (List)MaterializedRow.processValue(precision, values);
    }

    private static Object processValue(int precision, Object value) {
        if (value instanceof Double || value instanceof Float) {
            return new ApproximateDouble(((Number)value).doubleValue(), precision);
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof List) {
            return ((List)value).stream().map(element -> MaterializedRow.processValue(precision, element)).collect(Collectors.toList());
        }
        if (value instanceof Map) {
            HashMap<Object, Object> map = new HashMap<Object, Object>();
            for (Map.Entry entry : ((Map)value).entrySet()) {
                map.put(MaterializedRow.processValue(precision, entry.getKey()), MaterializedRow.processValue(precision, entry.getValue()));
            }
            return map;
        }
        return value;
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getFieldCount() {
        return this.values.size();
    }

    public List<Object> getFields() {
        return this.values.stream().map(MaterializedRow::processField).collect(Collectors.toList());
    }

    public Object getField(int field) {
        Preconditions.checkElementIndex((int)field, (int)this.values.size());
        return MaterializedRow.processField(this.values.get(field));
    }

    private static Object processField(Object value) {
        if (value instanceof ApproximateDouble) {
            return ((ApproximateDouble)value).getValue();
        }
        if (value instanceof List) {
            return ((List)value).stream().map(MaterializedRow::processField).collect(Collectors.toList());
        }
        if (value instanceof Map) {
            HashMap<Object, Object> map = new HashMap<Object, Object>();
            for (Map.Entry entry : ((Map)value).entrySet()) {
                map.put(MaterializedRow.processField(entry.getKey()), MaterializedRow.processField(entry.getValue()));
            }
            return map;
        }
        return value;
    }

    public String toString() {
        return this.values.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MaterializedRow o = (MaterializedRow)obj;
        return Objects.equals(this.values, o.values);
    }

    public int hashCode() {
        return Objects.hash(this.values);
    }

    private static class ApproximateDouble {
        private final Double value;
        private final Double normalizedValue;

        private ApproximateDouble(Double value, int precision) {
            this.value = value;
            this.normalizedValue = value.isNaN() || value.isInfinite() ? value : Double.valueOf(new BigDecimal(value).round(new MathContext(precision)).doubleValue());
        }

        public Double getValue() {
            return this.value;
        }

        public String toString() {
            return this.value.toString();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            ApproximateDouble o = (ApproximateDouble)obj;
            return Objects.equals(this.normalizedValue, o.normalizedValue);
        }

        public int hashCode() {
            return Objects.hash(this.normalizedValue);
        }
    }
}

