/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.transaction;

import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorIndexResolver;
import com.facebook.presto.spi.ConnectorInsertTableHandle;
import com.facebook.presto.spi.ConnectorMetadata;
import com.facebook.presto.spi.ConnectorNewTableLayout;
import com.facebook.presto.spi.ConnectorOutputTableHandle;
import com.facebook.presto.spi.ConnectorResolvedIndex;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableLayout;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.ConnectorTableLayoutResult;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.ConnectorViewDefinition;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SchemaTablePrefix;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.security.Privilege;
import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;

public class LegacyConnectorMetadata
implements com.facebook.presto.spi.connector.ConnectorMetadata {
    private final ConnectorMetadata metadata;
    private final Optional<ConnectorIndexResolver> indexResolver;
    private final AtomicReference<Runnable> rollbackAction = new AtomicReference();

    public LegacyConnectorMetadata(ConnectorMetadata metadata, Optional<ConnectorIndexResolver> indexResolver) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.indexResolver = Objects.requireNonNull(indexResolver, "indexResolver is null");
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        return this.metadata.listSchemaNames(session);
    }

    public ConnectorTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName) {
        return this.metadata.getTableHandle(session, tableName);
    }

    public List<ConnectorTableLayoutResult> getTableLayouts(ConnectorSession session, ConnectorTableHandle table, Constraint<ColumnHandle> constraint, Optional<Set<ColumnHandle>> desiredColumns) {
        return this.metadata.getTableLayouts(session, table, constraint, desiredColumns);
    }

    public ConnectorTableLayout getTableLayout(ConnectorSession session, ConnectorTableLayoutHandle handle) {
        return this.metadata.getTableLayout(session, handle);
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle table) {
        return this.metadata.getTableMetadata(session, table);
    }

    public List<SchemaTableName> listTables(ConnectorSession session, String schemaNameOrNull) {
        return this.metadata.listTables(session, schemaNameOrNull);
    }

    public ColumnHandle getSampleWeightColumnHandle(ConnectorSession session, ConnectorTableHandle tableHandle) {
        return this.metadata.getSampleWeightColumnHandle(session, tableHandle);
    }

    public boolean canCreateSampledTables(ConnectorSession session) {
        return this.metadata.canCreateSampledTables(session);
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        return this.metadata.getColumnHandles(session, tableHandle);
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        return this.metadata.getColumnMetadata(session, tableHandle, columnHandle);
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        return this.metadata.listTableColumns(session, prefix);
    }

    public void createTable(ConnectorSession session, ConnectorTableMetadata tableMetadata) {
        this.metadata.createTable(session, tableMetadata);
    }

    public void dropTable(ConnectorSession session, ConnectorTableHandle tableHandle) {
        this.metadata.dropTable(session, tableHandle);
    }

    public void renameTable(ConnectorSession session, ConnectorTableHandle tableHandle, SchemaTableName newTableName) {
        this.metadata.renameTable(session, tableHandle, newTableName);
    }

    public void addColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnMetadata column) {
        this.metadata.addColumn(session, tableHandle, column);
    }

    public void renameColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle source, String target) {
        this.metadata.renameColumn(session, tableHandle, source, target);
    }

    public final Optional<ConnectorNewTableLayout> getNewTableLayout(ConnectorSession session, ConnectorTableMetadata tableMetadata) {
        return Optional.empty();
    }

    public ConnectorOutputTableHandle beginCreateTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, Optional<ConnectorNewTableLayout> layout) {
        Preconditions.checkState((this.rollbackAction.get() == null ? 1 : 0) != 0, (Object)"Cannot begin a new write while in an existing one");
        ConnectorOutputTableHandle outputTableHandle = this.metadata.beginCreateTable(session, tableMetadata);
        this.setRollback(() -> this.metadata.rollbackCreateTable(session, outputTableHandle));
        return outputTableHandle;
    }

    public void finishCreateTable(ConnectorSession session, ConnectorOutputTableHandle tableHandle, Collection<Slice> fragments) {
        Preconditions.checkState((this.rollbackAction.get() != null ? 1 : 0) != 0, (Object)"No rollback action registered");
        this.metadata.commitCreateTable(session, tableHandle, fragments);
        this.clearRollback();
    }

    public ConnectorInsertTableHandle beginInsert(ConnectorSession session, ConnectorTableHandle tableHandle) {
        Preconditions.checkState((this.rollbackAction.get() == null ? 1 : 0) != 0, (Object)"Cannot begin a new write while in an existing one");
        ConnectorInsertTableHandle insertHandle = this.metadata.beginInsert(session, tableHandle);
        this.setRollback(() -> this.metadata.rollbackInsert(session, insertHandle));
        return insertHandle;
    }

    public void finishInsert(ConnectorSession session, ConnectorInsertTableHandle insertHandle, Collection<Slice> fragments) {
        Preconditions.checkState((this.rollbackAction.get() != null ? 1 : 0) != 0, (Object)"No rollback action registered");
        this.metadata.commitInsert(session, insertHandle, fragments);
        this.clearRollback();
    }

    public ColumnHandle getUpdateRowIdColumnHandle(ConnectorSession session, ConnectorTableHandle tableHandle) {
        return this.metadata.getUpdateRowIdColumnHandle(session, tableHandle);
    }

    public ConnectorTableHandle beginDelete(ConnectorSession session, ConnectorTableHandle tableHandle) {
        Preconditions.checkState((this.rollbackAction.get() == null ? 1 : 0) != 0, (Object)"Cannot begin a new write while in an existing one");
        ConnectorTableHandle deleteHandle = this.metadata.beginDelete(session, tableHandle);
        this.setRollback(() -> this.metadata.rollbackDelete(session, deleteHandle));
        return deleteHandle;
    }

    public void finishDelete(ConnectorSession session, ConnectorTableHandle tableHandle, Collection<Slice> fragments) {
        Preconditions.checkState((this.rollbackAction.get() != null ? 1 : 0) != 0, (Object)"No rollback action registered");
        this.metadata.commitDelete(session, tableHandle, fragments);
        this.clearRollback();
    }

    public void createView(ConnectorSession session, SchemaTableName viewName, String viewData, boolean replace) {
        this.metadata.createView(session, viewName, viewData, replace);
    }

    public void dropView(ConnectorSession session, SchemaTableName viewName) {
        this.metadata.dropView(session, viewName);
    }

    public List<SchemaTableName> listViews(ConnectorSession session, String schemaNameOrNull) {
        return this.metadata.listViews(session, schemaNameOrNull);
    }

    public Map<SchemaTableName, ConnectorViewDefinition> getViews(ConnectorSession session, SchemaTablePrefix prefix) {
        return this.metadata.getViews(session, prefix);
    }

    public boolean supportsMetadataDelete(ConnectorSession session, ConnectorTableHandle tableHandle, ConnectorTableLayoutHandle tableLayoutHandle) {
        return this.metadata.supportsMetadataDelete(session, tableHandle, tableLayoutHandle);
    }

    public OptionalLong metadataDelete(ConnectorSession session, ConnectorTableHandle tableHandle, ConnectorTableLayoutHandle tableLayoutHandle) {
        return this.metadata.metadataDelete(session, tableHandle, tableLayoutHandle);
    }

    public Optional<ConnectorResolvedIndex> resolveIndex(ConnectorSession session, ConnectorTableHandle tableHandle, Set<ColumnHandle> indexableColumns, Set<ColumnHandle> outputColumns, TupleDomain<ColumnHandle> tupleDomain) {
        return this.indexResolver.flatMap(indexResolver -> Optional.ofNullable(indexResolver.resolveIndex(session, tableHandle, indexableColumns, outputColumns, tupleDomain)));
    }

    public void grantTablePrivileges(ConnectorSession session, SchemaTableName tableName, Set<Privilege> privileges, String grantee, boolean grantOption) {
        this.metadata.grantTablePrivileges(session, tableName, privileges, grantee, grantOption);
    }

    private void setRollback(Runnable action) {
        Preconditions.checkState((boolean)this.rollbackAction.compareAndSet(null, action), (Object)"Should not have to override existing rollback action");
    }

    private void clearRollback() {
        this.rollbackAction.set(null);
    }

    public void tryRollback() {
        Runnable rollbackAction = this.rollbackAction.getAndSet(null);
        if (rollbackAction != null) {
            rollbackAction.run();
        }
    }
}

