/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.type.AbstractType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.type.TypeUtils;
import com.facebook.presto.util.ImmutableCollectors;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandle;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class FunctionType
extends AbstractType {
    public static final String NAME = "function";
    private final Type returnType;
    private final List<Type> argumentTypes;

    public FunctionType(List<Type> argumentTypes, Type returnType) {
        super(TypeUtils.parameterizedTypeName(NAME, FunctionType.typeParameters(argumentTypes, returnType)), MethodHandle.class);
        this.returnType = Objects.requireNonNull(returnType, "returnType is null");
        this.argumentTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(argumentTypes, "argumentTypes is null"));
    }

    private static TypeSignature[] typeParameters(List<Type> argumentTypes, Type returnType) {
        Objects.requireNonNull(returnType, "returnType is null");
        Objects.requireNonNull(argumentTypes, "argumentTypes is null");
        ImmutableList.Builder builder = ImmutableList.builder();
        argumentTypes.stream().map(Type::getTypeSignature).forEach(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        builder.add((Object)returnType.getTypeSignature());
        ImmutableList signatures = builder.build();
        return signatures.toArray(new TypeSignature[signatures.size()]);
    }

    public Type getReturnType() {
        return this.returnType;
    }

    public List<Type> getArgumentTypes() {
        return this.argumentTypes;
    }

    public Object getObjectValue(ConnectorSession session, Block block, int position) {
        throw new UnsupportedOperationException();
    }

    public void appendTo(Block block, int position, BlockBuilder blockBuilder) {
        throw new UnsupportedOperationException();
    }

    public BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries, int expectedBytesPerEntry) {
        throw new UnsupportedOperationException();
    }

    public BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        throw new UnsupportedOperationException();
    }

    public List<Type> getTypeParameters() {
        return ImmutableList.builder().addAll(this.argumentTypes).add((Object)this.returnType).build();
    }

    public String getDisplayName() {
        ImmutableList names = this.getTypeParameters().stream().map(Type::getDisplayName).collect(ImmutableCollectors.toImmutableList());
        return "function<" + Joiner.on((String)",").join(names) + ">";
    }
}

