/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.operator.scalar.ScalarFunction;
import com.facebook.presto.operator.scalar.ScalarOperator;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.type.DateTimeEncoding;
import com.facebook.presto.spi.type.TimeZoneKey;
import com.facebook.presto.type.DateTimeOperators;
import com.facebook.presto.type.SqlType;
import com.facebook.presto.util.DateTimeUtils;
import com.facebook.presto.util.DateTimeZoneIndex;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceUtf8;
import io.airlift.slice.Slices;
import java.util.concurrent.TimeUnit;
import org.joda.time.chrono.ISOChronology;

public final class TimestampWithTimeZoneOperators {
    private TimestampWithTimeZoneOperators() {
    }

    @ScalarOperator(value=OperatorType.EQUAL)
    @SqlType(value="boolean")
    public static boolean equal(@SqlType(value="timestamp with time zone") long left, @SqlType(value="timestamp with time zone") long right) {
        return DateTimeEncoding.unpackMillisUtc((long)left) == DateTimeEncoding.unpackMillisUtc((long)right);
    }

    @ScalarOperator(value=OperatorType.NOT_EQUAL)
    @SqlType(value="boolean")
    public static boolean notEqual(@SqlType(value="timestamp with time zone") long left, @SqlType(value="timestamp with time zone") long right) {
        return DateTimeEncoding.unpackMillisUtc((long)left) != DateTimeEncoding.unpackMillisUtc((long)right);
    }

    @ScalarOperator(value=OperatorType.LESS_THAN)
    @SqlType(value="boolean")
    public static boolean lessThan(@SqlType(value="timestamp with time zone") long left, @SqlType(value="timestamp with time zone") long right) {
        return DateTimeEncoding.unpackMillisUtc((long)left) < DateTimeEncoding.unpackMillisUtc((long)right);
    }

    @ScalarOperator(value=OperatorType.LESS_THAN_OR_EQUAL)
    @SqlType(value="boolean")
    public static boolean lessThanOrEqual(@SqlType(value="timestamp with time zone") long left, @SqlType(value="timestamp with time zone") long right) {
        return DateTimeEncoding.unpackMillisUtc((long)left) <= DateTimeEncoding.unpackMillisUtc((long)right);
    }

    @ScalarOperator(value=OperatorType.GREATER_THAN)
    @SqlType(value="boolean")
    public static boolean greaterThan(@SqlType(value="timestamp with time zone") long left, @SqlType(value="timestamp with time zone") long right) {
        return DateTimeEncoding.unpackMillisUtc((long)left) > DateTimeEncoding.unpackMillisUtc((long)right);
    }

    @ScalarOperator(value=OperatorType.GREATER_THAN_OR_EQUAL)
    @SqlType(value="boolean")
    public static boolean greaterThanOrEqual(@SqlType(value="timestamp with time zone") long left, @SqlType(value="timestamp with time zone") long right) {
        return DateTimeEncoding.unpackMillisUtc((long)left) >= DateTimeEncoding.unpackMillisUtc((long)right);
    }

    @ScalarOperator(value=OperatorType.BETWEEN)
    @SqlType(value="boolean")
    public static boolean between(@SqlType(value="timestamp with time zone") long value, @SqlType(value="timestamp with time zone") long min, @SqlType(value="timestamp with time zone") long max) {
        return DateTimeEncoding.unpackMillisUtc((long)min) <= DateTimeEncoding.unpackMillisUtc((long)value) && DateTimeEncoding.unpackMillisUtc((long)value) <= DateTimeEncoding.unpackMillisUtc((long)max);
    }

    @ScalarFunction(value="date")
    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="date")
    public static long castToDate(@SqlType(value="timestamp with time zone") long value) {
        ISOChronology chronology = DateTimeZoneIndex.unpackChronology(value);
        long date = chronology.dayOfYear().roundFloor(DateTimeEncoding.unpackMillisUtc((long)value));
        long millis = date + (long)chronology.getZone().getOffset(date);
        return TimeUnit.MILLISECONDS.toDays(millis);
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="time")
    public static long castToTime(@SqlType(value="timestamp with time zone") long value) {
        return DateTimeOperators.modulo24Hour(DateTimeZoneIndex.unpackChronology(value), DateTimeEncoding.unpackMillisUtc((long)value));
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="time with time zone")
    public static long castToTimeWithTimeZone(@SqlType(value="timestamp with time zone") long value) {
        int millis = DateTimeOperators.modulo24Hour(DateTimeZoneIndex.unpackChronology(value), DateTimeEncoding.unpackMillisUtc((long)value));
        return DateTimeEncoding.packDateTimeWithZone((long)millis, (TimeZoneKey)DateTimeEncoding.unpackZoneKey((long)value));
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="timestamp")
    public static long castToTimestamp(@SqlType(value="timestamp with time zone") long value) {
        return DateTimeEncoding.unpackMillisUtc((long)value);
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="varchar")
    public static Slice castToSlice(@SqlType(value="timestamp with time zone") long value) {
        return Slices.utf8Slice((String)DateTimeUtils.printTimestampWithTimeZone(value));
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="timestamp with time zone")
    public static long castFromSlice(ConnectorSession session, @SqlType(value="varchar") Slice value) {
        try {
            return DateTimeUtils.parseTimestampWithTimeZone(session.getTimeZoneKey(), SliceUtf8.trim((Slice)value).toStringUtf8());
        }
        catch (IllegalArgumentException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "Value cannot be cast to timestamp with time zone: " + value.toStringUtf8(), (Throwable)e);
        }
    }

    @ScalarOperator(value=OperatorType.HASH_CODE)
    @SqlType(value="bigint")
    public static long hashCode(@SqlType(value="timestamp with time zone") long value) {
        long millis = DateTimeEncoding.unpackMillisUtc((long)value);
        return (int)(millis ^ millis >>> 32);
    }
}

