/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeParameter;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.type.ParametricType;
import java.util.List;

public class VarcharParametricType
implements ParametricType {
    public static final VarcharParametricType VARCHAR = new VarcharParametricType();

    @Override
    public String getName() {
        return "varchar";
    }

    @Override
    public Type createType(List<TypeParameter> parameters) {
        if (parameters.isEmpty()) {
            return VarcharType.createVarcharType((int)Integer.MAX_VALUE);
        }
        if (parameters.size() != 1) {
            throw new IllegalArgumentException("Expected at most one parameter for VARCHAR");
        }
        TypeParameter parameter = parameters.get(0);
        if (!parameter.isLongLiteral()) {
            throw new IllegalArgumentException("VARCHAR length must be a number");
        }
        long length = parameter.getLongLiteral();
        if (length < 0L || length > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Invalid VARCHAR length " + length);
        }
        return VarcharType.createVarcharType((int)((int)length));
    }
}

