/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.kafka;

import com.facebook.presto.kafka.KafkaConnector;
import com.facebook.presto.kafka.KafkaConnectorId;
import com.facebook.presto.kafka.KafkaConnectorModule;
import com.facebook.presto.kafka.KafkaHandleResolver;
import com.facebook.presto.kafka.KafkaTableDescriptionSupplier;
import com.facebook.presto.kafka.KafkaTopicDescription;
import com.facebook.presto.spi.ConnectorHandleResolver;
import com.facebook.presto.spi.NodeManager;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.connector.Connector;
import com.facebook.presto.spi.connector.ConnectorFactory;
import com.facebook.presto.spi.type.TypeManager;
import com.google.common.base.Throwables;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import io.airlift.bootstrap.Bootstrap;
import io.airlift.json.JsonModule;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;

public class KafkaConnectorFactory
implements ConnectorFactory {
    private final TypeManager typeManager;
    private final NodeManager nodeManager;
    private final Optional<Supplier<Map<SchemaTableName, KafkaTopicDescription>>> tableDescriptionSupplier;
    private final Map<String, String> optionalConfig;

    KafkaConnectorFactory(TypeManager typeManager, NodeManager nodeManager, Optional<Supplier<Map<SchemaTableName, KafkaTopicDescription>>> tableDescriptionSupplier, Map<String, String> optionalConfig) {
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager is null");
        this.optionalConfig = Objects.requireNonNull(optionalConfig, "optionalConfig is null");
        this.tableDescriptionSupplier = Objects.requireNonNull(tableDescriptionSupplier, "tableDescriptionSupplier is null");
    }

    public String getName() {
        return "kafka";
    }

    public ConnectorHandleResolver getHandleResolver() {
        return new KafkaHandleResolver();
    }

    public Connector create(String connectorId, Map<String, String> config) {
        Objects.requireNonNull(connectorId, "connectorId is null");
        Objects.requireNonNull(config, "config is null");
        try {
            Bootstrap app = new Bootstrap(new Module[]{new JsonModule(), new KafkaConnectorModule(), binder -> {
                binder.bind(KafkaConnectorId.class).toInstance((Object)new KafkaConnectorId(connectorId));
                binder.bind(TypeManager.class).toInstance((Object)this.typeManager);
                binder.bind(NodeManager.class).toInstance((Object)this.nodeManager);
                if (this.tableDescriptionSupplier.isPresent()) {
                    binder.bind((TypeLiteral)new TypeLiteral<Supplier<Map<SchemaTableName, KafkaTopicDescription>>>(){}).toInstance(this.tableDescriptionSupplier.get());
                } else {
                    binder.bind((TypeLiteral)new TypeLiteral<Supplier<Map<SchemaTableName, KafkaTopicDescription>>>(){}).to(KafkaTableDescriptionSupplier.class).in(Scopes.SINGLETON);
                }
            }});
            Injector injector = app.strictConfig().doNotInitializeLogging().setRequiredConfigurationProperties(config).setOptionalConfigurationProperties(this.optionalConfig).initialize();
            return (Connector)injector.getInstance(KafkaConnector.class);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

