/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.kafka;

import com.facebook.presto.decoder.DecoderColumnHandle;
import com.facebook.presto.decoder.FieldValueProvider;
import com.facebook.presto.kafka.KafkaColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.Objects;
import java.util.Set;

public class KafkaInternalFieldDescription {
    public static final KafkaInternalFieldDescription PARTITION_ID_FIELD = new KafkaInternalFieldDescription("_partition_id", (Type)BigintType.BIGINT, "Partition Id");
    public static final KafkaInternalFieldDescription PARTITION_OFFSET_FIELD = new KafkaInternalFieldDescription("_partition_offset", (Type)BigintType.BIGINT, "Offset for the message within the partition");
    public static final KafkaInternalFieldDescription SEGMENT_START_FIELD = new KafkaInternalFieldDescription("_segment_start", (Type)BigintType.BIGINT, "Segment start offset");
    public static final KafkaInternalFieldDescription SEGMENT_END_FIELD = new KafkaInternalFieldDescription("_segment_end", (Type)BigintType.BIGINT, "Segment end offset");
    public static final KafkaInternalFieldDescription SEGMENT_COUNT_FIELD = new KafkaInternalFieldDescription("_segment_count", (Type)BigintType.BIGINT, "Running message count per segment");
    public static final KafkaInternalFieldDescription MESSAGE_CORRUPT_FIELD = new KafkaInternalFieldDescription("_message_corrupt", (Type)BooleanType.BOOLEAN, "Message data is corrupt");
    public static final KafkaInternalFieldDescription MESSAGE_FIELD = new KafkaInternalFieldDescription("_message", (Type)VarcharType.VARCHAR, "Message text");
    public static final KafkaInternalFieldDescription MESSAGE_LENGTH_FIELD = new KafkaInternalFieldDescription("_message_length", (Type)BigintType.BIGINT, "Total number of message bytes");
    public static final KafkaInternalFieldDescription KEY_CORRUPT_FIELD = new KafkaInternalFieldDescription("_key_corrupt", (Type)BooleanType.BOOLEAN, "Key data is corrupt");
    public static final KafkaInternalFieldDescription KEY_FIELD = new KafkaInternalFieldDescription("_key", (Type)VarcharType.VARCHAR, "Key text");
    public static final KafkaInternalFieldDescription KEY_LENGTH_FIELD = new KafkaInternalFieldDescription("_key_length", (Type)BigintType.BIGINT, "Total number of key bytes");
    private final String name;
    private final Type type;
    private final String comment;

    public static Set<KafkaInternalFieldDescription> getInternalFields() {
        return ImmutableSet.of((Object)PARTITION_ID_FIELD, (Object)PARTITION_OFFSET_FIELD, (Object)SEGMENT_START_FIELD, (Object)SEGMENT_END_FIELD, (Object)SEGMENT_COUNT_FIELD, (Object)KEY_FIELD, (Object[])new KafkaInternalFieldDescription[]{KEY_CORRUPT_FIELD, KEY_LENGTH_FIELD, MESSAGE_FIELD, MESSAGE_CORRUPT_FIELD, MESSAGE_LENGTH_FIELD});
    }

    KafkaInternalFieldDescription(String name, Type type, String comment) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"name is null or is empty");
        this.name = name;
        this.type = Objects.requireNonNull(type, "type is null");
        this.comment = Objects.requireNonNull(comment, "comment is null");
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    KafkaColumnHandle getColumnHandle(String connectorId, int index, boolean hidden) {
        return new KafkaColumnHandle(connectorId, index, this.getName(), this.getType(), null, null, null, false, hidden, true);
    }

    ColumnMetadata getColumnMetadata(boolean hidden) {
        return new ColumnMetadata(this.name, this.type, this.comment, hidden);
    }

    public FieldValueProvider forBooleanValue(boolean value) {
        return new BooleanKafkaFieldValueProvider(value);
    }

    public FieldValueProvider forLongValue(long value) {
        return new LongKafkaFieldValueProvider(value);
    }

    public FieldValueProvider forByteValue(byte[] value) {
        return new BytesKafkaFieldValueProvider(value);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        KafkaInternalFieldDescription other = (KafkaInternalFieldDescription)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.type, other.type);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("type", (Object)this.type).toString();
    }

    public class BytesKafkaFieldValueProvider
    extends FieldValueProvider {
        private final byte[] value;

        private BytesKafkaFieldValueProvider(byte[] value) {
            this.value = value;
        }

        public boolean accept(DecoderColumnHandle columnHandle) {
            return columnHandle.getName().equals(KafkaInternalFieldDescription.this.name);
        }

        public Slice getSlice() {
            return this.isNull() ? Slices.EMPTY_SLICE : Slices.wrappedBuffer((byte[])this.value);
        }

        public boolean isNull() {
            return this.value == null || this.value.length == 0;
        }
    }

    public class LongKafkaFieldValueProvider
    extends FieldValueProvider {
        private final long value;

        private LongKafkaFieldValueProvider(long value) {
            this.value = value;
        }

        public boolean accept(DecoderColumnHandle columnHandle) {
            return columnHandle.getName().equals(KafkaInternalFieldDescription.this.name);
        }

        public long getLong() {
            return this.value;
        }

        public boolean isNull() {
            return false;
        }
    }

    public class BooleanKafkaFieldValueProvider
    extends FieldValueProvider {
        private final boolean value;

        private BooleanKafkaFieldValueProvider(boolean value) {
            this.value = value;
        }

        public boolean accept(DecoderColumnHandle columnHandle) {
            return columnHandle.getName().equals(KafkaInternalFieldDescription.this.name);
        }

        public boolean getBoolean() {
            return this.value;
        }

        public boolean isNull() {
            return false;
        }
    }
}

