/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.kafka;

import com.facebook.presto.kafka.KafkaConnectorConfig;
import com.facebook.presto.kafka.KafkaConnectorId;
import com.facebook.presto.kafka.KafkaHandleResolver;
import com.facebook.presto.kafka.KafkaInternalFieldDescription;
import com.facebook.presto.kafka.KafkaTableHandle;
import com.facebook.presto.kafka.KafkaTableLayoutHandle;
import com.facebook.presto.kafka.KafkaTopicDescription;
import com.facebook.presto.kafka.KafkaTopicFieldDescription;
import com.facebook.presto.kafka.KafkaTopicFieldGroup;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableLayout;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.ConnectorTableLayoutResult;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SchemaTablePrefix;
import com.facebook.presto.spi.TableNotFoundException;
import com.facebook.presto.spi.connector.ConnectorMetadata;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import javax.inject.Inject;

public class KafkaMetadata
implements ConnectorMetadata {
    private final String connectorId;
    private final boolean hideInternalColumns;
    private final Map<SchemaTableName, KafkaTopicDescription> tableDescriptions;
    private final Set<KafkaInternalFieldDescription> internalFieldDescriptions;

    @Inject
    public KafkaMetadata(KafkaConnectorId connectorId, KafkaConnectorConfig kafkaConnectorConfig, Supplier<Map<SchemaTableName, KafkaTopicDescription>> kafkaTableDescriptionSupplier, Set<KafkaInternalFieldDescription> internalFieldDescriptions) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null").toString();
        Objects.requireNonNull(kafkaConnectorConfig, "kafkaConfig is null");
        this.hideInternalColumns = kafkaConnectorConfig.isHideInternalColumns();
        Objects.requireNonNull(kafkaTableDescriptionSupplier, "kafkaTableDescriptionSupplier is null");
        this.tableDescriptions = kafkaTableDescriptionSupplier.get();
        this.internalFieldDescriptions = Objects.requireNonNull(internalFieldDescriptions, "internalFieldDescriptions is null");
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (SchemaTableName tableName : this.tableDescriptions.keySet()) {
            builder.add((Object)tableName.getSchemaName());
        }
        return ImmutableList.copyOf((Collection)builder.build());
    }

    public KafkaTableHandle getTableHandle(ConnectorSession session, SchemaTableName schemaTableName) {
        KafkaTopicDescription table = this.tableDescriptions.get(schemaTableName);
        if (table == null) {
            return null;
        }
        return new KafkaTableHandle(this.connectorId, schemaTableName.getSchemaName(), schemaTableName.getTableName(), table.getTopicName(), KafkaMetadata.getDataFormat(table.getKey()), KafkaMetadata.getDataFormat(table.getMessage()));
    }

    private static String getDataFormat(KafkaTopicFieldGroup fieldGroup) {
        return fieldGroup == null ? "dummy" : fieldGroup.getDataFormat();
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle tableHandle) {
        return this.getTableMetadata(KafkaHandleResolver.convertTableHandle(tableHandle).toSchemaTableName());
    }

    public List<SchemaTableName> listTables(ConnectorSession session, String schemaNameOrNull) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (SchemaTableName tableName : this.tableDescriptions.keySet()) {
            if (schemaNameOrNull != null && !tableName.getSchemaName().equals(schemaNameOrNull)) continue;
            builder.add((Object)tableName);
        }
        return builder.build();
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        List<KafkaTopicFieldDescription> fields;
        KafkaTopicFieldGroup message;
        List<KafkaTopicFieldDescription> fields2;
        KafkaTableHandle kafkaTableHandle = KafkaHandleResolver.convertTableHandle(tableHandle);
        KafkaTopicDescription kafkaTopicDescription = this.tableDescriptions.get(kafkaTableHandle.toSchemaTableName());
        if (kafkaTopicDescription == null) {
            throw new TableNotFoundException(kafkaTableHandle.toSchemaTableName());
        }
        ImmutableMap.Builder columnHandles = ImmutableMap.builder();
        int index = 0;
        KafkaTopicFieldGroup key = kafkaTopicDescription.getKey();
        if (key != null && (fields2 = key.getFields()) != null) {
            for (KafkaTopicFieldDescription kafkaTopicFieldDescription : fields2) {
                columnHandles.put((Object)kafkaTopicFieldDescription.getName(), (Object)kafkaTopicFieldDescription.getColumnHandle(this.connectorId, true, index++));
            }
        }
        if ((message = kafkaTopicDescription.getMessage()) != null && (fields = message.getFields()) != null) {
            for (KafkaTopicFieldDescription kafkaTopicFieldDescription : fields) {
                columnHandles.put((Object)kafkaTopicFieldDescription.getName(), (Object)kafkaTopicFieldDescription.getColumnHandle(this.connectorId, false, index++));
            }
        }
        for (KafkaInternalFieldDescription kafkaInternalFieldDescription : this.internalFieldDescriptions) {
            columnHandles.put((Object)kafkaInternalFieldDescription.getName(), (Object)kafkaInternalFieldDescription.getColumnHandle(this.connectorId, index++, this.hideInternalColumns));
        }
        return columnHandles.build();
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        Objects.requireNonNull(prefix, "prefix is null");
        ImmutableMap.Builder columns = ImmutableMap.builder();
        ImmutableList tableNames = prefix.getSchemaName() == null ? this.listTables(session, null) : ImmutableList.of((Object)new SchemaTableName(prefix.getSchemaName(), prefix.getTableName()));
        for (SchemaTableName tableName : tableNames) {
            ConnectorTableMetadata tableMetadata = this.getTableMetadata(tableName);
            if (tableMetadata == null) continue;
            columns.put((Object)tableName, (Object)tableMetadata.getColumns());
        }
        return columns.build();
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        KafkaHandleResolver.convertTableHandle(tableHandle);
        return KafkaHandleResolver.convertColumnHandle(columnHandle).getColumnMetadata();
    }

    public List<ConnectorTableLayoutResult> getTableLayouts(ConnectorSession session, ConnectorTableHandle table, Constraint<ColumnHandle> constraint, Optional<Set<ColumnHandle>> desiredColumns) {
        KafkaTableHandle handle = KafkaHandleResolver.convertTableHandle(table);
        ConnectorTableLayout layout = new ConnectorTableLayout((ConnectorTableLayoutHandle)new KafkaTableLayoutHandle(handle));
        return ImmutableList.of((Object)new ConnectorTableLayoutResult(layout, constraint.getSummary()));
    }

    public ConnectorTableLayout getTableLayout(ConnectorSession session, ConnectorTableLayoutHandle handle) {
        return new ConnectorTableLayout(handle);
    }

    private ConnectorTableMetadata getTableMetadata(SchemaTableName schemaTableName) {
        List<KafkaTopicFieldDescription> fields;
        KafkaTopicFieldGroup message;
        List<KafkaTopicFieldDescription> fields2;
        KafkaTopicDescription table = this.tableDescriptions.get(schemaTableName);
        if (table == null) {
            throw new TableNotFoundException(schemaTableName);
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        KafkaTopicFieldGroup key = table.getKey();
        if (key != null && (fields2 = key.getFields()) != null) {
            for (KafkaTopicFieldDescription kafkaTopicFieldDescription : fields2) {
                builder.add((Object)kafkaTopicFieldDescription.getColumnMetadata());
            }
        }
        if ((message = table.getMessage()) != null && (fields = message.getFields()) != null) {
            for (KafkaTopicFieldDescription fieldDescription : fields) {
                builder.add((Object)fieldDescription.getColumnMetadata());
            }
        }
        for (KafkaInternalFieldDescription kafkaInternalFieldDescription : this.internalFieldDescriptions) {
            builder.add((Object)kafkaInternalFieldDescription.getColumnMetadata(this.hideInternalColumns));
        }
        return new ConnectorTableMetadata(schemaTableName, (List)builder.build());
    }
}

