/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.kafka;

import com.facebook.presto.kafka.KafkaConnectorFactory;
import com.facebook.presto.kafka.KafkaTopicDescription;
import com.facebook.presto.spi.NodeManager;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.connector.ConnectorFactory;
import com.facebook.presto.spi.type.TypeManager;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.inject.Inject;

public class KafkaPlugin
implements Plugin {
    private TypeManager typeManager;
    private NodeManager nodeManager;
    private Optional<Supplier<Map<SchemaTableName, KafkaTopicDescription>>> tableDescriptionSupplier = Optional.empty();
    private Map<String, String> optionalConfig = ImmutableMap.of();

    public synchronized void setOptionalConfig(Map<String, String> optionalConfig) {
        this.optionalConfig = ImmutableMap.copyOf(Objects.requireNonNull(optionalConfig, "optionalConfig is null"));
    }

    @Inject
    public synchronized void setTypeManager(TypeManager typeManager) {
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
    }

    @Inject
    public synchronized void setNodeManager(NodeManager nodeManager) {
        this.nodeManager = Objects.requireNonNull(nodeManager, "node is null");
    }

    @VisibleForTesting
    public synchronized void setTableDescriptionSupplier(Supplier<Map<SchemaTableName, KafkaTopicDescription>> tableDescriptionSupplier) {
        this.tableDescriptionSupplier = Optional.of(Objects.requireNonNull(tableDescriptionSupplier, "tableDescriptionSupplier is null"));
    }

    public synchronized <T> List<T> getServices(Class<T> type) {
        if (type == ConnectorFactory.class) {
            return ImmutableList.of(type.cast(new KafkaConnectorFactory(this.typeManager, this.nodeManager, this.tableDescriptionSupplier, this.optionalConfig)));
        }
        return ImmutableList.of();
    }
}

