/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.kafka;

import com.facebook.presto.decoder.DecoderColumnHandle;
import com.facebook.presto.decoder.FieldDecoder;
import com.facebook.presto.decoder.FieldValueProvider;
import com.facebook.presto.decoder.RowDecoder;
import com.facebook.presto.kafka.KafkaErrorCode;
import com.facebook.presto.kafka.KafkaInternalFieldDescription;
import com.facebook.presto.kafka.KafkaSimpleConsumerManager;
import com.facebook.presto.kafka.KafkaSplit;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.RecordSet;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.log.Logger;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.api.FetchRequest;
import kafka.api.FetchRequestBuilder;
import kafka.javaapi.FetchResponse;
import kafka.javaapi.consumer.SimpleConsumer;
import kafka.message.MessageAndOffset;

public class KafkaRecordSet
implements RecordSet {
    private static final Logger log = Logger.get(KafkaRecordSet.class);
    private static final int KAFKA_READ_BUFFER_SIZE = 100000;
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private final KafkaSplit split;
    private final KafkaSimpleConsumerManager consumerManager;
    private final RowDecoder keyDecoder;
    private final RowDecoder messageDecoder;
    private final Map<DecoderColumnHandle, FieldDecoder<?>> keyFieldDecoders;
    private final Map<DecoderColumnHandle, FieldDecoder<?>> messageFieldDecoders;
    private final List<DecoderColumnHandle> columnHandles;
    private final List<Type> columnTypes;
    private final Set<FieldValueProvider> globalInternalFieldValueProviders;

    KafkaRecordSet(KafkaSplit split, KafkaSimpleConsumerManager consumerManager, List<DecoderColumnHandle> columnHandles, RowDecoder keyDecoder, RowDecoder messageDecoder, Map<DecoderColumnHandle, FieldDecoder<?>> keyFieldDecoders, Map<DecoderColumnHandle, FieldDecoder<?>> messageFieldDecoders) {
        this.split = Objects.requireNonNull(split, "split is null");
        this.globalInternalFieldValueProviders = ImmutableSet.of((Object)KafkaInternalFieldDescription.PARTITION_ID_FIELD.forLongValue(split.getPartitionId()), (Object)KafkaInternalFieldDescription.SEGMENT_START_FIELD.forLongValue(split.getStart()), (Object)KafkaInternalFieldDescription.SEGMENT_END_FIELD.forLongValue(split.getEnd()));
        this.consumerManager = Objects.requireNonNull(consumerManager, "consumerManager is null");
        this.keyDecoder = Objects.requireNonNull(keyDecoder, "rowDecoder is null");
        this.messageDecoder = Objects.requireNonNull(messageDecoder, "rowDecoder is null");
        this.keyFieldDecoders = Objects.requireNonNull(keyFieldDecoders, "keyFieldDecoders is null");
        this.messageFieldDecoders = Objects.requireNonNull(messageFieldDecoders, "messageFieldDecoders is null");
        this.columnHandles = Objects.requireNonNull(columnHandles, "columnHandles is null");
        ImmutableList.Builder typeBuilder = ImmutableList.builder();
        for (DecoderColumnHandle handle : columnHandles) {
            typeBuilder.add((Object)handle.getType());
        }
        this.columnTypes = typeBuilder.build();
    }

    public List<Type> getColumnTypes() {
        return this.columnTypes;
    }

    public RecordCursor cursor() {
        return new KafkaRecordCursor();
    }

    public class KafkaRecordCursor
    implements RecordCursor {
        private long totalBytes;
        private long totalMessages;
        private long cursorOffset;
        private Iterator<MessageAndOffset> messageAndOffsetIterator;
        private final AtomicBoolean reported;
        private FieldValueProvider[] fieldValueProviders;

        KafkaRecordCursor() {
            this.cursorOffset = KafkaRecordSet.this.split.getStart();
            this.reported = new AtomicBoolean();
        }

        public long getTotalBytes() {
            return this.totalBytes;
        }

        public long getCompletedBytes() {
            return this.totalBytes;
        }

        public long getReadTimeNanos() {
            return 0L;
        }

        public Type getType(int field) {
            Preconditions.checkArgument((field < KafkaRecordSet.this.columnHandles.size() ? 1 : 0) != 0, (Object)"Invalid field index");
            return ((DecoderColumnHandle)KafkaRecordSet.this.columnHandles.get(field)).getType();
        }

        public boolean advanceNextPosition() {
            while (this.cursorOffset < KafkaRecordSet.this.split.getEnd()) {
                this.openFetchRequest();
                while (this.messageAndOffsetIterator.hasNext()) {
                    MessageAndOffset currentMessageAndOffset = this.messageAndOffsetIterator.next();
                    long messageOffset = currentMessageAndOffset.offset();
                    if (messageOffset >= KafkaRecordSet.this.split.getEnd()) {
                        return this.endOfData();
                    }
                    if (messageOffset < this.cursorOffset) continue;
                    return this.nextRow(currentMessageAndOffset);
                }
                this.messageAndOffsetIterator = null;
            }
            return this.endOfData();
        }

        private boolean endOfData() {
            if (!this.reported.getAndSet(true)) {
                log.debug("Found a total of %d messages with %d bytes (%d messages expected). Last Offset: %d (%d, %d)", new Object[]{this.totalMessages, this.totalBytes, KafkaRecordSet.this.split.getEnd() - KafkaRecordSet.this.split.getStart(), this.cursorOffset, KafkaRecordSet.this.split.getStart(), KafkaRecordSet.this.split.getEnd()});
            }
            return false;
        }

        private boolean nextRow(MessageAndOffset messageAndOffset) {
            ByteBuffer message;
            this.cursorOffset = messageAndOffset.offset() + 1L;
            this.totalBytes += (long)messageAndOffset.message().payloadSize();
            ++this.totalMessages;
            byte[] keyData = EMPTY_BYTE_ARRAY;
            byte[] messageData = EMPTY_BYTE_ARRAY;
            ByteBuffer key = messageAndOffset.message().key();
            if (key != null) {
                keyData = new byte[key.remaining()];
                key.get(keyData);
            }
            if ((message = messageAndOffset.message().payload()) != null) {
                messageData = new byte[message.remaining()];
                message.get(messageData);
            }
            HashSet<FieldValueProvider> fieldValueProviders = new HashSet<FieldValueProvider>();
            fieldValueProviders.addAll(KafkaRecordSet.this.globalInternalFieldValueProviders);
            fieldValueProviders.add(KafkaInternalFieldDescription.SEGMENT_COUNT_FIELD.forLongValue(this.totalMessages));
            fieldValueProviders.add(KafkaInternalFieldDescription.PARTITION_OFFSET_FIELD.forLongValue(messageAndOffset.offset()));
            fieldValueProviders.add(KafkaInternalFieldDescription.MESSAGE_FIELD.forByteValue(messageData));
            fieldValueProviders.add(KafkaInternalFieldDescription.MESSAGE_LENGTH_FIELD.forLongValue(messageData.length));
            fieldValueProviders.add(KafkaInternalFieldDescription.KEY_FIELD.forByteValue(keyData));
            fieldValueProviders.add(KafkaInternalFieldDescription.KEY_LENGTH_FIELD.forLongValue(keyData.length));
            fieldValueProviders.add(KafkaInternalFieldDescription.KEY_CORRUPT_FIELD.forBooleanValue(KafkaRecordSet.this.keyDecoder.decodeRow(keyData, null, fieldValueProviders, KafkaRecordSet.this.columnHandles, KafkaRecordSet.this.keyFieldDecoders)));
            fieldValueProviders.add(KafkaInternalFieldDescription.MESSAGE_CORRUPT_FIELD.forBooleanValue(KafkaRecordSet.this.messageDecoder.decodeRow(messageData, null, fieldValueProviders, KafkaRecordSet.this.columnHandles, KafkaRecordSet.this.messageFieldDecoders)));
            this.fieldValueProviders = new FieldValueProvider[KafkaRecordSet.this.columnHandles.size()];
            block0: for (int i = 0; i < KafkaRecordSet.this.columnHandles.size(); ++i) {
                for (FieldValueProvider fieldValueProvider : fieldValueProviders) {
                    if (!fieldValueProvider.accept((DecoderColumnHandle)KafkaRecordSet.this.columnHandles.get(i))) continue;
                    this.fieldValueProviders[i] = fieldValueProvider;
                    continue block0;
                }
            }
            return true;
        }

        public boolean getBoolean(int field) {
            Preconditions.checkArgument((field < KafkaRecordSet.this.columnHandles.size() ? 1 : 0) != 0, (Object)"Invalid field index");
            this.checkFieldType(field, Boolean.TYPE);
            return this.isNull(field) ? false : this.fieldValueProviders[field].getBoolean();
        }

        public long getLong(int field) {
            Preconditions.checkArgument((field < KafkaRecordSet.this.columnHandles.size() ? 1 : 0) != 0, (Object)"Invalid field index");
            this.checkFieldType(field, Long.TYPE);
            return this.isNull(field) ? 0L : this.fieldValueProviders[field].getLong();
        }

        public double getDouble(int field) {
            Preconditions.checkArgument((field < KafkaRecordSet.this.columnHandles.size() ? 1 : 0) != 0, (Object)"Invalid field index");
            this.checkFieldType(field, Double.TYPE);
            return this.isNull(field) ? 0.0 : this.fieldValueProviders[field].getDouble();
        }

        public Slice getSlice(int field) {
            Preconditions.checkArgument((field < KafkaRecordSet.this.columnHandles.size() ? 1 : 0) != 0, (Object)"Invalid field index");
            this.checkFieldType(field, Slice.class);
            return this.isNull(field) ? Slices.EMPTY_SLICE : this.fieldValueProviders[field].getSlice();
        }

        public Object getObject(int field) {
            throw new UnsupportedOperationException();
        }

        public boolean isNull(int field) {
            Preconditions.checkArgument((field < KafkaRecordSet.this.columnHandles.size() ? 1 : 0) != 0, (Object)"Invalid field index");
            return this.fieldValueProviders[field] == null || this.fieldValueProviders[field].isNull();
        }

        private void checkFieldType(int field, Class<?> expected) {
            Class actual = this.getType(field).getJavaType();
            Preconditions.checkArgument((actual == expected ? 1 : 0) != 0, (String)"Expected field %s to be type %s but is %s", (Object[])new Object[]{field, expected, actual});
        }

        public void close() {
        }

        private void openFetchRequest() {
            if (this.messageAndOffsetIterator == null) {
                log.debug("Fetching %d bytes from offset %d (%d - %d). %d messages read so far", new Object[]{100000, this.cursorOffset, KafkaRecordSet.this.split.getStart(), KafkaRecordSet.this.split.getEnd(), this.totalMessages});
                FetchRequest req = new FetchRequestBuilder().clientId("presto-worker-" + Thread.currentThread().getName()).addFetch(KafkaRecordSet.this.split.getTopicName(), KafkaRecordSet.this.split.getPartitionId(), this.cursorOffset, 100000).build();
                SimpleConsumer consumer = KafkaRecordSet.this.consumerManager.getConsumer(KafkaRecordSet.this.split.getNodes().get(0));
                FetchResponse fetchResponse = consumer.fetch(req);
                if (fetchResponse.hasError()) {
                    short errorCode = fetchResponse.errorCode(KafkaRecordSet.this.split.getTopicName(), KafkaRecordSet.this.split.getPartitionId());
                    log.warn("Fetch response has error: %d", new Object[]{errorCode});
                    throw new PrestoException((ErrorCodeSupplier)KafkaErrorCode.KAFKA_SPLIT_ERROR, "could not fetch data from Kafka, error code is '" + errorCode + "'");
                }
                this.messageAndOffsetIterator = fetchResponse.messageSet(KafkaRecordSet.this.split.getTopicName(), KafkaRecordSet.this.split.getPartitionId()).iterator();
            }
        }
    }
}

