/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.kafka;

import com.facebook.presto.decoder.DecoderColumnHandle;
import com.facebook.presto.decoder.DecoderRegistry;
import com.facebook.presto.decoder.FieldDecoder;
import com.facebook.presto.decoder.RowDecoder;
import com.facebook.presto.kafka.KafkaColumnHandle;
import com.facebook.presto.kafka.KafkaHandleResolver;
import com.facebook.presto.kafka.KafkaRecordSet;
import com.facebook.presto.kafka.KafkaSimpleConsumerManager;
import com.facebook.presto.kafka.KafkaSplit;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.RecordSet;
import com.facebook.presto.spi.connector.ConnectorRecordSetProvider;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;

public class KafkaRecordSetProvider
implements ConnectorRecordSetProvider {
    private final KafkaSimpleConsumerManager consumerManager;
    private final DecoderRegistry registry;

    @Inject
    public KafkaRecordSetProvider(DecoderRegistry registry, KafkaSimpleConsumerManager consumerManager) {
        this.registry = Objects.requireNonNull(registry, "registry is null");
        this.consumerManager = Objects.requireNonNull(consumerManager, "consumerManager is null");
    }

    public RecordSet getRecordSet(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorSplit split, List<? extends ColumnHandle> columns) {
        KafkaSplit kafkaSplit = KafkaHandleResolver.convertSplit(split);
        ImmutableList.Builder handleBuilder = ImmutableList.builder();
        ImmutableMap.Builder keyFieldDecoderBuilder = ImmutableMap.builder();
        ImmutableMap.Builder messageFieldDecoderBuilder = ImmutableMap.builder();
        RowDecoder keyDecoder = this.registry.getRowDecoder(kafkaSplit.getKeyDataFormat());
        RowDecoder messageDecoder = this.registry.getRowDecoder(kafkaSplit.getMessageDataFormat());
        for (ColumnHandle columnHandle : columns) {
            FieldDecoder fieldDecoder;
            KafkaColumnHandle columnHandle2 = KafkaHandleResolver.convertColumnHandle(columnHandle);
            handleBuilder.add((Object)columnHandle2);
            if (columnHandle2.isInternal()) continue;
            if (columnHandle2.isKeyDecoder()) {
                fieldDecoder = this.registry.getFieldDecoder(kafkaSplit.getKeyDataFormat(), columnHandle2.getType().getJavaType(), columnHandle2.getDataFormat());
                keyFieldDecoderBuilder.put((Object)columnHandle2, (Object)fieldDecoder);
                continue;
            }
            fieldDecoder = this.registry.getFieldDecoder(kafkaSplit.getMessageDataFormat(), columnHandle2.getType().getJavaType(), columnHandle2.getDataFormat());
            messageFieldDecoderBuilder.put((Object)columnHandle2, (Object)fieldDecoder);
        }
        ImmutableList handles = handleBuilder.build();
        ImmutableMap immutableMap = keyFieldDecoderBuilder.build();
        ImmutableMap messageFieldDecoders = messageFieldDecoderBuilder.build();
        return new KafkaRecordSet(kafkaSplit, this.consumerManager, (List<DecoderColumnHandle>)handles, keyDecoder, messageDecoder, (Map<DecoderColumnHandle, FieldDecoder<?>>)immutableMap, (Map<DecoderColumnHandle, FieldDecoder<?>>)messageFieldDecoders);
    }
}

