/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.kafka;

import com.facebook.presto.kafka.KafkaConnectorConfig;
import com.facebook.presto.kafka.KafkaConnectorId;
import com.facebook.presto.kafka.KafkaErrorCode;
import com.facebook.presto.kafka.KafkaHandleResolver;
import com.facebook.presto.kafka.KafkaSimpleConsumerManager;
import com.facebook.presto.kafka.KafkaSplit;
import com.facebook.presto.kafka.KafkaTableHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplitSource;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.FixedSplitSource;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.connector.ConnectorSplitManager;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import io.airlift.log.Logger;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import javax.inject.Inject;
import kafka.api.PartitionOffsetRequestInfo;
import kafka.cluster.Broker;
import kafka.common.TopicAndPartition;
import kafka.javaapi.OffsetRequest;
import kafka.javaapi.OffsetResponse;
import kafka.javaapi.PartitionMetadata;
import kafka.javaapi.TopicMetadata;
import kafka.javaapi.TopicMetadataRequest;
import kafka.javaapi.TopicMetadataResponse;
import kafka.javaapi.consumer.SimpleConsumer;

public class KafkaSplitManager
implements ConnectorSplitManager {
    private static final Logger log = Logger.get(KafkaSplitManager.class);
    private final String connectorId;
    private final KafkaSimpleConsumerManager consumerManager;
    private final Set<HostAddress> nodes;

    @Inject
    public KafkaSplitManager(KafkaConnectorId connectorId, KafkaConnectorConfig kafkaConnectorConfig, KafkaSimpleConsumerManager consumerManager) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null").toString();
        this.consumerManager = Objects.requireNonNull(consumerManager, "consumerManager is null");
        Objects.requireNonNull(kafkaConnectorConfig, "kafkaConfig is null");
        this.nodes = ImmutableSet.copyOf(kafkaConnectorConfig.getNodes());
    }

    public ConnectorSplitSource getSplits(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorTableLayoutHandle layout) {
        KafkaTableHandle kafkaTableHandle = KafkaHandleResolver.convertLayout(layout).getTable();
        SimpleConsumer simpleConsumer = this.consumerManager.getConsumer(KafkaSplitManager.selectRandom(this.nodes));
        TopicMetadataRequest topicMetadataRequest = new TopicMetadataRequest((List)ImmutableList.of((Object)kafkaTableHandle.getTopicName()));
        TopicMetadataResponse topicMetadataResponse = simpleConsumer.send(topicMetadataRequest);
        ImmutableList.Builder splits = ImmutableList.builder();
        for (TopicMetadata metadata : topicMetadataResponse.topicsMetadata()) {
            for (PartitionMetadata part : metadata.partitionsMetadata()) {
                log.debug("Adding Partition %s/%s", new Object[]{metadata.topic(), part.partitionId()});
                Broker leader = part.leader();
                if (leader == null) {
                    log.warn("No leader for partition %s/%s found!", new Object[]{metadata.topic(), part.partitionId()});
                    continue;
                }
                HostAddress partitionLeader = HostAddress.fromParts((String)leader.host(), (int)leader.port());
                SimpleConsumer leaderConsumer = this.consumerManager.getConsumer(partitionLeader);
                ImmutableList partitionNodes = ImmutableList.copyOf((Collection)Lists.transform((List)part.isr(), KafkaSplitManager::brokerToHostAddress));
                long[] offsets = KafkaSplitManager.findAllOffsets(leaderConsumer, metadata.topic(), part.partitionId());
                for (int i = offsets.length - 1; i > 0; --i) {
                    KafkaSplit split = new KafkaSplit(this.connectorId, metadata.topic(), kafkaTableHandle.getKeyDataFormat(), kafkaTableHandle.getMessageDataFormat(), part.partitionId(), offsets[i], offsets[i - 1], (List<HostAddress>)partitionNodes);
                    splits.add((Object)split);
                }
            }
        }
        return new FixedSplitSource(this.connectorId, (Iterable)splits.build());
    }

    private static long[] findAllOffsets(SimpleConsumer consumer, String topicName, int partitionId) {
        TopicAndPartition topicAndPartition = new TopicAndPartition(topicName, partitionId);
        PartitionOffsetRequestInfo partitionOffsetRequestInfo = new PartitionOffsetRequestInfo(kafka.api.OffsetRequest.LatestTime(), Integer.MAX_VALUE);
        OffsetRequest offsetRequest = new OffsetRequest((Map)ImmutableMap.of((Object)topicAndPartition, (Object)partitionOffsetRequestInfo), kafka.api.OffsetRequest.CurrentVersion(), consumer.clientId());
        OffsetResponse offsetResponse = consumer.getOffsetsBefore(offsetRequest);
        if (offsetResponse.hasError()) {
            short errorCode = offsetResponse.errorCode(topicName, partitionId);
            log.warn("Offset response has error: %d", new Object[]{errorCode});
            throw new PrestoException((ErrorCodeSupplier)KafkaErrorCode.KAFKA_SPLIT_ERROR, "could not fetch data from Kafka, error code is '" + errorCode + "'");
        }
        return offsetResponse.offsets(topicName, partitionId);
    }

    private static HostAddress brokerToHostAddress(Broker broker) {
        return HostAddress.fromParts((String)broker.host(), (int)broker.port());
    }

    private static <T> T selectRandom(Iterable<T> iterable) {
        ImmutableList list = ImmutableList.copyOf(iterable);
        return (T)list.get(ThreadLocalRandom.current().nextInt(list.size()));
    }
}

