/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.kafka;

import com.facebook.presto.kafka.KafkaConnectorConfig;
import com.facebook.presto.kafka.KafkaTopicDescription;
import com.facebook.presto.kafka.KafkaTopicFieldDescription;
import com.facebook.presto.kafka.KafkaTopicFieldGroup;
import com.facebook.presto.spi.SchemaTableName;
import com.google.common.base.MoreObjects;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.json.JsonCodec;
import io.airlift.log.Logger;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import javax.inject.Inject;

public class KafkaTableDescriptionSupplier
implements Supplier<Map<SchemaTableName, KafkaTopicDescription>> {
    private static final Logger log = Logger.get(KafkaTableDescriptionSupplier.class);
    private final JsonCodec<KafkaTopicDescription> topicDescriptionCodec;
    private final File tableDescriptionDir;
    private final String defaultSchema;
    private final Set<String> tableNames;

    @Inject
    KafkaTableDescriptionSupplier(KafkaConnectorConfig kafkaConnectorConfig, JsonCodec<KafkaTopicDescription> topicDescriptionCodec) {
        this.topicDescriptionCodec = Objects.requireNonNull(topicDescriptionCodec, "topicDescriptionCodec is null");
        Objects.requireNonNull(kafkaConnectorConfig, "kafkaConfig is null");
        this.tableDescriptionDir = kafkaConnectorConfig.getTableDescriptionDir();
        this.defaultSchema = kafkaConnectorConfig.getDefaultSchema();
        this.tableNames = ImmutableSet.copyOf(kafkaConnectorConfig.getTableNames());
    }

    @Override
    public Map<SchemaTableName, KafkaTopicDescription> get() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        log.debug("Loading kafka table definitions from %s", new Object[]{this.tableDescriptionDir.getAbsolutePath()});
        try {
            for (File file : KafkaTableDescriptionSupplier.listFiles(this.tableDescriptionDir)) {
                if (!file.isFile() || !file.getName().endsWith(".json")) continue;
                KafkaTopicDescription table = (KafkaTopicDescription)this.topicDescriptionCodec.fromJson(Files.readAllBytes(file.toPath()));
                String schemaName = (String)MoreObjects.firstNonNull((Object)table.getSchemaName(), (Object)this.defaultSchema);
                log.debug("Kafka table %s.%s: %s", new Object[]{schemaName, table.getTableName(), table});
                builder.put((Object)new SchemaTableName(schemaName, table.getTableName()), (Object)table);
            }
            ImmutableMap tableDefinitions = builder.build();
            log.debug("Loaded Table definitions: %s", new Object[]{tableDefinitions.keySet()});
            builder = ImmutableMap.builder();
            for (String definedTable : this.tableNames) {
                SchemaTableName tableName;
                try {
                    tableName = SchemaTableName.valueOf((String)definedTable);
                }
                catch (IllegalArgumentException iae) {
                    tableName = new SchemaTableName(this.defaultSchema, definedTable);
                }
                if (tableDefinitions.containsKey(tableName)) {
                    KafkaTopicDescription kafkaTable = (KafkaTopicDescription)tableDefinitions.get(tableName);
                    log.debug("Found Table definition for %s: %s", new Object[]{tableName, kafkaTable});
                    builder.put((Object)tableName, (Object)kafkaTable);
                    continue;
                }
                log.debug("Created dummy Table definition for %s", new Object[]{tableName});
                builder.put((Object)tableName, (Object)new KafkaTopicDescription(tableName.getTableName(), tableName.getSchemaName(), definedTable, new KafkaTopicFieldGroup("dummy", (List<KafkaTopicFieldDescription>)ImmutableList.of()), new KafkaTopicFieldGroup("dummy", (List<KafkaTopicFieldDescription>)ImmutableList.of())));
            }
            return builder.build();
        }
        catch (IOException e) {
            log.warn((Throwable)e, "Error: ");
            throw Throwables.propagate((Throwable)e);
        }
    }

    private static List<File> listFiles(File dir) {
        Object[] files;
        if (dir != null && dir.isDirectory() && (files = dir.listFiles()) != null) {
            log.debug("Considering files: %s", new Object[]{Arrays.asList(files)});
            return ImmutableList.copyOf((Object[])files);
        }
        return ImmutableList.of();
    }
}

