/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.kafka;

import com.facebook.presto.kafka.KafkaTopicFieldGroup;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Objects;

public class KafkaTopicDescription {
    private final String tableName;
    private final String topicName;
    private final String schemaName;
    private final KafkaTopicFieldGroup key;
    private final KafkaTopicFieldGroup message;

    @JsonCreator
    public KafkaTopicDescription(@JsonProperty(value="tableName") String tableName, @JsonProperty(value="schemaName") String schemaName, @JsonProperty(value="topicName") String topicName, @JsonProperty(value="key") KafkaTopicFieldGroup key, @JsonProperty(value="message") KafkaTopicFieldGroup message) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)tableName) ? 1 : 0) != 0, (Object)"tableName is null or is empty");
        this.tableName = tableName;
        this.topicName = Objects.requireNonNull(topicName, "topicName is null");
        this.schemaName = schemaName;
        this.key = key;
        this.message = message;
    }

    @JsonProperty
    public String getTableName() {
        return this.tableName;
    }

    @JsonProperty
    public String getTopicName() {
        return this.topicName;
    }

    @JsonProperty
    public String getSchemaName() {
        return this.schemaName;
    }

    @JsonProperty
    public KafkaTopicFieldGroup getKey() {
        return this.key;
    }

    @JsonProperty
    public KafkaTopicFieldGroup getMessage() {
        return this.message;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("tableName", (Object)this.tableName).add("topicName", (Object)this.topicName).add("schemaName", (Object)this.schemaName).add("key", (Object)this.key).add("message", (Object)this.message).toString();
    }
}

