/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr303;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.validation.ValidationException;
import javax.validation.ValidationProviderResolver;
import javax.validation.spi.ValidationProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultValidationProviderResolver
implements ValidationProviderResolver {
    private static final String SPI_CFG = "META-INF/services/javax.validation.spi.ValidationProvider";

    public List<ValidationProvider<?>> getValidationProviders() {
        ArrayList providers = new ArrayList();
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl == null) {
                cl = DefaultValidationProviderResolver.class.getClassLoader();
            }
            Enumeration<URL> cfgs = cl.getResources(SPI_CFG);
            while (cfgs.hasMoreElements()) {
                URL url = cfgs.nextElement();
                BufferedReader br = null;
                try {
                    br = new BufferedReader(new InputStreamReader(url.openStream()), 256);
                    String line = br.readLine();
                    while (line != null) {
                        if (!(line = line.trim()).startsWith("#")) {
                            try {
                                final Class<?> provider = cl.loadClass(line);
                                ValidationProvider vp = (ValidationProvider)AccessController.doPrivileged(new PrivilegedAction<ValidationProvider<?>>(){

                                    @Override
                                    public ValidationProvider<?> run() {
                                        try {
                                            return (ValidationProvider)provider.newInstance();
                                        }
                                        catch (Exception ex) {
                                            throw new ValidationException("Cannot instantiate : " + provider, (Throwable)ex);
                                        }
                                    }
                                });
                                providers.add(vp);
                            }
                            catch (ClassNotFoundException e) {
                                throw new ValidationException("Failed to load provider " + line + " configured in file " + url, (Throwable)e);
                            }
                        }
                        line = br.readLine();
                    }
                    br.close();
                }
                catch (IOException e) {
                    throw new ValidationException("Error trying to read " + url, (Throwable)e);
                }
                finally {
                    if (br == null) continue;
                    br.close();
                }
            }
        }
        catch (IOException e) {
            throw new ValidationException("Error trying to read a META-INF/services/javax.validation.spi.ValidationProvider", (Throwable)e);
        }
        return providers;
    }
}

