/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.messageinterpolation;

import java.util.IllegalFormatException;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.validation.MessageInterpolator;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;
import org.hibernate.validator.messageinterpolation.ResourceBundleMessageInterpolator;

public class ValueFormatterMessageInterpolator
implements MessageInterpolator {
    private static final Log log = LoggerFactory.make();
    public static final String VALIDATED_VALUE_KEYWORD = "validatedValue";
    public static final String VALIDATED_VALUE_FORMAT_SEPARATOR = ":";
    private static final Pattern VALIDATED_VALUE_START_PATTERN = Pattern.compile("\\$\\{validatedValue");
    private final MessageInterpolator delegate;
    private final Locale defaultLocale = Locale.getDefault();

    public ValueFormatterMessageInterpolator() {
        this(null);
    }

    public ValueFormatterMessageInterpolator(MessageInterpolator userMessageInterpolator) {
        this.delegate = userMessageInterpolator == null ? new ResourceBundleMessageInterpolator() : userMessageInterpolator;
    }

    public String interpolate(String message, MessageInterpolator.Context context) {
        return this.interpolate(message, context, this.defaultLocale);
    }

    public String interpolate(String message, MessageInterpolator.Context context, Locale locale) {
        String tmp = this.delegate.interpolate(message, context, locale);
        return this.interpolateMessage(tmp, context.getValidatedValue(), locale);
    }

    private String interpolateMessage(String message, Object validatedValue, Locale locale) {
        String interpolatedMessage = message;
        Matcher matcher = VALIDATED_VALUE_START_PATTERN.matcher(message);
        while (matcher.find()) {
            int nbOpenCurlyBrace = 1;
            boolean isDoubleQuoteBloc = false;
            boolean isSimpleQuoteBloc = false;
            int lastIndex = matcher.end();
            do {
                char current;
                if ((current = message.charAt(lastIndex)) == '\'') {
                    if (isDoubleQuoteBloc || this.isEscaped(message, lastIndex)) continue;
                    isSimpleQuoteBloc = !isSimpleQuoteBloc;
                    continue;
                }
                if (current == '\"') {
                    if (isSimpleQuoteBloc || this.isEscaped(message, lastIndex)) continue;
                    isDoubleQuoteBloc = !isDoubleQuoteBloc;
                    continue;
                }
                if (isDoubleQuoteBloc || isSimpleQuoteBloc) continue;
                if (current == '{') {
                    ++nbOpenCurlyBrace;
                    continue;
                }
                if (current != '}') continue;
                --nbOpenCurlyBrace;
            } while (nbOpenCurlyBrace > 0 && ++lastIndex < message.length());
            if (nbOpenCurlyBrace != 0) continue;
            String expression = message.substring(matcher.start(), lastIndex);
            String expressionValue = this.interpolateValidatedValue(expression, validatedValue, locale);
            interpolatedMessage = interpolatedMessage.replaceFirst(Pattern.quote(expression), Matcher.quoteReplacement(expressionValue));
        }
        return interpolatedMessage;
    }

    private boolean isEscaped(String enclosingString, int charIndex) {
        if (charIndex < 0 || charIndex > enclosingString.length()) {
            throw log.getInvalidIndexException("0", "enclosingString.length() - 1");
        }
        return charIndex > 0 && enclosingString.charAt(charIndex - 1) == '\\';
    }

    private String interpolateValidatedValue(String expression, Object validatedValue, Locale locale) {
        String interpolatedValue;
        int separatorIndex = expression.indexOf(VALIDATED_VALUE_FORMAT_SEPARATOR);
        if (separatorIndex == -1) {
            interpolatedValue = String.valueOf(validatedValue);
        } else {
            String format = expression.substring(separatorIndex + 1, expression.length() - 1);
            if (format.length() == 0) {
                throw log.getMissingFormatStringInTemplateException(expression);
            }
            try {
                interpolatedValue = String.format(locale, format, validatedValue);
            }
            catch (IllegalFormatException e) {
                throw log.throwInvalidFormat(e.getMessage(), e);
            }
        }
        return interpolatedValue;
    }
}

