/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HiveMetadata;
import com.facebook.presto.hive.HiveMetadataFactory;
import com.facebook.presto.hive.HiveTransactionHandle;
import com.facebook.presto.spi.SystemTable;
import com.facebook.presto.spi.classloader.ThreadContextClassLoader;
import com.facebook.presto.spi.connector.Connector;
import com.facebook.presto.spi.connector.ConnectorAccessControl;
import com.facebook.presto.spi.connector.ConnectorMetadata;
import com.facebook.presto.spi.connector.ConnectorNodePartitioningProvider;
import com.facebook.presto.spi.connector.ConnectorPageSinkProvider;
import com.facebook.presto.spi.connector.ConnectorPageSourceProvider;
import com.facebook.presto.spi.connector.ConnectorSplitManager;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.connector.classloader.ClassLoaderSafeConnectorMetadata;
import com.facebook.presto.spi.session.PropertyMetadata;
import com.facebook.presto.spi.transaction.IsolationLevel;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.bootstrap.LifeCycleManager;
import io.airlift.log.Logger;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class HiveConnector
implements Connector {
    private static final Logger log = Logger.get(HiveConnector.class);
    private final LifeCycleManager lifeCycleManager;
    private final HiveMetadataFactory metadataFactory;
    private final ConnectorSplitManager splitManager;
    private final ConnectorPageSourceProvider pageSourceProvider;
    private final ConnectorPageSinkProvider pageSinkProvider;
    private final ConnectorNodePartitioningProvider nodePartitioningProvider;
    private final Set<SystemTable> systemTables;
    private final List<PropertyMetadata<?>> sessionProperties;
    private final List<PropertyMetadata<?>> tableProperties;
    private final ConnectorAccessControl accessControl;
    private final ClassLoader classLoader;
    private final ConcurrentMap<ConnectorTransactionHandle, HiveMetadata> transactions = new ConcurrentHashMap<ConnectorTransactionHandle, HiveMetadata>();

    public HiveConnector(LifeCycleManager lifeCycleManager, HiveMetadataFactory metadataFactory, ConnectorSplitManager splitManager, ConnectorPageSourceProvider pageSourceProvider, ConnectorPageSinkProvider pageSinkProvider, ConnectorNodePartitioningProvider nodePartitioningProvider, Set<SystemTable> systemTables, List<PropertyMetadata<?>> sessionProperties, List<PropertyMetadata<?>> tableProperties, ConnectorAccessControl accessControl, ClassLoader classLoader) {
        this.lifeCycleManager = Objects.requireNonNull(lifeCycleManager, "lifeCycleManager is null");
        this.metadataFactory = Objects.requireNonNull(metadataFactory, "metadata is null");
        this.splitManager = Objects.requireNonNull(splitManager, "splitManager is null");
        this.pageSourceProvider = Objects.requireNonNull(pageSourceProvider, "pageSourceProvider is null");
        this.pageSinkProvider = Objects.requireNonNull(pageSinkProvider, "pageSinkProvider is null");
        this.nodePartitioningProvider = Objects.requireNonNull(nodePartitioningProvider, "nodePartitioningProvider is null");
        this.systemTables = ImmutableSet.copyOf((Collection)Objects.requireNonNull(systemTables, "systemTables is null"));
        this.sessionProperties = ImmutableList.copyOf((Collection)Objects.requireNonNull(sessionProperties, "sessionProperties is null"));
        this.tableProperties = ImmutableList.copyOf((Collection)Objects.requireNonNull(tableProperties, "tableProperties is null"));
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
        this.classLoader = Objects.requireNonNull(classLoader, "classLoader is null");
    }

    public ConnectorMetadata getMetadata(ConnectorTransactionHandle transaction) {
        ConnectorMetadata metadata = (ConnectorMetadata)this.transactions.get(transaction);
        Preconditions.checkArgument((metadata != null ? 1 : 0) != 0, (String)"no such transaction: %s", (Object[])new Object[]{transaction});
        return new ClassLoaderSafeConnectorMetadata(metadata, this.classLoader);
    }

    public ConnectorSplitManager getSplitManager() {
        return this.splitManager;
    }

    public ConnectorPageSourceProvider getPageSourceProvider() {
        return this.pageSourceProvider;
    }

    public ConnectorPageSinkProvider getPageSinkProvider() {
        return this.pageSinkProvider;
    }

    public ConnectorNodePartitioningProvider getNodePartitioningProvider() {
        return this.nodePartitioningProvider;
    }

    public Set<SystemTable> getSystemTables() {
        return this.systemTables;
    }

    public List<PropertyMetadata<?>> getSessionProperties() {
        return this.sessionProperties;
    }

    public List<PropertyMetadata<?>> getTableProperties() {
        return this.tableProperties;
    }

    public ConnectorAccessControl getAccessControl() {
        return this.accessControl;
    }

    public boolean isSingleStatementWritesOnly() {
        return true;
    }

    public ConnectorTransactionHandle beginTransaction(IsolationLevel isolationLevel, boolean readOnly) {
        IsolationLevel.checkConnectorSupports((IsolationLevel)IsolationLevel.READ_UNCOMMITTED, (IsolationLevel)isolationLevel);
        HiveTransactionHandle transaction = new HiveTransactionHandle();
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.transactions.put(transaction, this.metadataFactory.create());
        }
        return transaction;
    }

    public void commit(ConnectorTransactionHandle transaction) {
        Preconditions.checkArgument((this.transactions.remove(transaction) != null ? 1 : 0) != 0, (String)"no such transaction: %s", (Object[])new Object[]{transaction});
    }

    public void rollback(ConnectorTransactionHandle transaction) {
        HiveMetadata metadata = (HiveMetadata)this.transactions.remove(transaction);
        Preconditions.checkArgument((metadata != null ? 1 : 0) != 0, (String)"no such transaction: %s", (Object[])new Object[]{transaction});
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            metadata.rollback();
        }
    }

    public final void shutdown() {
        try {
            this.lifeCycleManager.stop();
        }
        catch (Exception e) {
            log.error((Throwable)e, "Error shutting down connector");
        }
    }
}

