/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HiveBucketFunction;
import com.facebook.presto.hive.HiveConnectorId;
import com.facebook.presto.hive.HivePartitioningHandle;
import com.facebook.presto.hive.HiveSplit;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.util.Types;
import com.facebook.presto.spi.BucketFunction;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.Node;
import com.facebook.presto.spi.NodeManager;
import com.facebook.presto.spi.connector.ConnectorNodePartitioningProvider;
import com.facebook.presto.spi.connector.ConnectorPartitioningHandle;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.ToIntFunction;
import javax.inject.Inject;

public class HiveNodePartitioningProvider
implements ConnectorNodePartitioningProvider {
    private final String connectorId;
    private final NodeManager nodeManager;

    @Inject
    public HiveNodePartitioningProvider(HiveConnectorId connectorId, NodeManager nodeManager) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null").toString();
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager is null");
    }

    public BucketFunction getBucketFunction(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorPartitioningHandle partitioningHandle, List<Type> partitionChannelTypes, int bucketCount) {
        HivePartitioningHandle handle = Types.checkType(partitioningHandle, HivePartitioningHandle.class, "partitioningHandle");
        List<HiveType> hiveTypes = handle.getHiveTypes();
        return new HiveBucketFunction(bucketCount, hiveTypes);
    }

    public Map<Integer, Node> getBucketToNode(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorPartitioningHandle partitioningHandle) {
        HivePartitioningHandle handle = Types.checkType(partitioningHandle, HivePartitioningHandle.class, "partitioningHandle");
        Set nodesSet = this.nodeManager.getActiveDatasourceNodes(this.connectorId);
        Preconditions.checkState((!nodesSet.isEmpty() ? 1 : 0) != 0, (String)"No %s nodes available", (Object[])new Object[]{this.connectorId});
        List nodes = HiveNodePartitioningProvider.shuffle(nodesSet);
        int bucketCount = handle.getBucketCount();
        ImmutableMap.Builder distribution = ImmutableMap.builder();
        for (int i = 0; i < bucketCount; ++i) {
            distribution.put((Object)i, nodes.get(i % nodes.size()));
        }
        return distribution.build();
    }

    public ToIntFunction<ConnectorSplit> getSplitBucketFunction(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorPartitioningHandle partitioningHandle) {
        return value -> Types.checkType(value, HiveSplit.class, "value").getBucketNumber().getAsInt();
    }

    private static <T> List<T> shuffle(Iterable<T> iterable) {
        ArrayList list = Lists.newArrayList(iterable);
        Collections.shuffle(list);
        return list;
    }
}

