/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.BackgroundHiveSplitLoader;
import com.facebook.presto.hive.DirectoryLister;
import com.facebook.presto.hive.ForHiveClient;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveBucketHandle;
import com.facebook.presto.hive.HiveBucketProperty;
import com.facebook.presto.hive.HiveBucketing;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveConnectorId;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HivePartition;
import com.facebook.presto.hive.HivePartitionMetadata;
import com.facebook.presto.hive.HiveSplitSource;
import com.facebook.presto.hive.HiveTableLayoutHandle;
import com.facebook.presto.hive.HiveUtil;
import com.facebook.presto.hive.NamenodeStats;
import com.facebook.presto.hive.PartitionOfflineException;
import com.facebook.presto.hive.UnpartitionedPartition;
import com.facebook.presto.hive.metastore.HiveMetastore;
import com.facebook.presto.hive.util.Types;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplitSource;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.FixedSplitSource;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.TableNotFoundException;
import com.facebook.presto.spi.connector.ConnectorSplitManager;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import io.airlift.concurrent.BoundedExecutor;
import io.airlift.units.DataSize;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import javax.inject.Inject;
import org.apache.hadoop.hive.metastore.ProtectMode;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;

public class HiveSplitManager
implements ConnectorSplitManager {
    public static final String PRESTO_OFFLINE = "presto_offline";
    private final String connectorId;
    private final HiveMetastore metastore;
    private final NamenodeStats namenodeStats;
    private final HdfsEnvironment hdfsEnvironment;
    private final DirectoryLister directoryLister;
    private final Executor executor;
    private final int maxOutstandingSplits;
    private final int minPartitionBatchSize;
    private final int maxPartitionBatchSize;
    private final DataSize maxSplitSize;
    private final DataSize maxInitialSplitSize;
    private final int maxInitialSplits;
    private final boolean recursiveDfsWalkerEnabled;

    @Inject
    public HiveSplitManager(HiveConnectorId connectorId, HiveClientConfig hiveClientConfig, HiveMetastore metastore, NamenodeStats namenodeStats, HdfsEnvironment hdfsEnvironment, DirectoryLister directoryLister, @ForHiveClient ExecutorService executorService) {
        this(connectorId, metastore, namenodeStats, hdfsEnvironment, directoryLister, (Executor)new BoundedExecutor((Executor)executorService, hiveClientConfig.getMaxSplitIteratorThreads()), hiveClientConfig.getMaxOutstandingSplits(), hiveClientConfig.getMinPartitionBatchSize(), hiveClientConfig.getMaxPartitionBatchSize(), hiveClientConfig.getMaxSplitSize(), hiveClientConfig.getMaxInitialSplitSize(), hiveClientConfig.getMaxInitialSplits(), hiveClientConfig.getRecursiveDirWalkerEnabled());
    }

    public HiveSplitManager(HiveConnectorId connectorId, HiveMetastore metastore, NamenodeStats namenodeStats, HdfsEnvironment hdfsEnvironment, DirectoryLister directoryLister, Executor executor, int maxOutstandingSplits, int minPartitionBatchSize, int maxPartitionBatchSize, DataSize maxSplitSize, DataSize maxInitialSplitSize, int maxInitialSplits, boolean recursiveDfsWalkerEnabled) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null").toString();
        this.metastore = Objects.requireNonNull(metastore, "metastore is null");
        this.namenodeStats = Objects.requireNonNull(namenodeStats, "namenodeStats is null");
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.directoryLister = Objects.requireNonNull(directoryLister, "directoryLister is null");
        this.executor = new ErrorCodedExecutor(executor);
        Preconditions.checkArgument((maxOutstandingSplits >= 1 ? 1 : 0) != 0, (Object)"maxOutstandingSplits must be at least 1");
        this.maxOutstandingSplits = maxOutstandingSplits;
        this.minPartitionBatchSize = minPartitionBatchSize;
        this.maxPartitionBatchSize = maxPartitionBatchSize;
        this.maxSplitSize = Objects.requireNonNull(maxSplitSize, "maxSplitSize is null");
        this.maxInitialSplitSize = Objects.requireNonNull(maxInitialSplitSize, "maxInitialSplitSize is null");
        this.maxInitialSplits = maxInitialSplits;
        this.recursiveDfsWalkerEnabled = recursiveDfsWalkerEnabled;
    }

    public ConnectorSplitSource getSplits(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorTableLayoutHandle layoutHandle) {
        HiveTableLayoutHandle layout = Types.checkType(layoutHandle, HiveTableLayoutHandle.class, "layoutHandle");
        List partitions = Lists.transform(layout.getPartitions().get(), partition -> Types.checkType(partition, HivePartition.class, "partition"));
        HivePartition partition2 = (HivePartition)Iterables.getFirst((Iterable)partitions, null);
        if (partition2 == null) {
            return new FixedSplitSource(this.connectorId, (Iterable)ImmutableList.of());
        }
        SchemaTableName tableName = partition2.getTableName();
        Optional<HiveBucketing.HiveBucket> bucket = partition2.getBucket();
        Optional<HiveBucketHandle> bucketHandle = layout.getBucketHandle();
        partitions = Ordering.natural().onResultOf(HivePartition::getPartitionId).reverse().sortedCopy((Iterable)partitions);
        Optional<Table> table = this.metastore.getTable(tableName.getSchemaName(), tableName.getTableName());
        if (!table.isPresent()) {
            throw new TableNotFoundException(tableName);
        }
        Iterable<HivePartitionMetadata> hivePartitions = this.getPartitionMetadata(table.get(), tableName, partitions, bucketHandle.map(HiveBucketHandle::toBucketProperty));
        BackgroundHiveSplitLoader hiveSplitLoader = new BackgroundHiveSplitLoader(this.connectorId, table.get(), hivePartitions, bucketHandle, bucket, this.maxSplitSize, session, this.hdfsEnvironment, this.namenodeStats, this.directoryLister, this.executor, this.maxPartitionBatchSize, this.maxInitialSplitSize, this.maxInitialSplits, this.recursiveDfsWalkerEnabled);
        HiveSplitSource splitSource = new HiveSplitSource(this.connectorId, this.maxOutstandingSplits, hiveSplitLoader, this.executor);
        hiveSplitLoader.start(splitSource);
        return splitSource;
    }

    private Iterable<HivePartitionMetadata> getPartitionMetadata(Table table, SchemaTableName tableName, List<HivePartition> hivePartitions, Optional<HiveBucketProperty> bucketProperty) {
        HivePartition firstPartition;
        if (hivePartitions.isEmpty()) {
            return ImmutableList.of();
        }
        if (hivePartitions.size() == 1 && (firstPartition = (HivePartition)Iterables.getOnlyElement(hivePartitions)).getPartitionId().equals("<UNPARTITIONED>")) {
            return ImmutableList.of((Object)new HivePartitionMetadata(firstPartition, UnpartitionedPartition.UNPARTITIONED_PARTITION));
        }
        Iterable<List<HivePartition>> partitionNameBatches = HiveSplitManager.partitionExponentially(hivePartitions, this.minPartitionBatchSize, this.maxPartitionBatchSize);
        Iterable partitionBatches = Iterables.transform(partitionNameBatches, partitionBatch -> {
            Optional<Map<String, Partition>> batch = this.metastore.getPartitionsByNames(tableName.getSchemaName(), tableName.getTableName(), Lists.transform((List)partitionBatch, HivePartition::getPartitionId));
            if (!batch.isPresent()) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, "Partition metadata not available");
            }
            Map<String, Partition> partitions = batch.get();
            if (partitionBatch.size() != partitions.size()) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INTERNAL_ERROR, String.format("Expected %s partitions but found %s", partitionBatch.size(), partitions.size()));
            }
            ImmutableList.Builder results = ImmutableList.builder();
            for (HivePartition hivePartition : partitionBatch) {
                Partition partition = partitions.get(hivePartition.getPartitionId());
                if (partition == null) {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INTERNAL_ERROR, "Partition not loaded: " + hivePartition);
                }
                String protectMode = (String)partition.getParameters().get(ProtectMode.PARAMETER_NAME);
                String partName = HiveUtil.createPartitionName(partition, table);
                if (protectMode != null && ProtectMode.getProtectModeFromString((String)protectMode).offline) {
                    throw new PartitionOfflineException(tableName, partName);
                }
                String prestoOffline = (String)partition.getParameters().get(PRESTO_OFFLINE);
                if (!Strings.isNullOrEmpty((String)prestoOffline)) {
                    throw new PartitionOfflineException(tableName, partName, String.format("Partition '%s' is offline for Presto: %s", partName, prestoOffline));
                }
                List tableColumns = table.getSd().getCols();
                List partitionColumns = partition.getSd().getCols();
                if (tableColumns == null || partitionColumns == null) {
                    throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, String.format("Table '%s' or partition '%s' has null columns", tableName, partName));
                }
                for (int i = 0; i < Math.min(partitionColumns.size(), tableColumns.size()); ++i) {
                    String partitionType;
                    String tableType = ((FieldSchema)tableColumns.get(i)).getType();
                    if (tableType.equals(partitionType = ((FieldSchema)partitionColumns.get(i)).getType())) continue;
                    throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_PARTITION_SCHEMA_MISMATCH, String.format("There is a mismatch between the table and partition schemas. The column '%s' in table '%s' is declared as type '%s', but partition '%s' declared column '%s' as type '%s'.", ((FieldSchema)tableColumns.get(i)).getName(), tableName, tableType, partName, ((FieldSchema)partitionColumns.get(i)).getName(), partitionType));
                }
                Optional<HiveBucketProperty> partitionBucketProperty = HiveBucketProperty.fromStorageDescriptor(partition.getSd(), hivePartition.getTableName() + hivePartition.getPartitionId());
                HiveUtil.checkCondition(partitionBucketProperty.equals(bucketProperty), HiveErrorCode.HIVE_PARTITION_SCHEMA_MISMATCH, "Hive table (%s) bucketing property (%s) does not match partition (%s) bucketing property (%s)", hivePartition.getTableName(), bucketProperty, hivePartition.getPartitionId(), partitionBucketProperty);
                results.add((Object)new HivePartitionMetadata(hivePartition, partition));
            }
            return results.build();
        });
        return Iterables.concat((Iterable)partitionBatches);
    }

    private static <T> Iterable<List<T>> partitionExponentially(final List<T> values, final int minBatchSize, final int maxBatchSize) {
        return () -> new AbstractIterator<List<T>>(){
            private int currentSize;
            private final Iterator iterator;
            {
                this.currentSize = minBatchSize;
                this.iterator = values.iterator();
            }

            protected List<T> computeNext() {
                if (!this.iterator.hasNext()) {
                    return (List)this.endOfData();
                }
                ImmutableList.Builder builder = ImmutableList.builder();
                for (int count = 0; this.iterator.hasNext() && count < this.currentSize; ++count) {
                    builder.add(this.iterator.next());
                }
                this.currentSize = Math.min(maxBatchSize, this.currentSize * 2);
                return builder.build();
            }
        };
    }

    private static class ErrorCodedExecutor
    implements Executor {
        private final Executor delegate;

        private ErrorCodedExecutor(Executor delegate) {
            this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        }

        @Override
        public void execute(Runnable command) {
            try {
                this.delegate.execute(command);
            }
            catch (RejectedExecutionException e) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.SERVER_SHUTTING_DOWN, "Server is shutting down", (Throwable)e);
            }
        }
    }
}

