/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HiveSplitLoader;
import com.facebook.presto.hive.util.AsyncQueue;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.ConnectorSplitSource;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.airlift.concurrent.MoreFutures;
import java.io.FileNotFoundException;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;

class HiveSplitSource
implements ConnectorSplitSource {
    private final String connectorId;
    private final AsyncQueue<ConnectorSplit> queue;
    private final AtomicReference<Throwable> throwable = new AtomicReference();
    private final HiveSplitLoader splitLoader;
    private volatile boolean closed;

    HiveSplitSource(String connectorId, int maxOutstandingSplits, HiveSplitLoader splitLoader, Executor executor) {
        this.connectorId = connectorId;
        this.queue = new AsyncQueue(maxOutstandingSplits, executor);
        this.splitLoader = splitLoader;
    }

    @VisibleForTesting
    int getOutstandingSplitCount() {
        return this.queue.size();
    }

    CompletableFuture<?> addToQueue(Iterable<? extends ConnectorSplit> splits) {
        CompletableFuture<Object> lastResult = CompletableFuture.completedFuture(null);
        for (ConnectorSplit connectorSplit : splits) {
            lastResult = this.addToQueue(connectorSplit);
        }
        return lastResult;
    }

    CompletableFuture<?> addToQueue(ConnectorSplit split) {
        if (this.throwable.get() == null) {
            return this.queue.offer(split);
        }
        return CompletableFuture.completedFuture(null);
    }

    void finished() {
        if (this.throwable.get() == null) {
            this.queue.finish();
            this.splitLoader.stop();
        }
    }

    void fail(Throwable e) {
        if (this.throwable.compareAndSet(null, e)) {
            this.queue.finish();
            this.splitLoader.stop();
        }
    }

    public String getDataSourceName() {
        return this.connectorId;
    }

    public CompletableFuture<List<ConnectorSplit>> getNextBatch(int maxSize) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Provider is already closed");
        CompletableFuture<List<ConnectorSplit>> future = this.queue.getBatchAsync(maxSize);
        if (this.throwable.get() != null) {
            return MoreFutures.failedFuture((Throwable)this.throwable.get());
        }
        return future;
    }

    public boolean isFinished() {
        boolean isFinished = this.queue.isFinished();
        if (this.throwable.get() != null) {
            throw HiveSplitSource.propagatePrestoException(this.throwable.get());
        }
        return isFinished;
    }

    public void close() {
        this.queue.finish();
        this.splitLoader.stop();
        this.closed = true;
    }

    private static RuntimeException propagatePrestoException(Throwable throwable) {
        if (throwable instanceof PrestoException) {
            throw (PrestoException)throwable;
        }
        if (throwable instanceof FileNotFoundException) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILE_NOT_FOUND, throwable);
        }
        throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_UNKNOWN_ERROR, throwable);
    }
}

