/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HiveUtil;
import com.facebook.presto.hive.util.Types;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.NamedTypeSignature;
import com.facebook.presto.spi.type.TimestampType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.spi.type.TypeSignatureParameter;
import com.facebook.presto.spi.type.VarbinaryType;
import com.facebook.presto.spi.type.VarcharType;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;

public final class HiveType {
    public static final HiveType HIVE_BOOLEAN = new HiveType((TypeInfo)TypeInfoFactory.booleanTypeInfo);
    public static final HiveType HIVE_BYTE = new HiveType((TypeInfo)TypeInfoFactory.byteTypeInfo);
    public static final HiveType HIVE_SHORT = new HiveType((TypeInfo)TypeInfoFactory.shortTypeInfo);
    public static final HiveType HIVE_INT = new HiveType((TypeInfo)TypeInfoFactory.intTypeInfo);
    public static final HiveType HIVE_LONG = new HiveType((TypeInfo)TypeInfoFactory.longTypeInfo);
    public static final HiveType HIVE_FLOAT = new HiveType((TypeInfo)TypeInfoFactory.floatTypeInfo);
    public static final HiveType HIVE_DOUBLE = new HiveType((TypeInfo)TypeInfoFactory.doubleTypeInfo);
    public static final HiveType HIVE_STRING = new HiveType((TypeInfo)TypeInfoFactory.stringTypeInfo);
    public static final HiveType HIVE_TIMESTAMP = new HiveType((TypeInfo)TypeInfoFactory.timestampTypeInfo);
    public static final HiveType HIVE_DATE = new HiveType((TypeInfo)TypeInfoFactory.dateTypeInfo);
    public static final HiveType HIVE_BINARY = new HiveType((TypeInfo)TypeInfoFactory.binaryTypeInfo);
    private final String hiveTypeName;
    private final TypeInfo typeInfo;

    private HiveType(TypeInfo typeInfo) {
        Objects.requireNonNull(typeInfo, "typeInfo is null");
        this.hiveTypeName = typeInfo.getTypeName();
        this.typeInfo = typeInfo;
    }

    @JsonValue
    public String getHiveTypeName() {
        return this.hiveTypeName;
    }

    public ObjectInspector.Category getCategory() {
        return this.typeInfo.getCategory();
    }

    public TypeInfo getTypeInfo() {
        return this.typeInfo;
    }

    public TypeSignature getTypeSignature() {
        return HiveType.getTypeSignature(this.typeInfo);
    }

    public Type getType(TypeManager typeManager) {
        return typeManager.getType(this.getTypeSignature());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HiveType hiveType = (HiveType)o;
        return this.hiveTypeName.equals(hiveType.hiveTypeName);
    }

    public int hashCode() {
        return this.hiveTypeName.hashCode();
    }

    public String toString() {
        return this.hiveTypeName;
    }

    public static boolean isSupportedType(TypeInfo typeInfo) {
        switch (typeInfo.getCategory()) {
            case PRIMITIVE: {
                PrimitiveObjectInspector.PrimitiveCategory primitiveCategory = ((PrimitiveTypeInfo)typeInfo).getPrimitiveCategory();
                return HiveType.getPrimitiveType(primitiveCategory) != null;
            }
            case MAP: {
                MapTypeInfo mapTypeInfo = Types.checkType(typeInfo, MapTypeInfo.class, "typeInfo");
                return HiveType.isSupportedType(mapTypeInfo.getMapKeyTypeInfo()) && HiveType.isSupportedType(mapTypeInfo.getMapValueTypeInfo());
            }
            case LIST: {
                ListTypeInfo listTypeInfo = Types.checkType(typeInfo, ListTypeInfo.class, "typeInfo");
                return HiveType.isSupportedType(listTypeInfo.getListElementTypeInfo());
            }
            case STRUCT: {
                StructTypeInfo structTypeInfo = Types.checkType(typeInfo, StructTypeInfo.class, "typeInfo");
                return structTypeInfo.getAllStructFieldTypeInfos().stream().allMatch(HiveType::isSupportedType);
            }
        }
        return false;
    }

    @JsonCreator
    @Nonnull
    public static HiveType valueOf(String hiveTypeName) {
        Objects.requireNonNull(hiveTypeName, "hiveTypeName is null");
        return HiveType.toHiveType(TypeInfoUtils.getTypeInfoFromTypeString((String)hiveTypeName));
    }

    @Nonnull
    public static List<HiveType> toHiveTypes(String hiveTypes) {
        Objects.requireNonNull(hiveTypes, "hiveTypes is null");
        return ImmutableList.copyOf((Collection)TypeInfoUtils.getTypeInfosFromTypeString((String)hiveTypes).stream().map(HiveType::toHiveType).collect(Collectors.toList()));
    }

    @Nonnull
    public static HiveType toHiveType(TypeInfo typeInfo) {
        Objects.requireNonNull(typeInfo, "typeInfo is null");
        if (!HiveType.isSupportedType(typeInfo)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported Hive type: %s", typeInfo));
        }
        return new HiveType(typeInfo);
    }

    @Nonnull
    public static HiveType toHiveType(Type type) {
        Objects.requireNonNull(type, "type is null");
        return new HiveType(HiveType.toTypeInfo(type));
    }

    @Nonnull
    private static TypeInfo toTypeInfo(Type type) {
        if (BooleanType.BOOLEAN.equals((Object)type)) {
            return HiveType.HIVE_BOOLEAN.typeInfo;
        }
        if (BigintType.BIGINT.equals((Object)type)) {
            return HiveType.HIVE_LONG.typeInfo;
        }
        if (DoubleType.DOUBLE.equals((Object)type)) {
            return HiveType.HIVE_DOUBLE.typeInfo;
        }
        if (type instanceof VarcharType) {
            return HiveType.HIVE_STRING.typeInfo;
        }
        if (VarbinaryType.VARBINARY.equals((Object)type)) {
            return HiveType.HIVE_BINARY.typeInfo;
        }
        if (DateType.DATE.equals((Object)type)) {
            return HiveType.HIVE_DATE.typeInfo;
        }
        if (TimestampType.TIMESTAMP.equals((Object)type)) {
            return HiveType.HIVE_TIMESTAMP.typeInfo;
        }
        if (HiveUtil.isArrayType(type)) {
            TypeInfo elementType = HiveType.toTypeInfo((Type)type.getTypeParameters().get(0));
            return TypeInfoFactory.getListTypeInfo((TypeInfo)elementType);
        }
        if (HiveUtil.isMapType(type)) {
            TypeInfo keyType = HiveType.toTypeInfo((Type)type.getTypeParameters().get(0));
            TypeInfo valueType = HiveType.toTypeInfo((Type)type.getTypeParameters().get(1));
            return TypeInfoFactory.getMapTypeInfo((TypeInfo)keyType, (TypeInfo)valueType);
        }
        if (HiveUtil.isRowType(type)) {
            ImmutableList.Builder fieldNames = ImmutableList.builder();
            for (TypeSignatureParameter parameter : type.getTypeSignature().getParameters()) {
                if (!parameter.isNamedTypeSignature()) {
                    throw new IllegalArgumentException(String.format("Expected all parameters to be named type, but got %s", parameter));
                }
                NamedTypeSignature namedTypeSignature = parameter.getNamedTypeSignature();
                fieldNames.add((Object)namedTypeSignature.getName());
            }
            return TypeInfoFactory.getStructTypeInfo((List)fieldNames.build(), type.getTypeParameters().stream().map(HiveType::toTypeInfo).collect(Collectors.toList()));
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported Hive type: %s", type));
    }

    @Nonnull
    private static TypeSignature getTypeSignature(TypeInfo typeInfo) {
        switch (typeInfo.getCategory()) {
            case PRIMITIVE: {
                PrimitiveObjectInspector.PrimitiveCategory primitiveCategory = ((PrimitiveTypeInfo)typeInfo).getPrimitiveCategory();
                Type primitiveType = HiveType.getPrimitiveType(primitiveCategory);
                if (primitiveType == null) break;
                return primitiveType.getTypeSignature();
            }
            case MAP: {
                MapTypeInfo mapTypeInfo = Types.checkType(typeInfo, MapTypeInfo.class, "fieldInspector");
                TypeSignature keyType = HiveType.getTypeSignature(mapTypeInfo.getMapKeyTypeInfo());
                TypeSignature valueType = HiveType.getTypeSignature(mapTypeInfo.getMapValueTypeInfo());
                return new TypeSignature("map", (List)ImmutableList.of((Object)TypeSignatureParameter.of((TypeSignature)keyType), (Object)TypeSignatureParameter.of((TypeSignature)valueType)));
            }
            case LIST: {
                ListTypeInfo listTypeInfo = Types.checkType(typeInfo, ListTypeInfo.class, "fieldInspector");
                TypeSignature elementType = HiveType.getTypeSignature(listTypeInfo.getListElementTypeInfo());
                return new TypeSignature("array", (List)ImmutableList.of((Object)TypeSignatureParameter.of((TypeSignature)elementType)));
            }
            case STRUCT: {
                StructTypeInfo structTypeInfo = Types.checkType(typeInfo, StructTypeInfo.class, "fieldInspector");
                List fieldTypes = structTypeInfo.getAllStructFieldTypeInfos().stream().map(HiveType::getTypeSignature).collect(Collectors.toList());
                return new TypeSignature("row", fieldTypes, (List)structTypeInfo.getAllStructFieldNames());
            }
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported Hive type: %s", typeInfo));
    }

    private static Type getPrimitiveType(PrimitiveObjectInspector.PrimitiveCategory primitiveCategory) {
        switch (primitiveCategory) {
            case BOOLEAN: {
                return BooleanType.BOOLEAN;
            }
            case BYTE: {
                return BigintType.BIGINT;
            }
            case SHORT: {
                return BigintType.BIGINT;
            }
            case INT: {
                return BigintType.BIGINT;
            }
            case LONG: {
                return BigintType.BIGINT;
            }
            case FLOAT: {
                return DoubleType.DOUBLE;
            }
            case DOUBLE: {
                return DoubleType.DOUBLE;
            }
            case STRING: {
                return VarcharType.VARCHAR;
            }
            case DATE: {
                return DateType.DATE;
            }
            case TIMESTAMP: {
                return TimestampType.TIMESTAMP;
            }
            case BINARY: {
                return VarbinaryType.VARBINARY;
            }
        }
        return null;
    }
}

