/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.connector.ConnectorAccessControl;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.security.AccessDeniedException;
import com.facebook.presto.spi.security.Identity;
import com.facebook.presto.spi.security.Privilege;
import java.util.Objects;
import javax.inject.Inject;

public class NoAccessControl
implements ConnectorAccessControl {
    private final boolean allowDropTable;
    private final boolean allowRenameTable;
    private final boolean allowAddColumn;

    @Inject
    public NoAccessControl(HiveClientConfig hiveClientConfig) {
        Objects.requireNonNull(hiveClientConfig, "hiveClientConfig is null");
        this.allowDropTable = hiveClientConfig.getAllowDropTable();
        this.allowRenameTable = hiveClientConfig.getAllowRenameTable();
        this.allowAddColumn = hiveClientConfig.getAllowAddColumn();
    }

    public void checkCanCreateTable(ConnectorTransactionHandle transaction, Identity identity, SchemaTableName tableName) {
    }

    public void checkCanDropTable(ConnectorTransactionHandle transaction, Identity identity, SchemaTableName tableName) {
        if (!this.allowDropTable) {
            AccessDeniedException.denyDropTable((String)tableName.toString());
        }
    }

    public void checkCanRenameTable(ConnectorTransactionHandle transaction, Identity identity, SchemaTableName tableName, SchemaTableName newTableName) {
        if (!this.allowRenameTable) {
            AccessDeniedException.denyRenameTable((String)tableName.toString(), (String)newTableName.toString());
        }
    }

    public void checkCanAddColumn(ConnectorTransactionHandle transaction, Identity identity, SchemaTableName tableName) {
        if (!this.allowAddColumn) {
            AccessDeniedException.denyAddColumn((String)tableName.toString());
        }
    }

    public void checkCanRenameColumn(ConnectorTransactionHandle transaction, Identity identity, SchemaTableName tableName) {
    }

    public void checkCanSelectFromTable(ConnectorTransactionHandle transaction, Identity identity, SchemaTableName tableName) {
    }

    public void checkCanInsertIntoTable(ConnectorTransactionHandle transaction, Identity identity, SchemaTableName tableName) {
    }

    public void checkCanDeleteFromTable(ConnectorTransactionHandle transaction, Identity identity, SchemaTableName tableName) {
    }

    public void checkCanCreateView(ConnectorTransactionHandle transaction, Identity identity, SchemaTableName viewName) {
    }

    public void checkCanDropView(ConnectorTransactionHandle transaction, Identity identity, SchemaTableName viewName) {
    }

    public void checkCanSelectFromView(ConnectorTransactionHandle transaction, Identity identity, SchemaTableName viewName) {
    }

    public void checkCanCreateViewWithSelectFromTable(ConnectorTransactionHandle transaction, Identity identity, SchemaTableName tableName) {
    }

    public void checkCanCreateViewWithSelectFromView(ConnectorTransactionHandle transaction, Identity identity, SchemaTableName viewName) {
    }

    public void checkCanSetCatalogSessionProperty(Identity identity, String propertyName) {
    }

    public void checkCanGrantTablePrivilege(Identity identity, Privilege privilege, SchemaTableName tableName) {
    }
}

