/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimaps;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class PartitionUpdate {
    private final String name;
    private final boolean isNew;
    private final String writePath;
    private final String targetPath;
    private final List<String> fileNames;

    public PartitionUpdate(@JsonProperty(value="name") String name, @JsonProperty(value="new") boolean isNew, @JsonProperty(value="writePath") String writePath, @JsonProperty(value="targetPath") String targetPath, @JsonProperty(value="fileNames") List<String> fileNames) {
        this.name = Objects.requireNonNull(name, "name is null");
        this.isNew = isNew;
        this.writePath = Objects.requireNonNull(writePath, "writePath is null");
        this.targetPath = Objects.requireNonNull(targetPath, "targetPath is null");
        this.fileNames = ImmutableList.copyOf((Collection)Objects.requireNonNull(fileNames, "fileNames is null"));
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public boolean isNew() {
        return this.isNew;
    }

    @JsonProperty
    public String getWritePath() {
        return this.writePath;
    }

    @JsonProperty
    public String getTargetPath() {
        return this.targetPath;
    }

    @JsonProperty
    public List<String> getFileNames() {
        return this.fileNames;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).toString();
    }

    public static List<PartitionUpdate> mergePartitionUpdates(List<PartitionUpdate> unMergedUpdates) {
        ImmutableList.Builder partitionUpdates = ImmutableList.builder();
        for (Collection partitionGroup : Multimaps.index(unMergedUpdates, PartitionUpdate::getName).asMap().values()) {
            PartitionUpdate firstPartition = (PartitionUpdate)partitionGroup.iterator().next();
            ImmutableList.Builder allFileNames = ImmutableList.builder();
            for (PartitionUpdate partition : partitionGroup) {
                if (partition.isNew() != firstPartition.isNew() || !partition.getWritePath().equals(firstPartition.getWritePath()) || !partition.getTargetPath().equals(firstPartition.getTargetPath())) {
                    throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CONCURRENT_MODIFICATION_DETECTED, String.format("Partition %s was added or modified during INSERT", firstPartition.getName()));
                }
                allFileNames.addAll(partition.getFileNames());
            }
            partitionUpdates.add((Object)new PartitionUpdate(firstPartition.getName(), firstPartition.isNew(), firstPartition.getWritePath(), firstPartition.getTargetPath(), (List<String>)allFileNames.build()));
        }
        return partitionUpdates.build();
    }
}

