/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaTableName;
import java.util.Objects;

public class TableOfflineException
extends PrestoException {
    private final SchemaTableName tableName;

    public TableOfflineException(SchemaTableName tableName) {
        this(tableName, String.format("Table '%s' is offline", tableName));
    }

    public TableOfflineException(SchemaTableName tableName, String message) {
        super((ErrorCodeSupplier)HiveErrorCode.HIVE_TABLE_OFFLINE, message);
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
    }

    public SchemaTableName getTableName() {
        return this.tableName;
    }
}

