/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.parquet.predicate;

import com.facebook.presto.hive.parquet.predicate.ParquetDictionaryDescriptor;
import com.facebook.presto.hive.parquet.predicate.ParquetDoubleStatistics;
import com.facebook.presto.hive.parquet.predicate.ParquetIntegerStatistics;
import com.facebook.presto.hive.parquet.predicate.ParquetPredicate;
import com.facebook.presto.hive.parquet.predicate.ParquetRangeStatistics;
import com.facebook.presto.hive.parquet.predicate.ParquetStringStatistics;
import com.facebook.presto.spi.predicate.Domain;
import com.facebook.presto.spi.predicate.Range;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.predicate.ValueSet;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import parquet.column.ColumnDescriptor;
import parquet.column.Dictionary;
import parquet.column.page.DictionaryPage;
import parquet.column.statistics.BinaryStatistics;
import parquet.column.statistics.BooleanStatistics;
import parquet.column.statistics.DoubleStatistics;
import parquet.column.statistics.FloatStatistics;
import parquet.column.statistics.IntStatistics;
import parquet.column.statistics.LongStatistics;
import parquet.column.statistics.Statistics;
import parquet.schema.PrimitiveType;

public class TupleDomainParquetPredicate<C>
implements ParquetPredicate {
    private final TupleDomain<C> effectivePredicate;
    private final List<ColumnReference<C>> columnReferences;

    public TupleDomainParquetPredicate(TupleDomain<C> effectivePredicate, List<ColumnReference<C>> columnReferences) {
        this.effectivePredicate = Objects.requireNonNull(effectivePredicate, "effectivePredicate is null");
        this.columnReferences = ImmutableList.copyOf((Collection)Objects.requireNonNull(columnReferences, "columnReferences is null"));
    }

    @Override
    public boolean matches(long numberOfRows, Map<Integer, Statistics<?>> statisticsByColumnIndex) {
        if (numberOfRows == 0L) {
            return false;
        }
        ImmutableMap.Builder domains = ImmutableMap.builder();
        for (ColumnReference<C> columnReference : this.columnReferences) {
            Statistics<?> statistics = statisticsByColumnIndex.get(columnReference.getOrdinal());
            Domain domain = statistics == null || statistics.isEmpty() ? Domain.all((Type)columnReference.getType()) : TupleDomainParquetPredicate.getDomain(columnReference.getType(), numberOfRows, statistics);
            domains.put(columnReference.getColumn(), (Object)domain);
        }
        TupleDomain stripeDomain = TupleDomain.withColumnDomains((Map)domains.build());
        return this.effectivePredicate.overlaps(stripeDomain);
    }

    @Override
    public boolean matches(Map<Integer, ParquetDictionaryDescriptor> dictionariesByColumnIndex) {
        ImmutableMap.Builder domains = ImmutableMap.builder();
        for (ColumnReference<C> columnReference : this.columnReferences) {
            ParquetDictionaryDescriptor dictionaryDescriptor = dictionariesByColumnIndex.get(columnReference.getOrdinal());
            Domain domain = TupleDomainParquetPredicate.getDomain(columnReference.getType(), dictionaryDescriptor);
            if (domain == null) continue;
            domains.put(columnReference.getColumn(), (Object)domain);
        }
        TupleDomain stripeDomain = TupleDomain.withColumnDomains((Map)domains.build());
        return this.effectivePredicate.overlaps(stripeDomain);
    }

    @VisibleForTesting
    public static Domain getDomain(Type type, long rowCount, Statistics<?> statistics) {
        boolean hasNullValue;
        if (statistics == null || statistics.isEmpty()) {
            return Domain.all((Type)type);
        }
        if (statistics.getNumNulls() == rowCount) {
            return Domain.onlyNull((Type)type);
        }
        boolean bl = hasNullValue = statistics.getNumNulls() != 0L;
        if (statistics.genericGetMin() == null || statistics.genericGetMax() == null) {
            return Domain.create((ValueSet)ValueSet.all((Type)type), (boolean)hasNullValue);
        }
        if (type.equals(BooleanType.BOOLEAN) && statistics instanceof BooleanStatistics) {
            boolean hasFalseValues;
            BooleanStatistics booleanStatistics = (BooleanStatistics)statistics;
            boolean hasTrueValues = booleanStatistics.getMax() || booleanStatistics.getMin();
            boolean bl2 = hasFalseValues = !booleanStatistics.getMax() || !booleanStatistics.getMin();
            if (hasTrueValues && hasFalseValues) {
                return Domain.all((Type)type);
            }
            if (hasTrueValues) {
                return Domain.create((ValueSet)ValueSet.of((Type)type, (Object)true, (Object[])new Object[0]), (boolean)hasNullValue);
            }
            if (hasFalseValues) {
                return Domain.create((ValueSet)ValueSet.of((Type)type, (Object)false, (Object[])new Object[0]), (boolean)hasNullValue);
            }
        } else {
            if (type.equals(BigintType.BIGINT) && (statistics instanceof LongStatistics || statistics instanceof IntStatistics)) {
                ParquetIntegerStatistics parquetIntegerStatistics;
                if (statistics instanceof LongStatistics) {
                    LongStatistics longStatistics = (LongStatistics)statistics;
                    if (longStatistics.genericGetMin() > longStatistics.genericGetMax()) {
                        return Domain.create((ValueSet)ValueSet.all((Type)type), (boolean)hasNullValue);
                    }
                    parquetIntegerStatistics = new ParquetIntegerStatistics(longStatistics.genericGetMin(), longStatistics.genericGetMax());
                } else {
                    IntStatistics intStatistics = (IntStatistics)statistics;
                    if (intStatistics.genericGetMin() > intStatistics.genericGetMax()) {
                        return Domain.create((ValueSet)ValueSet.all((Type)type), (boolean)hasNullValue);
                    }
                    parquetIntegerStatistics = new ParquetIntegerStatistics(Long.valueOf(intStatistics.getMin()), Long.valueOf(intStatistics.getMax()));
                }
                return TupleDomainParquetPredicate.createDomain(type, hasNullValue, parquetIntegerStatistics);
            }
            if (type.equals(DoubleType.DOUBLE) && (statistics instanceof DoubleStatistics || statistics instanceof FloatStatistics)) {
                ParquetDoubleStatistics parquetDoubleStatistics;
                if (statistics instanceof DoubleStatistics) {
                    DoubleStatistics doubleStatistics = (DoubleStatistics)statistics;
                    if (doubleStatistics.genericGetMin() > doubleStatistics.genericGetMax()) {
                        return Domain.create((ValueSet)ValueSet.all((Type)type), (boolean)hasNullValue);
                    }
                    parquetDoubleStatistics = new ParquetDoubleStatistics(doubleStatistics.genericGetMin(), doubleStatistics.genericGetMax());
                } else {
                    FloatStatistics floatStatistics = (FloatStatistics)statistics;
                    if (floatStatistics.genericGetMin().floatValue() > floatStatistics.genericGetMax().floatValue()) {
                        return Domain.create((ValueSet)ValueSet.all((Type)type), (boolean)hasNullValue);
                    }
                    parquetDoubleStatistics = new ParquetDoubleStatistics(Double.valueOf(floatStatistics.getMin()), Double.valueOf(floatStatistics.getMax()));
                }
                return TupleDomainParquetPredicate.createDomain(type, hasNullValue, parquetDoubleStatistics);
            }
            if (type.equals(VarcharType.VARCHAR) && statistics instanceof BinaryStatistics) {
                Slice maxSlice;
                BinaryStatistics binaryStatistics = (BinaryStatistics)statistics;
                Slice minSlice = Slices.wrappedBuffer((byte[])binaryStatistics.getMin().getBytes());
                if (minSlice.compareTo(maxSlice = Slices.wrappedBuffer((byte[])binaryStatistics.getMax().getBytes())) > 0) {
                    return Domain.create((ValueSet)ValueSet.all((Type)type), (boolean)hasNullValue);
                }
                ParquetStringStatistics parquetStringStatistics = new ParquetStringStatistics(minSlice, maxSlice);
                return TupleDomainParquetPredicate.createDomain(type, hasNullValue, parquetStringStatistics);
            }
        }
        return Domain.create((ValueSet)ValueSet.all((Type)type), (boolean)hasNullValue);
    }

    @VisibleForTesting
    public static Domain getDomain(Type type, ParquetDictionaryDescriptor dictionaryDescriptor) {
        Dictionary dictionary;
        if (dictionaryDescriptor == null) {
            return null;
        }
        ColumnDescriptor columnDescriptor = dictionaryDescriptor.getColumnDescriptor();
        DictionaryPage dictionaryPage = dictionaryDescriptor.getDictionaryPage();
        if (dictionaryPage == null) {
            return null;
        }
        try {
            dictionary = dictionaryPage.getEncoding().initDictionary(columnDescriptor, dictionaryPage);
        }
        catch (Exception e) {
            return null;
        }
        int dictionarySize = dictionaryPage.getDictionarySize();
        if (type.equals(BigintType.BIGINT) && columnDescriptor.getType() == PrimitiveType.PrimitiveTypeName.INT64) {
            ArrayList<Domain> domains = new ArrayList<Domain>();
            for (int i = 0; i < dictionarySize; ++i) {
                domains.add(Domain.singleValue((Type)type, (Object)dictionary.decodeToLong(i)));
            }
            domains.add(Domain.onlyNull((Type)type));
            return Domain.union(domains);
        }
        if (type.equals(BigintType.BIGINT) && columnDescriptor.getType() == PrimitiveType.PrimitiveTypeName.INT32) {
            ArrayList<Domain> domains = new ArrayList<Domain>();
            for (int i = 0; i < dictionarySize; ++i) {
                domains.add(Domain.singleValue((Type)type, (Object)dictionary.decodeToInt(i)));
            }
            domains.add(Domain.onlyNull((Type)type));
            return Domain.union(domains);
        }
        if (type.equals(DoubleType.DOUBLE) && columnDescriptor.getType() == PrimitiveType.PrimitiveTypeName.DOUBLE) {
            ArrayList<Domain> domains = new ArrayList<Domain>();
            for (int i = 0; i < dictionarySize; ++i) {
                domains.add(Domain.singleValue((Type)type, (Object)dictionary.decodeToDouble(i)));
            }
            domains.add(Domain.onlyNull((Type)type));
            return Domain.union(domains);
        }
        if (type.equals(DoubleType.DOUBLE) && columnDescriptor.getType() == PrimitiveType.PrimitiveTypeName.FLOAT) {
            ArrayList<Domain> domains = new ArrayList<Domain>();
            for (int i = 0; i < dictionarySize; ++i) {
                domains.add(Domain.singleValue((Type)type, (Object)dictionary.decodeToFloat(i)));
            }
            domains.add(Domain.onlyNull((Type)type));
            return Domain.union(domains);
        }
        if (type.equals(VarcharType.VARCHAR) && columnDescriptor.getType() == PrimitiveType.PrimitiveTypeName.BINARY) {
            ArrayList<Domain> domains = new ArrayList<Domain>();
            for (int i = 0; i < dictionarySize; ++i) {
                domains.add(Domain.singleValue((Type)type, (Object)Slices.wrappedBuffer((byte[])dictionary.decodeToBinary(i).getBytes())));
            }
            domains.add(Domain.onlyNull((Type)type));
            return Domain.union(domains);
        }
        return null;
    }

    private static <T extends Comparable<T>> Domain createDomain(Type type, boolean hasNullValue, ParquetRangeStatistics<T> rangeStatistics) {
        return TupleDomainParquetPredicate.createDomain(type, hasNullValue, rangeStatistics, value -> value);
    }

    private static <F, T extends Comparable<T>> Domain createDomain(Type type, boolean hasNullValue, ParquetRangeStatistics<F> rangeStatistics, Function<F, T> function) {
        F min = rangeStatistics.getMin();
        F max = rangeStatistics.getMax();
        if (min != null && max != null) {
            return Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)type, function.apply(min), (boolean)true, function.apply(max), (boolean)true), (Range[])new Range[0]), (boolean)hasNullValue);
        }
        if (max != null) {
            return Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)type, function.apply(max)), (Range[])new Range[0]), (boolean)hasNullValue);
        }
        if (min != null) {
            return Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThanOrEqual((Type)type, function.apply(min)), (Range[])new Range[0]), (boolean)hasNullValue);
        }
        return Domain.create((ValueSet)ValueSet.all((Type)type), (boolean)hasNullValue);
    }

    public static class ColumnReference<C> {
        private final C column;
        private final int ordinal;
        private final Type type;

        public ColumnReference(C column, int ordinal, Type type) {
            this.column = Objects.requireNonNull(column, "column is null");
            Preconditions.checkArgument((ordinal >= 0 ? 1 : 0) != 0, (Object)"ordinal is negative");
            this.ordinal = ordinal;
            this.type = Objects.requireNonNull(type, "type is null");
        }

        public C getColumn() {
            return this.column;
        }

        public int getOrdinal() {
            return this.ordinal;
        }

        public Type getType() {
            return this.type;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("column", this.column).add("ordinal", this.ordinal).add("type", (Object)this.type).toString();
        }
    }
}

