/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.rcfile;

import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HivePartitionKey;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.HiveUtil;
import com.facebook.presto.hive.rcfile.RcFileBlockLoader;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.block.LazyArrayBlock;
import com.facebook.presto.spi.block.LazyBlockLoader;
import com.facebook.presto.spi.block.LazyFixedWidthBlock;
import com.facebook.presto.spi.block.LazySliceArrayBlock;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.FixedWidthType;
import com.facebook.presto.spi.type.TimestampType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.spi.type.VariableWidthType;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.primitives.Ints;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.airlift.units.DataSize;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import org.apache.hadoop.hive.ql.io.RCFile;
import org.apache.hadoop.hive.serde2.columnar.BytesRefArrayWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.joda.time.DateTimeZone;

public class RcFilePageSource
implements ConnectorPageSource {
    private static final int MAX_PAGE_SIZE = 1024;
    private static final long GUESSED_MEMORY_USAGE = new DataSize(16.0, DataSize.Unit.MEGABYTE).toBytes();
    public static final int MAX_FIXED_WIDTH_SIZE = 8;
    public static final int NULL_ENTRY_SIZE = 0;
    private final RCFile.Reader recordReader;
    private final RcFileBlockLoader blockLoader;
    private final long startFilePosition;
    private final long endFilePosition;
    private final List<String> columnNames;
    private final List<Type> types;
    private final List<HiveType> hiveTypes;
    private final ObjectInspector[] fieldInspectors;
    private final Block[] constantBlocks;
    private final int[] hiveColumnIndexes;
    private int pageId;
    private int currentBatchSize;
    private int positionInBatch;
    private int currentPageSize;
    private boolean closed;
    private final BytesRefArrayWritable[] columnBatch;
    private final boolean[] columnBatchLoaded;
    private long completedBytes;

    public RcFilePageSource(RCFile.Reader recordReader, long offset, long length, RcFileBlockLoader blockLoader, Properties splitSchema, List<HivePartitionKey> partitionKeys, List<HiveColumnHandle> columns, DateTimeZone hiveStorageTimeZone, TypeManager typeManager) {
        this.recordReader = Objects.requireNonNull(recordReader, "recordReader is null");
        this.blockLoader = Objects.requireNonNull(blockLoader, "blockLoader is null");
        Objects.requireNonNull(splitSchema, "splitSchema is null");
        Objects.requireNonNull(partitionKeys, "partitionKeys is null");
        Objects.requireNonNull(columns, "columns is null");
        Objects.requireNonNull(hiveStorageTimeZone, "hiveStorageTimeZone is null");
        Objects.requireNonNull(typeManager, "typeManager is null");
        try {
            if (offset > recordReader.getPosition()) {
                recordReader.sync(offset);
            }
            this.startFilePosition = recordReader.getPosition();
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        this.endFilePosition = offset + length;
        ImmutableMap partitionKeysByName = Maps.uniqueIndex(partitionKeys, HivePartitionKey::getName);
        int size = columns.size();
        this.constantBlocks = new Block[size];
        this.hiveColumnIndexes = new int[size];
        this.fieldInspectors = new ObjectInspector[size];
        StructObjectInspector rowInspector = HiveUtil.getTableObjectInspector(splitSchema);
        ImmutableList.Builder namesBuilder = ImmutableList.builder();
        ImmutableList.Builder typesBuilder = ImmutableList.builder();
        ImmutableList.Builder hiveTypesBuilder = ImmutableList.builder();
        for (int columnIndex = 0; columnIndex < columns.size(); ++columnIndex) {
            HiveColumnHandle column = columns.get(columnIndex);
            String name = column.getName();
            Type type = typeManager.getType(column.getTypeSignature());
            namesBuilder.add((Object)name);
            typesBuilder.add((Object)type);
            hiveTypesBuilder.add((Object)column.getHiveType());
            this.hiveColumnIndexes[columnIndex] = column.getHiveColumnIndex();
            if (!column.isPartitionKey()) {
                this.fieldInspectors[columnIndex] = rowInspector.getStructFieldRef(column.getName()).getFieldObjectInspector();
            }
            if (column.isPartitionKey()) {
                int i;
                int i2;
                HivePartitionKey partitionKey = (HivePartitionKey)partitionKeysByName.get(name);
                Preconditions.checkArgument((partitionKey != null ? 1 : 0) != 0, (String)"No value provided for partition key %s", (Object[])new Object[]{name});
                byte[] bytes = partitionKey.getValue().getBytes(StandardCharsets.UTF_8);
                BlockBuilder blockBuilder = type.createBlockBuilder(new BlockBuilderStatus(), 1024, Math.max(8, bytes.length));
                if (HiveUtil.isHiveNull(bytes)) {
                    for (int i3 = 0; i3 < 1024; ++i3) {
                        blockBuilder.appendNull();
                    }
                } else if (type.equals(BooleanType.BOOLEAN)) {
                    boolean value = HiveUtil.booleanPartitionKey(partitionKey.getValue(), name);
                    for (i2 = 0; i2 < 1024; ++i2) {
                        BooleanType.BOOLEAN.writeBoolean(blockBuilder, value);
                    }
                } else if (type.equals(BigintType.BIGINT)) {
                    long value = HiveUtil.bigintPartitionKey(partitionKey.getValue(), name);
                    for (i = 0; i < 1024; ++i) {
                        BigintType.BIGINT.writeLong(blockBuilder, value);
                    }
                } else if (type.equals(DoubleType.DOUBLE)) {
                    double value = HiveUtil.doublePartitionKey(partitionKey.getValue(), name);
                    for (i = 0; i < 1024; ++i) {
                        DoubleType.DOUBLE.writeDouble(blockBuilder, value);
                    }
                } else if (type.equals(VarcharType.VARCHAR)) {
                    Slice value = Slices.wrappedBuffer((byte[])bytes);
                    for (i2 = 0; i2 < 1024; ++i2) {
                        VarcharType.VARCHAR.writeSlice(blockBuilder, value);
                    }
                } else if (type.equals(DateType.DATE)) {
                    long value = HiveUtil.datePartitionKey(partitionKey.getValue(), name);
                    for (i = 0; i < 1024; ++i) {
                        DateType.DATE.writeLong(blockBuilder, value);
                    }
                } else if (TimestampType.TIMESTAMP.equals((Object)type)) {
                    long value = HiveUtil.timestampPartitionKey(partitionKey.getValue(), hiveStorageTimeZone, name);
                    for (i = 0; i < 1024; ++i) {
                        TimestampType.TIMESTAMP.writeLong(blockBuilder, value);
                    }
                } else {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported column type %s for partition key: %s", type.getDisplayName(), name));
                }
                this.constantBlocks[columnIndex] = blockBuilder.build();
                continue;
            }
            if (this.hiveColumnIndexes[columnIndex] < recordReader.getCurrentKeyBufferObj().getColumnNumber()) continue;
            BlockBuilder blockBuilder = type.createBlockBuilder(new BlockBuilderStatus(), 1024, 0);
            for (int i = 0; i < 1024; ++i) {
                blockBuilder.appendNull();
            }
            this.constantBlocks[columnIndex] = blockBuilder.build();
        }
        this.types = typesBuilder.build();
        this.hiveTypes = hiveTypesBuilder.build();
        this.columnNames = namesBuilder.build();
        this.columnBatch = new BytesRefArrayWritable[this.hiveColumnIndexes.length];
        this.columnBatchLoaded = new boolean[this.hiveColumnIndexes.length];
    }

    public long getTotalBytes() {
        return 0L;
    }

    public long getCompletedBytes() {
        return this.completedBytes;
    }

    public long getReadTimeNanos() {
        return 0L;
    }

    public boolean isFinished() {
        return this.closed;
    }

    public Page getNextPage() {
        try {
            ++this.pageId;
            this.positionInBatch += this.currentPageSize;
            if (this.positionInBatch >= this.currentBatchSize) {
                if (!this.recordReader.nextColumnsBatch() || this.recordReader.lastSeenSyncPos() >= this.endFilePosition) {
                    this.close();
                    return null;
                }
                this.currentBatchSize = this.recordReader.getCurrentKeyBufferObj().getNumberRows();
                this.positionInBatch = 0;
                Arrays.fill(this.columnBatchLoaded, false);
            }
            this.currentPageSize = Ints.checkedCast((long)Math.min(this.currentBatchSize - this.positionInBatch, 1024));
            RcFileColumnsBatch rcFileColumnsBatch = new RcFileColumnsBatch(this.pageId, this.positionInBatch);
            Block[] blocks = new Block[this.hiveColumnIndexes.length];
            for (int fieldId = 0; fieldId < blocks.length; ++fieldId) {
                LazyBlockLoader<LazyFixedWidthBlock> loader;
                Type type = this.types.get(fieldId);
                if (this.constantBlocks[fieldId] != null) {
                    blocks[fieldId] = this.constantBlocks[fieldId].getRegion(0, this.currentPageSize);
                    continue;
                }
                if (type instanceof FixedWidthType) {
                    loader = this.blockLoader.fixedWidthBlockLoader(rcFileColumnsBatch, fieldId, this.hiveTypes.get(fieldId));
                    blocks[fieldId] = new LazyFixedWidthBlock(((FixedWidthType)type).getFixedSize(), this.currentPageSize, loader);
                    continue;
                }
                if (type instanceof VariableWidthType) {
                    loader = this.blockLoader.variableWidthBlockLoader(rcFileColumnsBatch, fieldId, this.hiveTypes.get(fieldId), this.fieldInspectors[fieldId]);
                    blocks[fieldId] = new LazySliceArrayBlock(this.currentPageSize, loader);
                    continue;
                }
                loader = this.blockLoader.structuralBlockLoader(rcFileColumnsBatch, fieldId, this.hiveTypes.get(fieldId), this.fieldInspectors[fieldId], type);
                blocks[fieldId] = new LazyArrayBlock(loader);
            }
            Page page = new Page(this.currentPageSize, blocks);
            this.completedBytes = this.recordReader.getPosition() - this.startFilePosition;
            return page;
        }
        catch (IOException | RuntimeException e) {
            this.closeWithSuppression(e);
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CURSOR_ERROR, (Throwable)e);
        }
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.recordReader.close();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("columnNames", this.columnNames).add("types", this.types).toString();
    }

    public long getSystemMemoryUsage() {
        return GUESSED_MEMORY_USAGE;
    }

    private void closeWithSuppression(Throwable throwable) {
        Objects.requireNonNull(throwable, "throwable is null");
        try {
            this.close();
        }
        catch (RuntimeException e) {
            throwable.addSuppressed(e);
        }
    }

    public final class RcFileColumnsBatch {
        private final int expectedBatchId;
        private final int positionInBatch;

        private RcFileColumnsBatch(int expectedBatchId, int positionInBatch) {
            this.expectedBatchId = expectedBatchId;
            this.positionInBatch = positionInBatch;
        }

        public BytesRefArrayWritable getColumn(int fieldId) throws IOException {
            Preconditions.checkState((RcFilePageSource.this.pageId == this.expectedBatchId ? 1 : 0) != 0);
            if (!RcFilePageSource.this.columnBatchLoaded[fieldId]) {
                ((RcFilePageSource)RcFilePageSource.this).columnBatch[fieldId] = RcFilePageSource.this.recordReader.getColumn(RcFilePageSource.this.hiveColumnIndexes[fieldId], RcFilePageSource.this.columnBatch[fieldId]);
                ((RcFilePageSource)RcFilePageSource.this).columnBatchLoaded[fieldId] = true;
            }
            return RcFilePageSource.this.columnBatch[fieldId];
        }

        public int getPositionInBatch() {
            return this.positionInBatch;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("expectedBatchId", this.expectedBatchId).add("positionInBatch", this.positionInBatch).toString();
        }
    }
}

