/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.persistence;

import com.facebook.presto.hive.$internal.org.apache.commons.logging.Log;
import com.facebook.presto.hive.$internal.org.apache.commons.logging.LogFactory;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.persistence.AbstractRowContainer;
import org.apache.hadoop.hive.ql.io.HiveFileFormatUtils;
import org.apache.hadoop.hive.ql.io.HiveOutputFormat;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.StringUtils;
import org.apache.hive.common.util.ReflectionUtil;

public class RowContainer<ROW extends List<Object>>
implements AbstractRowContainer<ROW>,
AbstractRowContainer.RowIterator<ROW> {
    protected static Log LOG = LogFactory.getLog(RowContainer.class);
    private static final int BLOCKSIZE = 25000;
    private ROW[] currentWriteBlock;
    private ROW[] currentReadBlock;
    private ROW[] firstReadBlockPointer;
    private int blockSize;
    private int numFlushedBlocks;
    private long size;
    private File tmpFile;
    Path tempOutPath = null;
    private File parentFile;
    private int itrCursor;
    private int readBlockSize;
    private int addCursor;
    private SerDe serde;
    private ObjectInspector standardOI;
    private List<Object> keyObject;
    private TableDesc tblDesc;
    boolean firstCalled = false;
    int acutalSplitNum = 0;
    int currentSplitPointer = 0;
    RecordReader rr = null;
    FileSinkOperator.RecordWriter rw = null;
    InputFormat<WritableComparable, Writable> inputFormat = null;
    InputSplit[] inputSplits = null;
    private ROW dummyRow = null;
    private final Reporter reporter;
    Writable val = null;
    Configuration jc;
    JobConf jobCloneUsingLocalFs = null;
    private LocalFileSystem localFs;
    private final ArrayList<Object> row = new ArrayList(2);

    public RowContainer(Configuration jc, Reporter reporter) throws HiveException {
        this(25000, jc, reporter);
    }

    public RowContainer(int bs, Configuration jc, Reporter reporter) throws HiveException {
        this.blockSize = bs <= 0 ? 25000 : bs;
        this.size = 0L;
        this.itrCursor = 0;
        this.addCursor = 0;
        this.numFlushedBlocks = 0;
        this.tmpFile = null;
        this.currentWriteBlock = new ArrayList[this.blockSize];
        this.currentReadBlock = this.currentWriteBlock;
        this.firstReadBlockPointer = this.currentReadBlock;
        this.serde = null;
        this.standardOI = null;
        this.jc = jc;
        this.reporter = reporter == null ? Reporter.NULL : reporter;
    }

    private JobConf getLocalFSJobConfClone(Configuration jc) {
        if (this.jobCloneUsingLocalFs == null) {
            this.jobCloneUsingLocalFs = new JobConf(jc);
            HiveConf.setVar((Configuration)this.jobCloneUsingLocalFs, HiveConf.ConfVars.HADOOPFS, Utilities.HADOOP_LOCAL_FS);
        }
        return this.jobCloneUsingLocalFs;
    }

    public void setSerDe(SerDe sd, ObjectInspector oi) {
        this.serde = sd;
        this.standardOI = oi;
    }

    @Override
    public void addRow(ROW t) throws HiveException {
        if (this.tblDesc != null) {
            if (this.willSpill()) {
                this.spillBlock((List[])this.currentWriteBlock, this.addCursor);
                this.addCursor = 0;
                if (this.numFlushedBlocks == 1) {
                    this.currentWriteBlock = new ArrayList[this.blockSize];
                }
            }
            this.currentWriteBlock[this.addCursor++] = t;
        } else if (t != null) {
            this.dummyRow = t;
        }
        ++this.size;
    }

    @Override
    public AbstractRowContainer.RowIterator<ROW> rowIter() {
        return this;
    }

    @Override
    public ROW first() throws HiveException {
        if (this.size == 0L) {
            return null;
        }
        try {
            this.firstCalled = true;
            this.itrCursor = 0;
            this.closeWriter();
            this.closeReader();
            if (this.tblDesc == null) {
                ++this.itrCursor;
                return this.dummyRow;
            }
            this.currentReadBlock = this.firstReadBlockPointer;
            if (this.numFlushedBlocks == 0) {
                this.readBlockSize = this.addCursor;
                this.currentReadBlock = this.currentWriteBlock;
            } else {
                JobConf localJc = this.getLocalFSJobConfClone(this.jc);
                if (this.inputSplits == null) {
                    if (this.inputFormat == null) {
                        this.inputFormat = ReflectionUtil.newInstance(this.tblDesc.getInputFileFormatClass(), (Configuration)localJc);
                    }
                    HiveConf.setVar((Configuration)localJc, HiveConf.ConfVars.HADOOPMAPREDINPUTDIR, StringUtils.escapeString((String)this.parentFile.getAbsolutePath()));
                    this.inputSplits = this.inputFormat.getSplits(localJc, 1);
                    this.acutalSplitNum = this.inputSplits.length;
                }
                this.currentSplitPointer = 0;
                this.rr = this.inputFormat.getRecordReader(this.inputSplits[this.currentSplitPointer], localJc, this.reporter);
                ++this.currentSplitPointer;
                this.nextBlock(0);
            }
            ROW ret = this.currentReadBlock[this.itrCursor++];
            this.removeKeys(ret);
            return ret;
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    @Override
    public ROW next() throws HiveException {
        if (!this.firstCalled) {
            throw new RuntimeException("Call first() then call next().");
        }
        if (this.size == 0L) {
            return null;
        }
        if (this.tblDesc == null) {
            if ((long)this.itrCursor < this.size) {
                ++this.itrCursor;
                return this.dummyRow;
            }
            return null;
        }
        if (this.itrCursor < this.readBlockSize) {
            ROW ret = this.currentReadBlock[this.itrCursor++];
            this.removeKeys(ret);
            return ret;
        }
        this.nextBlock(0);
        if (this.readBlockSize == 0) {
            if (this.currentWriteBlock != null && this.currentReadBlock != this.currentWriteBlock) {
                this.setWriteBlockAsReadBlock();
            } else {
                return null;
            }
        }
        return (ROW)this.next();
    }

    private void removeKeys(ROW ret) {
        if (this.keyObject != null && this.currentReadBlock != this.currentWriteBlock) {
            int len = this.keyObject.size();
            int rowSize = ret.size();
            for (int i = 0; i < len; ++i) {
                ret.remove(rowSize - i - 1);
            }
        }
    }

    private void spillBlock(ROW[] block, int length) throws HiveException {
        try {
            if (this.tmpFile == null) {
                this.setupWriter();
            } else if (this.rw == null) {
                throw new HiveException("RowContainer has already been closed for writing.");
            }
            this.row.clear();
            this.row.add(null);
            this.row.add(null);
            if (this.keyObject != null) {
                this.row.set(1, this.keyObject);
                for (int i = 0; i < length; ++i) {
                    ROW currentValRow = block[i];
                    this.row.set(0, currentValRow);
                    Writable outVal = this.serde.serialize(this.row, this.standardOI);
                    this.rw.write(outVal);
                }
            } else {
                for (int i = 0; i < length; ++i) {
                    ROW currentValRow = block[i];
                    Writable outVal = this.serde.serialize(currentValRow, this.standardOI);
                    this.rw.write(outVal);
                }
            }
            if (block == this.currentWriteBlock) {
                this.addCursor = 0;
            }
            ++this.numFlushedBlocks;
        }
        catch (Exception e) {
            this.clearRows();
            LOG.error(e.toString(), e);
            if (e instanceof HiveException) {
                throw (HiveException)e;
            }
            throw new HiveException(e);
        }
    }

    @Override
    public boolean hasRows() {
        return this.size > 0L;
    }

    @Override
    public boolean isSingleRow() {
        return this.size == 1L;
    }

    @Override
    public int rowCount() {
        return (int)this.size;
    }

    protected boolean nextBlock(int readIntoOffset) throws HiveException {
        this.itrCursor = 0;
        this.readBlockSize = 0;
        if (this.numFlushedBlocks == 0) {
            return false;
        }
        try {
            if (this.val == null) {
                this.val = this.serde.getSerializedClass().newInstance();
            }
            boolean nextSplit = true;
            int i = readIntoOffset;
            if (this.rr != null) {
                Object key = this.rr.createKey();
                while (i < this.currentReadBlock.length && this.rr.next(key, (Object)this.val)) {
                    nextSplit = false;
                    this.currentReadBlock[i++] = (List)ObjectInspectorUtils.copyToStandardObject(this.serde.deserialize(this.val), this.serde.getObjectInspector(), ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
                }
            }
            if (nextSplit && this.currentSplitPointer < this.acutalSplitNum) {
                JobConf localJc = this.getLocalFSJobConfClone(this.jc);
                this.rr = this.inputFormat.getRecordReader(this.inputSplits[this.currentSplitPointer], this.jobCloneUsingLocalFs, this.reporter);
                ++this.currentSplitPointer;
                return this.nextBlock(0);
            }
            this.readBlockSize = i;
            return this.readBlockSize > 0;
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), e);
            try {
                this.clearRows();
            }
            catch (HiveException e1) {
                LOG.error(e.getMessage(), e);
            }
            throw new HiveException(e);
        }
    }

    public void copyToDFSDirecory(FileSystem destFs, Path destPath) throws IOException, HiveException {
        if (this.addCursor > 0) {
            this.spillBlock((List[])this.currentWriteBlock, this.addCursor);
        }
        if (this.tempOutPath == null || this.tempOutPath.toString().trim().equals("")) {
            return;
        }
        this.closeWriter();
        LOG.info("RowContainer copied temp file " + this.tmpFile.getAbsolutePath() + " to dfs directory " + destPath.toString());
        destFs.copyFromLocalFile(true, this.tempOutPath, new Path(destPath, new Path(this.tempOutPath.getName())));
        this.clearRows();
    }

    @Override
    public void clearRows() throws HiveException {
        this.itrCursor = 0;
        this.addCursor = 0;
        this.numFlushedBlocks = 0;
        this.readBlockSize = 0;
        this.acutalSplitNum = 0;
        this.currentSplitPointer = -1;
        this.firstCalled = false;
        this.inputSplits = null;
        this.tempOutPath = null;
        this.addCursor = 0;
        this.size = 0L;
        try {
            if (this.rw != null) {
                this.rw.close(false);
            }
            if (this.rr != null) {
                this.rr.close();
            }
        }
        catch (Exception e) {
            LOG.error(e.toString());
            throw new HiveException(e);
        }
        finally {
            this.rw = null;
            this.rr = null;
            this.tmpFile = null;
            this.deleteLocalFile(this.parentFile, true);
            this.parentFile = null;
        }
    }

    private void deleteLocalFile(File file, boolean recursive) {
        try {
            if (file != null) {
                boolean deleteSuccess;
                if (!file.exists()) {
                    return;
                }
                if (file.isDirectory() && recursive) {
                    File[] files;
                    for (File file2 : files = file.listFiles()) {
                        this.deleteLocalFile(file2, true);
                    }
                }
                if (!(deleteSuccess = file.delete())) {
                    LOG.error("Error deleting tmp file:" + file.getAbsolutePath());
                }
            }
        }
        catch (Exception e) {
            LOG.error("Error deleting tmp file:" + file.getAbsolutePath(), e);
        }
    }

    private void closeWriter() throws IOException {
        if (this.rw != null) {
            this.rw.close(false);
            this.rw = null;
        }
    }

    private void closeReader() throws IOException {
        if (this.rr != null) {
            this.rr.close();
            this.rr = null;
        }
    }

    public void setKeyObject(List<Object> dummyKey) {
        this.keyObject = dummyKey;
    }

    public void setTableDesc(TableDesc tblDesc) {
        this.tblDesc = tblDesc;
    }

    protected int getAddCursor() {
        return this.addCursor;
    }

    protected final boolean willSpill() {
        return this.addCursor >= this.blockSize;
    }

    protected int getBlockSize() {
        return this.blockSize;
    }

    protected void setupWriter() throws HiveException {
        try {
            if (this.tmpFile != null) {
                return;
            }
            String suffix = ".tmp";
            if (this.keyObject != null) {
                suffix = "." + this.keyObject.toString() + suffix;
            }
            while (true) {
                boolean success;
                this.parentFile = File.createTempFile("hive-rowcontainer", "");
                boolean bl = success = this.parentFile.delete() && this.parentFile.mkdir();
                if (success) break;
                LOG.debug("retry creating tmp row-container directory...");
            }
            this.tmpFile = File.createTempFile("RowContainer", suffix, this.parentFile);
            LOG.info("RowContainer created temp file " + this.tmpFile.getAbsolutePath());
            this.parentFile.deleteOnExit();
            this.tmpFile.deleteOnExit();
            HiveOutputFormat<?, ?> hiveOutputFormat = HiveFileFormatUtils.getHiveOutputFormat(this.jc, this.tblDesc);
            this.tempOutPath = new Path(this.tmpFile.toString());
            JobConf localJc = this.getLocalFSJobConfClone(this.jc);
            this.rw = HiveFileFormatUtils.getRecordWriter(this.jobCloneUsingLocalFs, hiveOutputFormat, this.serde.getSerializedClass(), false, this.tblDesc.getProperties(), this.tempOutPath, this.reporter);
        }
        catch (Exception e) {
            this.clearRows();
            LOG.error(e.toString(), e);
            throw new HiveException(e);
        }
    }

    protected FileSinkOperator.RecordWriter getRecordWriter() {
        return this.rw;
    }

    protected InputSplit[] getInputSplits() {
        return this.inputSplits;
    }

    protected boolean endOfCurrentReadBlock() {
        if (this.tblDesc == null) {
            return false;
        }
        return this.itrCursor >= this.readBlockSize;
    }

    protected int getCurrentReadBlockSize() {
        return this.readBlockSize;
    }

    protected void setWriteBlockAsReadBlock() {
        this.itrCursor = 0;
        this.readBlockSize = this.addCursor;
        this.firstReadBlockPointer = this.currentReadBlock;
        this.currentReadBlock = this.currentWriteBlock;
    }

    protected RecordReader setReaderAtSplit(int splitNum) throws IOException {
        JobConf localJc = this.getLocalFSJobConfClone(this.jc);
        this.currentSplitPointer = splitNum;
        if (this.rr != null) {
            this.rr.close();
        }
        this.rr = this.inputFormat.getRecordReader(this.inputSplits[this.currentSplitPointer], this.jobCloneUsingLocalFs, this.reporter);
        ++this.currentSplitPointer;
        return this.rr;
    }

    protected ROW getReadBlockRow(int rowOffset) {
        this.itrCursor = rowOffset + 1;
        return this.currentReadBlock[rowOffset];
    }

    protected void resetCurrentReadBlockToFirstReadBlock() {
        this.currentReadBlock = this.firstReadBlockPointer;
    }

    protected void resetReadBlocks() {
        this.currentReadBlock = this.currentWriteBlock;
        this.firstReadBlockPointer = this.currentReadBlock;
    }

    protected void close() throws HiveException {
        this.clearRows();
        this.currentWriteBlock = null;
        this.firstReadBlockPointer = null;
        this.currentReadBlock = null;
    }
}

