/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.mapjoin;

import com.facebook.presto.hive.$internal.org.apache.commons.logging.Log;
import com.facebook.presto.hive.$internal.org.apache.commons.logging.LogFactory;
import java.io.IOException;
import org.apache.hadoop.hive.ql.exec.JoinUtil;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinGenerateResultOperator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinHashSet;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinHashSetResult;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinHashTableResult;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;

public abstract class VectorMapJoinLeftSemiGenerateResultOperator
extends VectorMapJoinGenerateResultOperator {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = LogFactory.getLog(VectorMapJoinLeftSemiGenerateResultOperator.class.getName());
    protected transient VectorMapJoinHashSetResult[] hashSetResults;
    protected transient int[] allMatchs;
    protected transient int[] spills;
    protected transient int[] spillHashMapResultIndices;

    public VectorMapJoinLeftSemiGenerateResultOperator() {
    }

    public VectorMapJoinLeftSemiGenerateResultOperator(VectorizationContext vContext, OperatorDesc conf) throws HiveException {
        super(vContext, conf);
    }

    @Override
    protected void commonSetup(VectorizedRowBatch batch) throws HiveException {
        super.commonSetup(batch);
        VectorMapJoinHashSet baseHashSet = (VectorMapJoinHashSet)this.vectorMapJoinHashTable;
        this.hashSetResults = new VectorMapJoinHashSetResult[1024];
        for (int i = 0; i < this.hashSetResults.length; ++i) {
            this.hashSetResults[i] = baseHashSet.createHashSetResult();
        }
        this.allMatchs = new int[1024];
        this.spills = new int[1024];
        this.spillHashMapResultIndices = new int[1024];
    }

    protected int finishLeftSemi(VectorizedRowBatch batch, int[] allMatchs, int allMatchCount, int[] spills, int[] spillHashMapResultIndices, int spillCount, VectorMapJoinHashTableResult[] hashTableResults) throws HiveException, IOException {
        if (allMatchCount > 0 && this.bigTableValueExpressions != null) {
            this.performValueExpressions(batch, allMatchs, allMatchCount);
        }
        int numSel = this.generateHashSetResults(batch, allMatchs, allMatchCount);
        if (spillCount > 0) {
            this.spillHashMapBatch(batch, hashTableResults, spills, spillHashMapResultIndices, spillCount);
        }
        return numSel;
    }

    private int generateHashSetResults(VectorizedRowBatch batch, int[] allMatchs, int allMatchCount) throws HiveException, IOException {
        int numSel = 0;
        for (int i = 0; i < allMatchCount; ++i) {
            int batchIndex = allMatchs[i];
            batch.selected[numSel++] = batchIndex;
        }
        return numSel;
    }

    protected int generateHashSetResultRepeatedAll(VectorizedRowBatch batch) throws HiveException {
        if (!batch.selectedInUse) {
            int[] selected = batch.selected;
            for (int i = 0; i < batch.size; ++i) {
                selected[i] = i;
            }
            batch.selectedInUse = true;
        }
        return batch.size;
    }

    protected int finishLeftSemiRepeated(VectorizedRowBatch batch, JoinUtil.JoinResult joinResult, VectorMapJoinHashTableResult hashSetResult) throws HiveException, IOException {
        int numSel = 0;
        switch (joinResult) {
            case MATCH: {
                if (this.bigTableValueExpressions != null) {
                    for (VectorExpression ve : this.bigTableValueExpressions) {
                        ve.evaluate(batch);
                    }
                }
                numSel = this.generateHashSetResultRepeatedAll(batch);
                break;
            }
            case SPILL: {
                this.spillBatchRepeated(batch, hashSetResult);
                break;
            }
        }
        return numSel;
    }
}

