/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.skife.jdbi.v2.SQLStatement;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.BaseStatementCustomizer;
import org.skife.jdbi.v2.tweak.StatementCustomizer;

public final class StatementCustomizers {
    public static final StatementCustomizer MAX_ROW_ONE = new MaxRowsCustomizer(1);

    private StatementCustomizers() {
    }

    public static final class MaxFieldSizeCustomizer
    extends BaseStatementCustomizer {
        private final int maxFieldSize;

        public MaxFieldSizeCustomizer(int maxFieldSize) {
            this.maxFieldSize = maxFieldSize;
        }

        @Override
        public void beforeExecution(PreparedStatement stmt, StatementContext ctx) throws SQLException {
            stmt.setMaxFieldSize(this.maxFieldSize);
        }
    }

    public static final class MaxRowsCustomizer
    extends BaseStatementCustomizer {
        private final int maxRows;

        public MaxRowsCustomizer(int maxRows) {
            this.maxRows = maxRows;
        }

        @Override
        public void beforeExecution(PreparedStatement stmt, StatementContext ctx) throws SQLException {
            stmt.setMaxRows(this.maxRows);
        }
    }

    public static final class FetchSizeCustomizer
    extends BaseStatementCustomizer {
        private final int fetchSize;

        public FetchSizeCustomizer(int fetchSize) {
            this.fetchSize = fetchSize;
        }

        @Override
        public void beforeExecution(PreparedStatement stmt, StatementContext ctx) throws SQLException {
            stmt.setFetchSize(this.fetchSize);
        }
    }

    public static final class QueryTimeoutCustomizer
    extends BaseStatementCustomizer {
        private final int seconds;

        public QueryTimeoutCustomizer(int seconds) {
            this.seconds = seconds;
        }

        @Override
        public void beforeExecution(PreparedStatement stmt, StatementContext ctx) throws SQLException {
            stmt.setQueryTimeout(this.seconds);
        }
    }

    public static class FetchDirectionStatementCustomizer
    extends BaseStatementCustomizer {
        private final Integer direction;

        public FetchDirectionStatementCustomizer(Integer direction) {
            this.direction = direction;
        }

        @Override
        public void beforeExecution(PreparedStatement stmt, StatementContext ctx) throws SQLException {
            stmt.setFetchDirection(this.direction);
        }

        public void apply(SQLStatement q) throws SQLException {
            q.setFetchDirection(this.direction);
        }
    }
}

