/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2.tweak.transactions;

import java.sql.SQLException;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.TransactionCallback;
import org.skife.jdbi.v2.TransactionIsolationLevel;
import org.skife.jdbi.v2.tweak.TransactionHandler;
import org.skife.jdbi.v2.tweak.transactions.DelegatingTransactionHandler;
import org.skife.jdbi.v2.tweak.transactions.LocalTransactionHandler;

public class SerializableTransactionRunner
extends DelegatingTransactionHandler
implements TransactionHandler {
    private static final String SQLSTATE_TXN_SERIALIZATION_FAILED = "40001";
    private final Configuration configuration;

    public SerializableTransactionRunner() {
        this(new Configuration(), new LocalTransactionHandler());
    }

    public SerializableTransactionRunner(Configuration configuration, TransactionHandler delegate) {
        super(delegate);
        this.configuration = configuration;
    }

    @Override
    public <ReturnType> ReturnType inTransaction(Handle handle, TransactionCallback<ReturnType> callback) {
        int retriesRemaining = this.configuration.maxRetries;
        while (true) {
            try {
                return this.getDelegate().inTransaction(handle, callback);
            }
            catch (RuntimeException e) {
                if (this.isSqlState(this.configuration.serializationFailureSqlState, e) && --retriesRemaining > 0) continue;
                throw e;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <ReturnType> ReturnType inTransaction(Handle handle, TransactionIsolationLevel level, TransactionCallback<ReturnType> callback) {
        TransactionIsolationLevel initial = handle.getTransactionIsolationLevel();
        try {
            handle.setTransactionIsolation(level);
            ReturnType ReturnType = this.inTransaction(handle, callback);
            return ReturnType;
        }
        finally {
            handle.setTransactionIsolation(initial);
        }
    }

    protected boolean isSqlState(String expectedSqlState, Throwable throwable) {
        do {
            String sqlState;
            if (!(throwable instanceof SQLException) || (sqlState = ((SQLException)throwable).getSQLState()) == null || !sqlState.startsWith(expectedSqlState)) continue;
            return true;
        } while ((throwable = throwable.getCause()) != null);
        return false;
    }

    public static class Configuration {
        private final int maxRetries;
        private final String serializationFailureSqlState;

        public Configuration() {
            this(5, SerializableTransactionRunner.SQLSTATE_TXN_SERIALIZATION_FAILED);
        }

        private Configuration(int maxRetries, String serializationFailureSqlState) {
            this.maxRetries = maxRetries;
            this.serializationFailureSqlState = serializationFailureSqlState;
        }

        public Configuration withMaxRetries(int maxRetries) {
            return new Configuration(maxRetries, this.serializationFailureSqlState);
        }

        public Configuration withSerializationFailureSqlState(String serializationFailureSqlState) {
            return new Configuration(this.maxRetries, serializationFailureSqlState);
        }
    }
}

