/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.stream;

import com.facebook.presto.orc.OrcCorruptionException;
import com.facebook.presto.orc.checkpoint.ByteStreamCheckpoint;
import com.facebook.presto.orc.stream.OrcInputStream;
import com.facebook.presto.orc.stream.OrcStreamUtils;
import com.facebook.presto.orc.stream.ValueStream;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.Type;
import java.io.IOException;
import java.util.Arrays;

public class ByteStream
implements ValueStream<ByteStreamCheckpoint> {
    private final OrcInputStream input;
    private final byte[] buffer = new byte[130];
    private int length;
    private int offset;
    private long lastReadInputCheckpoint;

    public ByteStream(OrcInputStream input) {
        this.input = input;
        this.lastReadInputCheckpoint = input.getCheckpoint();
    }

    private void readNextBlock() throws IOException {
        this.lastReadInputCheckpoint = this.input.getCheckpoint();
        int control = this.input.read();
        if (control == -1) {
            throw new OrcCorruptionException("Read past end of buffer RLE byte from %s", this.input);
        }
        this.offset = 0;
        if ((control & 0x80) == 0) {
            this.length = control + 3;
            int value = this.input.read();
            if (value == -1) {
                throw new OrcCorruptionException("Reading RLE byte got EOF");
            }
            Arrays.fill(this.buffer, 0, this.length, (byte)value);
        } else {
            this.length = 256 - control;
            OrcStreamUtils.readFully(this.input, this.buffer, 0, this.length);
        }
    }

    @Override
    public Class<ByteStreamCheckpoint> getCheckpointType() {
        return ByteStreamCheckpoint.class;
    }

    @Override
    public void seekToCheckpoint(ByteStreamCheckpoint checkpoint) throws IOException {
        if (this.lastReadInputCheckpoint == checkpoint.getInputStreamCheckpoint() && checkpoint.getOffset() <= this.length) {
            this.offset = checkpoint.getOffset();
        } else {
            this.input.seekToCheckpoint(checkpoint.getInputStreamCheckpoint());
            this.length = 0;
            this.offset = 0;
            this.skip(checkpoint.getOffset());
        }
    }

    @Override
    public void skip(long items) throws IOException {
        while (items > 0L) {
            if (this.offset == this.length) {
                this.readNextBlock();
            }
            long consume = Math.min(items, (long)(this.length - this.offset));
            this.offset = (int)((long)this.offset + consume);
            items -= consume;
        }
    }

    public byte next() throws IOException {
        if (this.offset == this.length) {
            this.readNextBlock();
        }
        return this.buffer[this.offset++];
    }

    public void nextVector(Type type, long items, BlockBuilder builder) throws IOException {
        int i = 0;
        while ((long)i < items) {
            type.writeLong(builder, (long)this.next());
            ++i;
        }
    }

    public void nextVector(Type type, long items, BlockBuilder builder, boolean[] isNull) throws IOException {
        int i = 0;
        while ((long)i < items) {
            if (isNull[i]) {
                builder.appendNull();
            } else {
                type.writeLong(builder, (long)this.next());
            }
            ++i;
        }
    }
}

