/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sqlfunction;

import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.function.FunctionKind;
import com.facebook.presto.spi.function.FunctionMetadata;
import com.facebook.presto.spi.function.FunctionNamespaceManager;
import com.facebook.presto.spi.function.FunctionNamespaceTransactionHandle;
import com.facebook.presto.spi.function.Signature;
import com.facebook.presto.spi.relation.FullyQualifiedName;
import com.facebook.presto.sqlfunction.SqlFunctionId;
import com.facebook.presto.sqlfunction.SqlInvokedFunctionNamespaceManagerConfig;
import com.facebook.presto.sqlfunction.SqlInvokedRegularFunction;
import com.facebook.presto.sqlfunction.SqlInvokedRegularFunctionHandle;
import com.facebook.presto.sqlfunction.UuidFunctionNamespaceTransactionHandle;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.GuardedBy;

public abstract class AbstractSqlInvokedFunctionNamespaceManager
implements FunctionNamespaceManager<SqlInvokedRegularFunction> {
    private final ConcurrentMap<FunctionNamespaceTransactionHandle, FunctionCollection> transactions = new ConcurrentHashMap<FunctionNamespaceTransactionHandle, FunctionCollection>();
    private final LoadingCache<FullyQualifiedName, Collection<SqlInvokedRegularFunction>> functions;
    private final LoadingCache<SqlInvokedRegularFunctionHandle, FunctionMetadata> metadataByHandle;

    public AbstractSqlInvokedFunctionNamespaceManager(SqlInvokedFunctionNamespaceManagerConfig config) {
        this.functions = CacheBuilder.newBuilder().expireAfterWrite(config.getFunctionCacheExpiration().toMillis(), TimeUnit.MILLISECONDS).build((CacheLoader)new CacheLoader<FullyQualifiedName, Collection<SqlInvokedRegularFunction>>(){

            public Collection<SqlInvokedRegularFunction> load(FullyQualifiedName functionName) {
                Collection<SqlInvokedRegularFunction> functions = AbstractSqlInvokedFunctionNamespaceManager.this.fetchFunctionsDirect(functionName);
                for (SqlInvokedRegularFunction function : functions) {
                    AbstractSqlInvokedFunctionNamespaceManager.this.metadataByHandle.put((Object)function.getRequiredFunctionHandle(), (Object)AbstractSqlInvokedFunctionNamespaceManager.sqlInvokedFunctionToMetadata(function));
                }
                return functions;
            }
        });
        this.metadataByHandle = CacheBuilder.newBuilder().expireAfterWrite(config.getMetadataCacheExpiration().toMillis(), TimeUnit.MILLISECONDS).build((CacheLoader)new CacheLoader<SqlInvokedRegularFunctionHandle, FunctionMetadata>(){

            public FunctionMetadata load(SqlInvokedRegularFunctionHandle functionHandle) {
                return AbstractSqlInvokedFunctionNamespaceManager.this.fetchFunctionMetadataDirect(functionHandle);
            }
        });
    }

    protected abstract Collection<SqlInvokedRegularFunction> fetchFunctionsDirect(FullyQualifiedName var1);

    protected abstract FunctionMetadata fetchFunctionMetadataDirect(SqlInvokedRegularFunctionHandle var1);

    public final FunctionNamespaceTransactionHandle beginTransaction() {
        UuidFunctionNamespaceTransactionHandle transactionHandle = UuidFunctionNamespaceTransactionHandle.create();
        this.transactions.put(transactionHandle, new FunctionCollection());
        return transactionHandle;
    }

    public final void commit(FunctionNamespaceTransactionHandle transactionHandle) {
        this.transactions.remove(transactionHandle);
    }

    public final void rollback(FunctionNamespaceTransactionHandle transactionHandle) {
        this.transactions.remove(transactionHandle);
    }

    public final Collection<SqlInvokedRegularFunction> getFunctions(Optional<? extends FunctionNamespaceTransactionHandle> transactionHandle, FullyQualifiedName functionName) {
        Preconditions.checkArgument((boolean)transactionHandle.isPresent(), (Object)"missing transactionHandle");
        return ((FunctionCollection)this.transactions.get(transactionHandle.get())).loadAndGetFunctionsTransactional(functionName);
    }

    public final FunctionHandle getFunctionHandle(Optional<? extends FunctionNamespaceTransactionHandle> transactionHandle, Signature signature) {
        Preconditions.checkArgument((boolean)transactionHandle.isPresent(), (Object)"missing transactionHandle");
        SqlFunctionId functionId = new SqlFunctionId(signature.getName(), signature.getArgumentTypes());
        return ((FunctionCollection)this.transactions.get(transactionHandle.get())).getFunctionHandle(functionId);
    }

    public final FunctionMetadata getFunctionMetadata(FunctionHandle functionHandle) {
        Preconditions.checkArgument((boolean)(functionHandle instanceof SqlInvokedRegularFunctionHandle), (String)"Unsupported FunctionHandle type '%s'", (Object)functionHandle.getClass().getSimpleName());
        return (FunctionMetadata)this.metadataByHandle.getUnchecked((Object)((SqlInvokedRegularFunctionHandle)functionHandle));
    }

    protected static FunctionMetadata sqlInvokedFunctionToMetadata(SqlInvokedRegularFunction function) {
        return new FunctionMetadata(function.getSignature().getName(), function.getSignature().getArgumentTypes(), function.getSignature().getReturnType(), FunctionKind.SCALAR, function.isDeterministic(), function.isCalledOnNullInput());
    }

    private Collection<SqlInvokedRegularFunction> fetchFunctions(FullyQualifiedName functionName) {
        return (Collection)this.functions.getUnchecked((Object)functionName);
    }

    private class FunctionCollection {
        @GuardedBy(value="this")
        private final Map<FullyQualifiedName, Collection<SqlInvokedRegularFunction>> functions = new ConcurrentHashMap<FullyQualifiedName, Collection<SqlInvokedRegularFunction>>();
        @GuardedBy(value="this")
        private final Map<SqlFunctionId, SqlInvokedRegularFunctionHandle> functionHandles = new ConcurrentHashMap<SqlFunctionId, SqlInvokedRegularFunctionHandle>();

        private FunctionCollection() {
        }

        public synchronized Collection<SqlInvokedRegularFunction> loadAndGetFunctionsTransactional(FullyQualifiedName functionName) {
            Collection functions = this.functions.computeIfAbsent(functionName, x$0 -> AbstractSqlInvokedFunctionNamespaceManager.this.fetchFunctions(x$0));
            this.functionHandles.putAll((Map)functions.stream().collect(ImmutableMap.toImmutableMap(SqlInvokedRegularFunction::getFunctionId, SqlInvokedRegularFunction::getRequiredFunctionHandle)));
            return functions;
        }

        public synchronized FunctionHandle getFunctionHandle(SqlFunctionId functionId) {
            return this.functionHandles.get(functionId);
        }
    }
}

