/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sqlfunction;

import com.facebook.presto.spi.relation.FullyQualifiedName;
import com.facebook.presto.spi.type.TypeSignature;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class SqlFunctionId {
    private final FullyQualifiedName name;
    private final List<TypeSignature> argumentTypes;

    public SqlFunctionId(FullyQualifiedName name, List<TypeSignature> argumentTypes) {
        this.name = Objects.requireNonNull(name, "name is null");
        this.argumentTypes = Objects.requireNonNull(argumentTypes, "argumentTypes is null");
    }

    public FullyQualifiedName getName() {
        return this.name;
    }

    public List<TypeSignature> getArgumentTypes() {
        return this.argumentTypes;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SqlFunctionId o = (SqlFunctionId)obj;
        return Objects.equals(this.name, o.name) && Objects.equals(this.argumentTypes, o.argumentTypes);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.argumentTypes);
    }

    public String toString() {
        String arguments = this.argumentTypes.stream().map(Object::toString).collect(Collectors.joining(", "));
        return String.format("%s(%s)", this.name, arguments);
    }
}

