/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sqlfunction;

import com.facebook.presto.spi.function.FunctionKind;
import com.facebook.presto.spi.function.Signature;
import com.facebook.presto.spi.function.SqlFunction;
import com.facebook.presto.spi.relation.FullyQualifiedName;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.sqlfunction.RoutineCharacteristics;
import com.facebook.presto.sqlfunction.SqlFunctionId;
import com.facebook.presto.sqlfunction.SqlInvokedRegularFunctionHandle;
import com.facebook.presto.sqlfunction.SqlParameter;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class SqlInvokedRegularFunction
implements SqlFunction {
    private final List<SqlParameter> parameters;
    private final Optional<String> comment;
    private final RoutineCharacteristics routineCharacteristics;
    private final String body;
    private final Signature signature;
    private final SqlFunctionId functionId;
    private final Optional<SqlInvokedRegularFunctionHandle> functionHandle;

    public SqlInvokedRegularFunction(FullyQualifiedName functionName, List<SqlParameter> parameters, TypeSignature returnType, Optional<String> comment, RoutineCharacteristics routineCharacteristics, String body, Optional<Long> version) {
        this.parameters = Objects.requireNonNull(parameters, "parameters is null");
        this.comment = Objects.requireNonNull(comment, "comment is null");
        this.routineCharacteristics = Objects.requireNonNull(routineCharacteristics, "routineCharacteristics is null");
        this.body = Objects.requireNonNull(body, "body is null");
        List argumentTypes = parameters.stream().map(SqlParameter::getType).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
        this.signature = new Signature(functionName, FunctionKind.SCALAR, returnType, argumentTypes);
        this.functionId = new SqlFunctionId(functionName, argumentTypes);
        this.functionHandle = version.map(v -> new SqlInvokedRegularFunctionHandle(functionName, argumentTypes, (long)v));
    }

    public static SqlInvokedRegularFunction versioned(SqlInvokedRegularFunction function, long version) {
        if (function.getVersion().isPresent()) {
            throw new IllegalArgumentException(String.format("function %s is already versioned", function.getVersion().get()));
        }
        return new SqlInvokedRegularFunction(function.getSignature().getName(), function.getParameters(), function.getSignature().getReturnType(), function.comment, function.getRoutineCharacteristics(), function.getBody(), Optional.of(version));
    }

    public Signature getSignature() {
        return this.signature;
    }

    public boolean isHidden() {
        return false;
    }

    public boolean isDeterministic() {
        return this.routineCharacteristics.isDeterministic();
    }

    public boolean isCalledOnNullInput() {
        return this.routineCharacteristics.isCalledOnNullInput();
    }

    public String getDescription() {
        return this.comment.orElse("");
    }

    public List<SqlParameter> getParameters() {
        return this.parameters;
    }

    public Optional<String> getComment() {
        return this.comment;
    }

    public RoutineCharacteristics getRoutineCharacteristics() {
        return this.routineCharacteristics;
    }

    public String getBody() {
        return this.body;
    }

    public SqlFunctionId getFunctionId() {
        return this.functionId;
    }

    public SqlInvokedRegularFunctionHandle getRequiredFunctionHandle() {
        Preconditions.checkState((boolean)this.functionHandle.isPresent(), (Object)"missing function handle");
        return this.functionHandle.get();
    }

    public Optional<Long> getVersion() {
        return this.functionHandle.map(SqlInvokedRegularFunctionHandle::getVersion);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SqlInvokedRegularFunction o = (SqlInvokedRegularFunction)obj;
        return Objects.equals(this.parameters, o.parameters) && Objects.equals(this.comment, o.comment) && Objects.equals(this.routineCharacteristics, o.routineCharacteristics) && Objects.equals(this.body, o.body) && Objects.equals(this.signature, o.signature) && Objects.equals(this.functionId, o.functionId) && Objects.equals(this.functionHandle, o.functionHandle);
    }

    public int hashCode() {
        return Objects.hash(this.parameters, this.comment, this.routineCharacteristics, this.body, this.signature, this.functionId, this.functionHandle);
    }

    public String toString() {
        return String.format("%s(%s):%s%s {%s} %s", this.signature.getName(), this.parameters.stream().map(Object::toString).collect(Collectors.joining(",")), this.signature.getReturnType(), this.getVersion().map(version -> ":" + version).orElse(""), this.body, this.routineCharacteristics);
    }
}

