/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sqlfunction;

import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.relation.FullyQualifiedName;
import com.facebook.presto.spi.type.TypeSignature;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class SqlInvokedRegularFunctionHandle
implements FunctionHandle {
    private final FullyQualifiedName name;
    private final List<TypeSignature> argumentTypes;
    private final long version;

    @JsonCreator
    public SqlInvokedRegularFunctionHandle(@JsonProperty(value="name") FullyQualifiedName name, @JsonProperty(value="argumentTypes") List<TypeSignature> argumentTypes, @JsonProperty(value="version") long version) {
        this.name = Objects.requireNonNull(name, "name is null");
        this.argumentTypes = Objects.requireNonNull(argumentTypes, "argumentTypes is null");
        this.version = version;
    }

    @JsonProperty
    public FullyQualifiedName getName() {
        return this.name;
    }

    @JsonProperty
    public List<TypeSignature> getArgumentTypes() {
        return this.argumentTypes;
    }

    @JsonProperty
    public long getVersion() {
        return this.version;
    }

    public FullyQualifiedName.Prefix getFunctionNamespace() {
        return this.name.getPrefix();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SqlInvokedRegularFunctionHandle o = (SqlInvokedRegularFunctionHandle)obj;
        return Objects.equals(this.name, o.name) && Objects.equals(this.argumentTypes, o.argumentTypes) && Objects.equals(this.version, o.version);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.argumentTypes, this.version);
    }

    public String toString() {
        String arguments = this.argumentTypes.stream().map(Object::toString).collect(Collectors.joining(", "));
        return String.format("%s(%s):%s", this.name, arguments, this.version);
    }
}

