/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.jdbc;

import com.facebook.presto.plugin.jdbc.JdbcClient;
import com.facebook.presto.plugin.jdbc.JdbcMetadata;
import com.facebook.presto.plugin.jdbc.JdbcMetadataConfig;
import java.util.Objects;
import javax.inject.Inject;

public class JdbcMetadataFactory {
    private final JdbcClient jdbcClient;
    private final boolean allowDropTable;

    @Inject
    public JdbcMetadataFactory(JdbcClient jdbcClient, JdbcMetadataConfig config) {
        this.jdbcClient = Objects.requireNonNull(jdbcClient, "jdbcClient is null");
        Objects.requireNonNull(config, "config is null");
        this.allowDropTable = config.isAllowDropTable();
    }

    public JdbcMetadata create() {
        return new JdbcMetadata(this.jdbcClient, this.allowDropTable);
    }
}

