/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.jdbc.optimization;

import com.facebook.presto.plugin.jdbc.JdbcClient;
import com.facebook.presto.plugin.jdbc.optimization.JdbcComputePushdown;
import com.facebook.presto.plugin.jdbc.optimization.function.OperatorTranslators;
import com.facebook.presto.spi.ConnectorPlanOptimizer;
import com.facebook.presto.spi.connector.ConnectorPlanOptimizerProvider;
import com.facebook.presto.spi.function.FunctionMetadataManager;
import com.facebook.presto.spi.function.StandardFunctionResolution;
import com.facebook.presto.spi.relation.DeterminismEvaluator;
import com.facebook.presto.spi.relation.ExpressionOptimizer;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import java.util.Objects;
import java.util.Set;

public class JdbcPlanOptimizerProvider
implements ConnectorPlanOptimizerProvider {
    private final FunctionMetadataManager functionManager;
    private final StandardFunctionResolution functionResolution;
    private final DeterminismEvaluator determinismEvaluator;
    private final ExpressionOptimizer expressionOptimizer;
    private final String identifierQuote;

    @Inject
    public JdbcPlanOptimizerProvider(JdbcClient jdbcClient, FunctionMetadataManager functionManager, StandardFunctionResolution functionResolution, DeterminismEvaluator determinismEvaluator, ExpressionOptimizer expressionOptimizer) {
        this.functionManager = Objects.requireNonNull(functionManager, "functionManager is null");
        this.functionResolution = Objects.requireNonNull(functionResolution, "functionResolution is null");
        this.determinismEvaluator = Objects.requireNonNull(determinismEvaluator, "determinismEvaluator is null");
        this.expressionOptimizer = Objects.requireNonNull(expressionOptimizer, "expressionOptimizer is null");
        this.identifierQuote = jdbcClient.getIdentifierQuote();
    }

    public Set<ConnectorPlanOptimizer> getLogicalPlanOptimizers() {
        return ImmutableSet.of();
    }

    public Set<ConnectorPlanOptimizer> getPhysicalPlanOptimizers() {
        return ImmutableSet.of((Object)new JdbcComputePushdown(this.functionManager, this.functionResolution, this.determinismEvaluator, this.expressionOptimizer, this.identifierQuote, this.getFunctionTranslators()));
    }

    private Set<Class<?>> getFunctionTranslators() {
        return ImmutableSet.of(OperatorTranslators.class);
    }
}

