/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.teradata.functions;

import com.facebook.presto.Session;
import com.facebook.presto.common.type.DateType;
import com.facebook.presto.common.type.SqlDate;
import com.facebook.presto.common.type.TimestampType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.metadata.FunctionExtractor;
import com.facebook.presto.operator.scalar.AbstractTestFunctions;
import com.facebook.presto.teradata.functions.TeradataFunctionsPlugin;
import com.facebook.presto.testing.DateTimeTestingUtils;
import com.facebook.presto.testing.TestingSession;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Collection;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestTeradataDateFunctions
extends AbstractTestFunctions {
    private static final Session SESSION = TestingSession.testSessionBuilder().setCatalog("catalog").setSchema("schema").build();

    protected TestTeradataDateFunctions() {
        super(SESSION);
    }

    @BeforeClass
    public void setUp() {
        this.functionAssertions.addFunctions(FunctionExtractor.extractFunctions((Collection)new TeradataFunctionsPlugin().getFunctions()));
    }

    @Test
    public void testMinimalToDate() {
        this.assertDate("to_date('1988/04/08','yyyy/mm/dd')", 1988, 4, 8);
        this.assertDate("to_date('04-08-1988','mm-dd-yyyy')", 1988, 4, 8);
        this.assertDate("to_date('04.1988,08','mm.yyyy,dd')", 1988, 4, 8);
        this.assertDate("to_date(';198804:08',';yyyymm:dd')", 1988, 4, 8);
    }

    @Test
    public void testMinimalToTimestamp() {
        this.assertTimestamp("to_timestamp('1988/04/08','yyyy/mm/dd')", 1988, 4, 8, 0, 0, 0);
        this.assertTimestamp("to_timestamp('04-08-1988','mm-dd-yyyy')", 1988, 4, 8, 0, 0, 0);
        this.assertTimestamp("to_timestamp('04.1988,08','mm.yyyy,dd')", 1988, 4, 8, 0, 0, 0);
        this.assertTimestamp("to_timestamp(';198804:08',';yyyymm:dd')", 1988, 4, 8, 0, 0, 0);
        this.assertTimestamp("to_timestamp('1988/04/08 2','yyyy/mm/dd hh')", 1988, 4, 8, 2, 0, 0);
        this.assertTimestamp("to_timestamp('1988/04/08 14','yyyy/mm/dd hh24')", 1988, 4, 8, 14, 0, 0);
        this.assertTimestamp("to_timestamp('1988/04/08 14:15','yyyy/mm/dd hh24:mi')", 1988, 4, 8, 14, 15, 0);
        this.assertTimestamp("to_timestamp('1988/04/08 14:15:16','yyyy/mm/dd hh24:mi:ss')", 1988, 4, 8, 14, 15, 16);
        this.assertTimestamp("to_timestamp('1988/04/08 2:3:4','yyyy/mm/dd hh24:mi:ss')", 1988, 4, 8, 2, 3, 4);
        this.assertTimestamp("to_timestamp('1988/04/08 02:03:04','yyyy/mm/dd hh24:mi:ss')", 1988, 4, 8, 2, 3, 4);
    }

    @Test
    public void testMinimalToChar() {
        this.assertVarchar("to_char(TIMESTAMP '1988-04-08 02:03:04','yyyy/mm/dd hh:mi:ss')", "1988/04/08 02:03:04");
        this.assertVarchar("to_char(TIMESTAMP '1988-04-08 02:03:04','yyyy/mm/dd hh24:mi:ss')", "1988/04/08 02:03:04");
        this.assertVarchar("to_char(TIMESTAMP '1988-04-08 14:15:16','yyyy/mm/dd hh24:mi:ss')", "1988/04/08 14:15:16");
        this.assertVarchar("to_char(TIMESTAMP '1988-04-08 14:15:16 +02:09','yyyy/mm/dd hh24:mi:ss')", "1988/04/08 14:15:16");
        this.assertVarchar("to_char(DATE '1988-04-08','yyyy/mm/dd hh24:mi:ss')", "1988/04/08 00:00:00");
    }

    @Test
    public void testYY() {
        this.assertVarchar("to_char(TIMESTAMP '1988-04-08','yy')", "88");
        this.assertTimestamp("to_timestamp('88/04/08','yy/mm/dd')", 2088, 4, 8, 0, 0, 0);
        this.assertDate("to_date('88/04/08','yy/mm/dd')", 2088, 4, 8);
        this.assertTimestamp("to_timestamp('00/04/08','yy/mm/dd')", 2000, 4, 8, 0, 0, 0);
        this.assertTimestamp("to_timestamp('50/04/08','yy/mm/dd')", 2050, 4, 8, 0, 0, 0);
        this.assertTimestamp("to_timestamp('99/04/08','yy/mm/dd')", 2099, 4, 8, 0, 0, 0);
    }

    @Test(enabled=false)
    public void testDefaultValues() {
        LocalDateTime current = LocalDateTime.now();
        this.assertDate("to_date('1988','yyyy')", 1988, current.getMonthValue(), 1);
        this.assertDate("to_date('04','mm')", current.getYear(), 4, 1);
        this.assertDate("to_date('8','dd')", current.getYear(), current.getMonthValue(), 8);
    }

    @Test(enabled=false)
    public void testCaseInsensitive() {
        this.assertDate("to_date('1988/04/08','YYYY/MM/DD')", 1988, 4, 8);
        this.assertDate("to_date('1988/04/08','yYYy/mM/Dd')", 1988, 4, 8);
    }

    @Test
    public void testWhitespace() {
        this.assertDate("to_date('8 04 1988','dd mm yyyy')", 1988, 4, 8);
    }

    @Test(enabled=false)
    public void testEscapedText() {
        this.assertDate("to_date('1988-04-08 TEXT','yyyy-mm-dd \"TEXT\"')", 1988, 4, 8);
    }

    private void assertTimestamp(String projection, int year, int month, int day, int hour, int minutes, int seconds) {
        this.assertFunction(projection, (Type)TimestampType.TIMESTAMP, DateTimeTestingUtils.sqlTimestampOf((int)year, (int)month, (int)day, (int)hour, (int)minutes, (int)seconds, (int)0, (Session)SESSION));
    }

    private void assertDate(String projection, int year, int month, int day) {
        this.assertFunction(projection, (Type)DateType.DATE, new SqlDate(Math.toIntExact(LocalDate.of(year, month, day).toEpochDay())));
    }

    private void assertVarchar(String projection, String expected) {
        this.assertFunction(projection, (Type)VarcharType.VARCHAR, expected);
    }
}

