/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.teradata.functions.dateformat;

import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.teradata.functions.dateformat.DateFormatParser;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.Token;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestDateFormatParser {
    @Test
    public void testTokenize() {
        Assert.assertEquals((Collection)DateFormatParser.tokenize((String)"yyyy mm").stream().map(Token::getType).collect(Collectors.toList()), Arrays.asList(7, 9, 4));
    }

    @Test
    public void testGreedinessLongFirst() {
        Assert.assertEquals((int)1, (int)DateFormatParser.tokenize((String)"yy").size());
        Assert.assertEquals((int)1, (int)DateFormatParser.tokenize((String)"yyyy").size());
        Assert.assertEquals((int)2, (int)DateFormatParser.tokenize((String)"yyyyyy").size());
    }

    @Test
    public void testInvalidTokenTokenize() {
        Assert.assertEquals((Collection)DateFormatParser.tokenize((String)"ala").stream().map(Token::getType).collect(Collectors.toList()), Arrays.asList(10, 10, 10));
    }

    @Test(expectedExceptions={PrestoException.class})
    public void testInvalidTokenCreate1() {
        DateFormatParser.createDateTimeFormatter((String)"ala", (DateFormatParser.Mode)DateFormatParser.Mode.FORMATTER);
    }

    @Test(expectedExceptions={PrestoException.class})
    public void testInvalidTokenCreate2() {
        DateFormatParser.createDateTimeFormatter((String)"yyym/mm/dd", (DateFormatParser.Mode)DateFormatParser.Mode.FORMATTER);
    }

    @Test(expectedExceptions={PrestoException.class})
    public void testParserInvalidTokenCreate1() {
        DateFormatParser.createDateTimeFormatter((String)"ala", (DateFormatParser.Mode)DateFormatParser.Mode.PARSER);
    }

    @Test(expectedExceptions={PrestoException.class})
    public void testParserInvalidTokenCreate2() {
        DateFormatParser.createDateTimeFormatter((String)"yyym/mm/dd", (DateFormatParser.Mode)DateFormatParser.Mode.PARSER);
    }

    @Test
    public void testCreateDateTimeFormatter() {
        DateTimeFormatter formatter = DateFormatParser.createDateTimeFormatter((String)"yyyy/mm/dd", (DateFormatParser.Mode)DateFormatParser.Mode.FORMATTER);
        Assert.assertEquals((String)formatter.format(LocalDateTime.of(1988, 4, 8, 0, 0)), (String)"1988/04/08");
    }

    @Test
    public void testCreateDateTimeParser() {
        DateTimeFormatter formatter = DateFormatParser.createDateTimeFormatter((String)"yyyy/mm/dd", (DateFormatParser.Mode)DateFormatParser.Mode.PARSER);
        Assert.assertEquals((Object)LocalDateTime.parse("1988/04/08", formatter), (Object)LocalDateTime.of(1988, 4, 8, 0, 0));
    }
}

