/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.testing.mysql;

import com.facebook.presto.testing.mysql.EmbeddedMySql;
import com.facebook.presto.testing.mysql.MySqlOptions;
import com.google.common.base.MoreObjects;
import com.google.common.base.StandardSystemProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteStreams;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import io.airlift.command.Command;
import io.airlift.command.CommandFailedException;
import io.airlift.concurrent.Threads;
import io.airlift.log.Logger;
import io.airlift.units.Duration;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Objects;
import java.util.TimeZone;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class AbstractEmbeddedMySql
implements EmbeddedMySql {
    private static final Logger log = Logger.get(AbstractEmbeddedMySql.class);
    private static final String JDBC_FORMAT = "jdbc:mysql://localhost:%s/%s?user=%s&useSSL=false&serverTimezone=" + TimeZone.getDefault().getID();
    private final ExecutorService executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"testing-mysql-server-%s"));
    private final Path serverDirectory;
    private final int port = AbstractEmbeddedMySql.randomPort();
    private final AtomicBoolean closed = new AtomicBoolean();
    private final Process mysqld;
    private final Duration startupWait;
    private final Duration shutdownWait;
    private final Duration commandTimeout;

    public AbstractEmbeddedMySql(MySqlOptions mySqlOptions) throws IOException {
        this.startupWait = Objects.requireNonNull(mySqlOptions.getStartupWait(), "startupWait is null");
        this.shutdownWait = Objects.requireNonNull(mySqlOptions.getShutdownWait(), "shutdownWait is null");
        this.commandTimeout = Objects.requireNonNull(mySqlOptions.getCommandTimeout(), "commandTimeout is null");
        this.serverDirectory = Files.createTempDirectory("testing-mysql-server", new FileAttribute[0]);
        log.info("Starting MySQL server in %s", new Object[]{this.serverDirectory});
        try {
            this.unpackMySql(this.serverDirectory);
            this.initialize();
            this.mysqld = this.startMysqld();
        }
        catch (Exception e) {
            this.close();
            throw e;
        }
    }

    public abstract List<String> getInitializationArguments();

    public abstract List<String> getStartArguments();

    public String getJdbcUrl(String userName, String dbName) {
        return String.format(JDBC_FORMAT, this.port, dbName, userName);
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public Connection getMySqlDatabase() throws SQLException {
        return DriverManager.getConnection(this.getJdbcUrl("root", "mysql"));
    }

    protected String getMysqld() {
        return this.serverDirectory.resolve("bin").resolve("mysqld").toString();
    }

    protected String getDataDirectory() {
        return this.serverDirectory.resolve("data").toString();
    }

    protected String getShareDirectory() {
        return this.serverDirectory.resolve("share").toString();
    }

    protected String getSocketDirectory() {
        return this.serverDirectory.resolve("mysql.sock").toString();
    }

    @Override
    public void close() {
        if (this.closed.getAndSet(true)) {
            return;
        }
        if (this.mysqld != null) {
            log.info("Shutting down mysqld. Waiting up to %s for shutdown to finish.", new Object[]{this.startupWait});
            this.mysqld.destroyForcibly();
            try {
                this.mysqld.waitFor(this.shutdownWait.toMillis(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            if (this.mysqld.isAlive()) {
                log.error("mysqld is still running in %s", new Object[]{this.serverDirectory});
            }
        }
        try {
            MoreFiles.deleteRecursively((Path)this.serverDirectory, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
        }
        catch (IOException e) {
            log.warn((Throwable)e, "Failed to delete %s", new Object[]{this.serverDirectory});
        }
        this.executor.shutdownNow();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("serverDirectory", (Object)this.serverDirectory).add("port", this.port).toString();
    }

    private static int randomPort() throws IOException {
        try (ServerSocket socket = new ServerSocket(0);){
            int n = socket.getLocalPort();
            return n;
        }
    }

    private void initialize() {
        this.system((List<String>)ImmutableList.builder().add((Object)this.getMysqld()).addAll(this.getInitializationArguments()).build());
    }

    private Process startMysqld() throws IOException {
        Process process = new ProcessBuilder((List<String>)ImmutableList.builder().add((Object)this.getMysqld()).addAll(this.getStartArguments()).build()).redirectErrorStream(true).start();
        log.info("mysqld started on port %s. Waiting up to %s for startup to finish.", new Object[]{this.port, this.startupWait});
        this.startOutputProcessor(process.getInputStream());
        this.waitForServerStartup(process);
        return process;
    }

    private void waitForServerStartup(Process process) throws IOException {
        SQLException lastCause = null;
        long start = System.nanoTime();
        while (Duration.nanosSince((long)start).compareTo(this.startupWait) <= 0) {
            try {
                this.checkReady();
                log.info("mysqld startup finished");
                return;
            }
            catch (SQLException e) {
                lastCause = e;
                try {
                    int value = process.exitValue();
                    throw new IOException(String.format("mysqld exited with value %s, check stdout for more detail", value));
                }
                catch (IllegalThreadStateException value) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e2) {
                        Thread.currentThread().interrupt();
                        return;
                    }
                }
            }
        }
        throw new IOException("mysqld failed to start after " + this.startupWait, lastCause);
    }

    private void checkReady() throws SQLException {
        try (Connection connection = this.getMySqlDatabase();
             Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery("SELECT 42");){
            AbstractEmbeddedMySql.checkSql(resultSet.next(), "no rows in result set");
            AbstractEmbeddedMySql.checkSql(resultSet.getInt(1) == 42, "wrong result");
            AbstractEmbeddedMySql.checkSql(!resultSet.next(), "multiple rows in result set");
        }
    }

    private static void checkSql(boolean expression, String message) throws SQLException {
        if (!expression) {
            throw new SQLException(message);
        }
    }

    private void startOutputProcessor(InputStream in) {
        this.executor.execute(() -> {
            try {
                ByteStreams.copy((InputStream)in, (OutputStream)System.out);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
    }

    private void system(List<String> command) {
        try {
            new Command(command.toArray(new String[0])).setTimeLimit(this.commandTimeout).execute((Executor)this.executor);
        }
        catch (CommandFailedException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void unpackMySql(Path target) throws IOException {
        String archiveName = String.format("/mysql-%s.tar.gz", AbstractEmbeddedMySql.getPlatform());
        URL url = AbstractEmbeddedMySql.class.getResource(archiveName);
        if (url == null) {
            throw new RuntimeException("archive not found: " + archiveName);
        }
        File archive = File.createTempFile("mysql-", null);
        try {
            try (InputStream in = url.openStream();){
                Files.copy(in, archive.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            this.system((List<String>)ImmutableList.of((Object)"tar", (Object)"-xf", (Object)archive.getPath(), (Object)"-C", (Object)target.toString()));
            if (archive.delete()) return;
        }
        catch (Throwable throwable) {
            if (archive.delete()) throw throwable;
            log.warn("Failed to delete file %s", new Object[]{archive});
            throw throwable;
        }
        log.warn("Failed to delete file %s", new Object[]{archive});
    }

    private static String getPlatform() {
        return (StandardSystemProperty.OS_NAME.value() + "-" + StandardSystemProperty.OS_ARCH.value()).replace(' ', '_');
    }
}

