/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.codec;

import com.facebook.swift.codec.ArrayField;
import com.facebook.swift.codec.ArrayFieldThriftCodec;
import com.facebook.swift.codec.BonkBean;
import com.facebook.swift.codec.BonkBuilder;
import com.facebook.swift.codec.BonkConstructor;
import com.facebook.swift.codec.BonkConstructorNameOverride;
import com.facebook.swift.codec.BonkField;
import com.facebook.swift.codec.BonkFieldThriftCodec;
import com.facebook.swift.codec.BonkMethod;
import com.facebook.swift.codec.CoercionBean;
import com.facebook.swift.codec.Fruit;
import com.facebook.swift.codec.IsSetBean;
import com.facebook.swift.codec.Letter;
import com.facebook.swift.codec.OneOfEverything;
import com.facebook.swift.codec.OneOfEverythingThriftCodec;
import com.facebook.swift.codec.ThriftCodec;
import com.facebook.swift.codec.ThriftCodecManager;
import com.facebook.swift.codec.UnionBean;
import com.facebook.swift.codec.UnionConstructor;
import com.facebook.swift.codec.UnionConstructorDuplicateTypes;
import com.facebook.swift.codec.UnionField;
import com.facebook.swift.codec.UnionFieldThriftCodec;
import com.facebook.swift.codec.generics.ConcreteDerivedFromGeneric;
import com.facebook.swift.codec.generics.ConcreteDerivedFromGenericBean;
import com.facebook.swift.codec.generics.ConcreteThriftStructDerivedFromGenericField;
import com.facebook.swift.codec.generics.GenericThriftStruct;
import com.facebook.swift.codec.generics.GenericThriftStructBean;
import com.facebook.swift.codec.generics.GenericThriftStructField;
import com.facebook.swift.codec.generics.GenericThriftStructFromBuilder;
import com.facebook.swift.codec.internal.EnumThriftCodec;
import com.facebook.swift.codec.internal.coercion.DefaultJavaCoercions;
import com.facebook.swift.codec.metadata.ThriftCatalog;
import com.facebook.swift.codec.metadata.ThriftStructMetadata;
import com.facebook.swift.codec.metadata.ThriftType;
import com.facebook.swift.codec.recursion.CoRecursive;
import com.facebook.swift.codec.recursion.CoRecursiveHelper;
import com.facebook.swift.codec.recursion.CoRecursiveTree;
import com.facebook.swift.codec.recursion.CoRecursiveTreeHelper;
import com.facebook.swift.codec.recursion.RecursiveDefaultUnion;
import com.facebook.swift.codec.recursion.RecursiveUnion;
import com.facebook.swift.codec.recursion.ViaListElementType;
import com.facebook.swift.codec.recursion.ViaMapKeyAndValueTypes;
import com.facebook.swift.codec.recursion.ViaNestedListElementType;
import com.facebook.swift.codec.recursion.WithIdlRecursiveAnnotation;
import com.facebook.swift.codec.recursion.WithSwiftRecursiveAnnotation;
import com.facebook.swift.codec.recursion.WithoutRecursiveAnnotation;
import com.google.common.base.Charsets;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TJSONProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.transport.TMemoryBuffer;
import org.apache.thrift.transport.TTransport;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public abstract class AbstractThriftCodecManagerTest {
    private ThriftCodecManager readCodecManager;
    private ThriftCodecManager writeCodecManager;

    public abstract ThriftCodecManager createReadCodecManager();

    public abstract ThriftCodecManager createWriteCodecManager();

    @BeforeMethod
    protected void setUp() throws Exception {
        this.readCodecManager = this.createReadCodecManager();
        this.writeCodecManager = this.createWriteCodecManager();
        this.readCodecManager.getCatalog().addDefaultCoercions(DefaultJavaCoercions.class);
        this.writeCodecManager.getCatalog().addDefaultCoercions(DefaultJavaCoercions.class);
    }

    @Test
    public void testUnionFieldsManual() throws Exception {
        ThriftCatalog catalog = new ThriftCatalog();
        ThriftType unionFieldType = catalog.getThriftType(UnionField.class);
        ThriftType fruitType = catalog.getThriftType(Fruit.class);
        EnumThriftCodec fruitCodec = new EnumThriftCodec(fruitType);
        UnionFieldThriftCodec unionFieldCodec = new UnionFieldThriftCodec(unionFieldType, (ThriftCodec<Fruit>)fruitCodec);
        UnionField unionField = new UnionField();
        unionField._id = 1;
        unionField.stringValue = "Hello, World";
        this.testRoundTripSerialize(unionFieldCodec, unionFieldCodec, unionField, (TProtocolFactory)new TCompactProtocol.Factory());
        unionField = new UnionField();
        unionField._id = (short)2;
        unionField.longValue = 4815162342L;
        this.testRoundTripSerialize(unionFieldCodec, unionFieldCodec, unionField, (TProtocolFactory)new TCompactProtocol.Factory());
        unionField = new UnionField();
        unionField._id = (short)3;
        unionField.fruitValue = Fruit.APPLE;
        this.testRoundTripSerialize(unionFieldCodec, unionFieldCodec, unionField, (TProtocolFactory)new TCompactProtocol.Factory());
    }

    @Test
    public void testUnionFields() throws Exception {
        UnionField unionField = new UnionField();
        unionField._id = 1;
        unionField.stringValue = "Hello, World";
        this.testRoundTripSerialize(unionField, (TProtocolFactory)new TCompactProtocol.Factory());
        unionField = new UnionField();
        unionField._id = (short)2;
        unionField.longValue = 4815162342L;
        this.testRoundTripSerialize(unionField, (TProtocolFactory)new TCompactProtocol.Factory());
        unionField = new UnionField();
        unionField._id = (short)3;
        unionField.fruitValue = Fruit.APPLE;
        this.testRoundTripSerialize(unionField, (TProtocolFactory)new TCompactProtocol.Factory());
    }

    @Test
    public void testUnionBean() throws Exception {
        UnionBean unionBean = new UnionBean();
        unionBean.setStringValue("Hello, World");
        this.testRoundTripSerialize(unionBean, (TProtocolFactory)new TCompactProtocol.Factory());
        unionBean = new UnionBean();
        unionBean.setLongValue(4815162342L);
        this.testRoundTripSerialize(unionBean, (TProtocolFactory)new TCompactProtocol.Factory());
        unionBean = new UnionBean();
        unionBean.setFruitValue(Fruit.CHERRY);
        this.testRoundTripSerialize(unionBean, (TProtocolFactory)new TCompactProtocol.Factory());
    }

    @Test
    public void testUnionConstructor() throws Exception {
        UnionConstructor unionConstructor = new UnionConstructor("Hello, World");
        this.testRoundTripSerialize(unionConstructor, (TProtocolFactory)new TCompactProtocol.Factory());
        unionConstructor = new UnionConstructor(4815162342L);
        this.testRoundTripSerialize(unionConstructor, (TProtocolFactory)new TCompactProtocol.Factory());
        unionConstructor = new UnionConstructor(Fruit.APPLE);
        this.testRoundTripSerialize(unionConstructor, (TProtocolFactory)new TCompactProtocol.Factory());
        unionConstructor = new UnionConstructor();
        this.testRoundTripSerialize(unionConstructor, (TProtocolFactory)new TCompactProtocol.Factory());
    }

    @Test
    public void testUnionConstructorDuplicateTypes() throws Exception {
        UnionConstructorDuplicateTypes unionConstructor = new UnionConstructorDuplicateTypes();
        unionConstructor.setFirstIntValue(1);
        this.testRoundTripSerialize(unionConstructor, (TProtocolFactory)new TCompactProtocol.Factory());
        unionConstructor = new UnionConstructorDuplicateTypes();
        unionConstructor.setSecondIntValue(2);
        this.testRoundTripSerialize(unionConstructor, (TProtocolFactory)new TCompactProtocol.Factory());
    }

    @Test
    public void testStructFieldsManual() throws Exception {
        ThriftCatalog catalog = new ThriftCatalog();
        ThriftType bonkFieldType = catalog.getThriftType(BonkField.class);
        BonkFieldThriftCodec bonkFieldCodec = new BonkFieldThriftCodec(bonkFieldType);
        BonkField bonkField = new BonkField("message", 42);
        this.testRoundTripSerialize(bonkFieldCodec, bonkFieldCodec, bonkField, (TProtocolFactory)new TCompactProtocol.Factory());
    }

    @Test
    public void testStructFields() throws Exception {
        BonkField bonkField = new BonkField("message", 42);
        this.testRoundTripSerialize(bonkField, (TProtocolFactory)new TCompactProtocol.Factory());
    }

    @Test
    public void testStructBean() throws Exception {
        BonkBean bonkBean = new BonkBean("message", 42);
        this.testRoundTripSerialize(bonkBean, (TProtocolFactory)new TCompactProtocol.Factory());
    }

    @Test
    public void testStructMethod() throws Exception {
        BonkMethod bonkMethod = new BonkMethod("message", 42);
        this.testRoundTripSerialize(bonkMethod, (TProtocolFactory)new TCompactProtocol.Factory());
    }

    @Test
    public void testStructConstructor() throws Exception {
        BonkConstructor bonkConstructor = new BonkConstructor("message", 42);
        this.testRoundTripSerialize(bonkConstructor, (TProtocolFactory)new TCompactProtocol.Factory());
    }

    @Test
    public void testMatchByJavaNameWithThriftNameOverride() throws Exception {
        ThriftCatalog catalog = this.readCodecManager.getCatalog();
        ThriftType thriftType = catalog.getThriftType(BonkConstructorNameOverride.class);
        ThriftStructMetadata structMetadata = thriftType.getStructMetadata();
        Assert.assertEquals((String)structMetadata.getField(1).getName(), (String)"myMessage");
        Assert.assertEquals((String)structMetadata.getField(2).getName(), (String)"myType");
        BonkConstructorNameOverride bonk = new BonkConstructorNameOverride("message", 42);
        this.testRoundTripSerialize(bonk, (TProtocolFactory)new TCompactProtocol.Factory());
    }

    @Test
    public void testBuilder() throws Exception {
        BonkBuilder bonkBuilder = new BonkBuilder("message", 42);
        this.testRoundTripSerialize(bonkBuilder, (TProtocolFactory)new TCompactProtocol.Factory());
    }

    @Test
    public void testArraysManual() throws Exception {
        ThriftCatalog catalog = new ThriftCatalog();
        ThriftType thriftType = catalog.getThriftType(ArrayField.class);
        ArrayFieldThriftCodec arrayFieldCodec = new ArrayFieldThriftCodec(thriftType);
        ArrayField arrayField = new ArrayField(new boolean[]{true, false, false, true}, new short[]{0, 1, 2, 3}, new int[]{10, 11, 12, 13}, new long[]{20L, Long.MAX_VALUE, Long.MIN_VALUE}, new double[]{3.0, Double.MAX_VALUE, Double.MIN_VALUE}, "hello".getBytes(Charsets.UTF_8));
        this.testRoundTripSerialize(arrayFieldCodec, arrayFieldCodec, arrayField, (TProtocolFactory)new TCompactProtocol.Factory());
    }

    @Test
    public void testArrays() throws Exception {
        ArrayField arrayField = new ArrayField(new boolean[]{true, false, false, true}, new short[]{0, 1, 2, 3}, new int[]{10, 11, 12, 13}, new long[]{20L, Long.MAX_VALUE, Long.MIN_VALUE}, new double[]{3.0, Double.MAX_VALUE, Double.MIN_VALUE}, "hello".getBytes(Charsets.UTF_8), (Map<Short, boolean[]>)ImmutableMap.of((Object)1, (Object)new boolean[]{false, false}, (Object)2, (Object)new boolean[]{true, true}), (Map<Short, short[]>)ImmutableMap.of((Object)1, (Object)new short[]{10, 11, 12, 13}, (Object)2, (Object)new short[]{15, 16, 17, 18}), (Map<Short, int[]>)ImmutableMap.of((Object)1, (Object)new int[]{20, 21, 22, 23}, (Object)2, (Object)new int[]{25, 26, 27, 28}), (Map<Short, long[]>)ImmutableMap.of((Object)1, (Object)new long[]{30L, 31L, 32L, 33L}, (Object)2, (Object)new long[]{35L, 36L, 37L, 38L}), (Map<Short, double[]>)ImmutableMap.of((Object)1, (Object)new double[]{40.0, 41.0, 42.0, 43.0}, (Object)2, (Object)new double[]{45.0, 46.0, 47.0, 48.0}));
        this.testRoundTripSerialize(arrayField, (TProtocolFactory)new TCompactProtocol.Factory());
        this.testRoundTripSerialize(arrayField, (TProtocolFactory)new TJSONProtocol.Factory());
    }

    @Test
    public void testOneOfEverythingField() throws Exception {
        OneOfEverything one = this.createOneOfEverything();
        this.testRoundTripSerialize(one, (TProtocolFactory)new TCompactProtocol.Factory());
        this.testRoundTripSerialize(one, (TProtocolFactory)new TJSONProtocol.Factory());
    }

    @Test
    public void testOneOfEverythingFieldManual() throws Exception {
        ThriftCatalog catalog = this.readCodecManager.getCatalog();
        ThriftType bonkFieldType = catalog.getThriftType(BonkField.class);
        ThriftType unionFieldType = catalog.getThriftType(UnionField.class);
        ThriftType fruitType = catalog.getThriftType(Fruit.class);
        EnumThriftCodec fruitCodec = new EnumThriftCodec(fruitType);
        BonkFieldThriftCodec bonkFieldCodec = new BonkFieldThriftCodec(bonkFieldType);
        UnionFieldThriftCodec unionFieldCodec = new UnionFieldThriftCodec(unionFieldType, (ThriftCodec<Fruit>)fruitCodec);
        ThriftType oneOfEverythingType = catalog.getThriftType(OneOfEverything.class);
        OneOfEverythingThriftCodec codec = new OneOfEverythingThriftCodec(oneOfEverythingType, bonkFieldCodec, unionFieldCodec, (ThriftCodec<Fruit>)fruitCodec);
        OneOfEverything one = new OneOfEverything();
        one.aBoolean = true;
        one.aByte = (byte)11;
        one.aShort = (short)22;
        one.aInt = 33;
        one.aLong = 44L;
        one.aDouble = 55.0;
        one.aString = "message";
        one.aEnum = Fruit.CHERRY;
        one.aStruct = new BonkField("struct", 66);
        this.testRoundTripSerialize(codec, codec, one, (TProtocolFactory)new TCompactProtocol.Factory());
        this.testRoundTripSerialize(codec, codec, one, (TProtocolFactory)new TJSONProtocol.Factory());
    }

    @Test
    public void testOneOfEverythingFieldEmpty() throws Exception {
        OneOfEverything one = new OneOfEverything();
        this.testRoundTripSerialize(one, (TProtocolFactory)new TCompactProtocol.Factory());
        this.testRoundTripSerialize(one, (TProtocolFactory)new TJSONProtocol.Factory());
    }

    @Test
    public void testDefaultCoercion() throws Exception {
        CoercionBean coercion = new CoercionBean(true, (byte)1, (short)2, 3, 4L, Float.valueOf(5.5f), 6.6, 7.7f, (List<Float>)ImmutableList.of((Object)Float.valueOf(1.1f), (Object)Float.valueOf(2.2f), (Object)Float.valueOf(3.3f)));
        this.testRoundTripSerialize(coercion, (TProtocolFactory)new TCompactProtocol.Factory());
    }

    @Test
    public void testIsSetBean() throws Exception {
        IsSetBean full = IsSetBean.createFull();
        this.assertAllFieldsSet(full, false);
        full.field = ByteBuffer.wrap("full".getBytes(Charsets.UTF_8));
        full = this.testRoundTripSerialize(full, (TProtocolFactory)new TCompactProtocol.Factory());
        this.assertAllFieldsSet(full, true);
        IsSetBean empty = IsSetBean.createEmpty();
        this.assertAllFieldsSet(empty, false);
        empty = this.testRoundTripSerialize(empty, (TProtocolFactory)new TCompactProtocol.Factory());
        this.assertAllFieldsSet(empty, false);
    }

    @Test
    public void testBeanGeneric() throws Exception {
        GenericThriftStructBean<String> bean = new GenericThriftStructBean<String>();
        bean.setGenericProperty("genericValue");
        this.testRoundTripSerialize(new TypeToken<GenericThriftStructBean<String>>(){}, bean, (TProtocolFactory)new TCompactProtocol.Factory());
    }

    @Test
    public void testBeanDerivedFromGeneric() throws Exception {
        ConcreteDerivedFromGenericBean bean = new ConcreteDerivedFromGenericBean();
        bean.setGenericProperty("generic");
        bean.setConcreteField("concrete");
        this.testRoundTripSerialize(bean, (TProtocolFactory)new TCompactProtocol.Factory());
    }

    @Test
    public void testImmutableGeneric() throws Exception {
        GenericThriftStruct<Double> immutable = new GenericThriftStruct<Double>(Math.PI);
        this.testRoundTripSerialize(new TypeToken<GenericThriftStruct<Double>>(){}, immutable, (TProtocolFactory)new TCompactProtocol.Factory());
    }

    @Test
    public void testImmutableDerivedFromGeneric() throws Exception {
        ConcreteDerivedFromGeneric immutable = new ConcreteDerivedFromGeneric(Math.E, Math.PI);
        this.testRoundTripSerialize(immutable, (TProtocolFactory)new TCompactProtocol.Factory());
    }

    @Test
    public void testGenericFromBuilder() throws Exception {
        GenericThriftStructFromBuilder<Integer, Double> builderObject = new GenericThriftStructFromBuilder.Builder().setFirstGenericProperty(12345).setSecondGenericProperty(1.2345).build();
        this.testRoundTripSerialize(new TypeToken<GenericThriftStructFromBuilder<Integer, Double>>(){}, builderObject, (TProtocolFactory)new TCompactProtocol.Factory());
    }

    @Test
    public void testFieldGeneric() throws Exception {
        GenericThriftStructField fieldObject = new GenericThriftStructField();
        fieldObject.genericField = 5757;
        this.testRoundTripSerialize(new TypeToken<GenericThriftStructField<Integer>>(){}, fieldObject, (TProtocolFactory)new TCompactProtocol.Factory());
    }

    @Test
    public void testFieldDerivedFromGeneric() throws Exception {
        ConcreteThriftStructDerivedFromGenericField fieldObject = new ConcreteThriftStructDerivedFromGenericField();
        fieldObject.genericField = "genericValue";
        fieldObject.concreteField = "concreteValue";
        this.testRoundTripSerialize(fieldObject, (TProtocolFactory)new TCompactProtocol.Factory());
    }

    @Test
    public void testRecursiveStructWithSwiftAnnotation() throws Exception {
        WithSwiftRecursiveAnnotation recursiveObject = new WithSwiftRecursiveAnnotation();
        recursiveObject.data = "parent";
        recursiveObject.child = new WithSwiftRecursiveAnnotation();
        recursiveObject.child.data = "child";
        recursiveObject.child.child = new WithSwiftRecursiveAnnotation();
        recursiveObject.child.child.data = "grandchild";
        this.testRoundTripSerialize(recursiveObject, (TProtocolFactory)new TCompactProtocol.Factory());
    }

    @Test
    public void testRecursiveStructWithIdlAnnotation() throws Exception {
        WithIdlRecursiveAnnotation recursiveObject = new WithIdlRecursiveAnnotation();
        recursiveObject.data = "parent";
        recursiveObject.child = new WithIdlRecursiveAnnotation();
        recursiveObject.child.data = "child";
        recursiveObject.child.child = new WithIdlRecursiveAnnotation();
        recursiveObject.child.child.data = "grandchild";
        this.testRoundTripSerialize(recursiveObject, (TProtocolFactory)new TCompactProtocol.Factory());
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testRecursiveStructWithoutRecursiveAnnotation() throws Exception {
        WithoutRecursiveAnnotation recursiveObject = new WithoutRecursiveAnnotation();
        recursiveObject.data = "parent";
        recursiveObject.child = new WithoutRecursiveAnnotation();
        recursiveObject.child.data = "child";
        recursiveObject.child.child = new WithoutRecursiveAnnotation();
        recursiveObject.child.child.data = "grandchild";
        this.testRoundTripSerialize(recursiveObject, (TProtocolFactory)new TCompactProtocol.Factory());
    }

    @Test
    public void testStructWithRecursionViaListElementTypes() throws Exception {
        ViaListElementType recursiveObject = new ViaListElementType();
        recursiveObject.data = "parent";
        recursiveObject.children = Lists.newArrayList((Object[])new ViaListElementType[]{new ViaListElementType()});
        recursiveObject.children.get((int)0).data = "child";
        recursiveObject.children.get((int)0).children = Lists.newArrayList((Object[])new ViaListElementType[]{new ViaListElementType()});
        recursiveObject.children.get((int)0).children.get((int)0).data = "grandchild";
        this.testRoundTripSerialize(recursiveObject, (TProtocolFactory)new TCompactProtocol.Factory());
    }

    @Test
    public void testStructWithRecursionViaNestedListElementTypes() throws Exception {
        ViaNestedListElementType recursiveObject = new ViaNestedListElementType();
        recursiveObject.data = "parent";
        recursiveObject.children = ImmutableList.of((Object)Lists.newArrayList());
        ViaNestedListElementType child = new ViaNestedListElementType();
        child.data = "child";
        recursiveObject.children.get(0).add(child);
        child.children = ImmutableList.of((Object)Lists.newArrayList());
        ViaNestedListElementType grandChild = new ViaNestedListElementType();
        grandChild.data = "grandchild";
        child.children.get(0).add(grandChild);
        this.testRoundTripSerialize(recursiveObject, (TProtocolFactory)new TCompactProtocol.Factory());
    }

    @Test
    void testStructWithRecursionViaMapKeyAndValueTypes() throws Exception {
        ViaMapKeyAndValueTypes recursiveObject = new ViaMapKeyAndValueTypes();
        recursiveObject.data = "parent";
        ViaMapKeyAndValueTypes keyChild = new ViaMapKeyAndValueTypes();
        keyChild.data = "keychild";
        ViaMapKeyAndValueTypes valueChild = new ViaMapKeyAndValueTypes();
        valueChild.data = "valuechild";
        recursiveObject.children = ImmutableMap.of((Object)keyChild, (Object)valueChild);
        this.testRoundTripSerialize(recursiveObject, (TProtocolFactory)new TCompactProtocol.Factory());
    }

    @Test
    void testCoRecursive() throws Exception {
        CoRecursive recursiveObject = new CoRecursive();
        recursiveObject.data = "parent";
        recursiveObject.child = new CoRecursiveHelper();
        recursiveObject.child.data = "child";
        recursiveObject.child.child = new CoRecursive();
        recursiveObject.child.child.data = "grandchild";
        this.testRoundTripSerialize(recursiveObject, (TProtocolFactory)new TCompactProtocol.Factory());
    }

    @Test
    void testCoRecursiveStartingAtHelper() throws Exception {
        CoRecursiveHelper recursiveObject = new CoRecursiveHelper();
        recursiveObject.data = "parent";
        recursiveObject.child = new CoRecursive();
        recursiveObject.child.data = "child";
        recursiveObject.child.child = new CoRecursiveHelper();
        recursiveObject.child.child.data = "grandchild";
        this.testRoundTripSerialize(recursiveObject, (TProtocolFactory)new TCompactProtocol.Factory());
    }

    @Test
    void testCoRecursiveTree() throws Exception {
        Object recursiveLeaf = new CoRecursiveTree();
        ((CoRecursiveTree)recursiveLeaf).data = "grandchild";
        Object recursiveNode = new CoRecursiveTreeHelper();
        ((CoRecursiveTreeHelper)recursiveNode).data = "child";
        ((CoRecursiveTreeHelper)recursiveNode).child = recursiveLeaf;
        Object recursiveRoot = new CoRecursiveTree();
        ((CoRecursiveTree)recursiveRoot).data = "root";
        ((CoRecursiveTree)recursiveRoot).children = Lists.newArrayList((Object[])new CoRecursiveTreeHelper[]{recursiveNode});
        this.testRoundTripSerialize(recursiveRoot, (TProtocolFactory)new TCompactProtocol.Factory());
        recursiveLeaf = new CoRecursiveTreeHelper();
        ((CoRecursiveTreeHelper)recursiveLeaf).data = "grandchild";
        recursiveNode = new CoRecursiveTree();
        ((CoRecursiveTree)recursiveNode).data = "child";
        ((CoRecursiveTree)recursiveNode).children = Lists.newArrayList((Object[])new CoRecursiveTreeHelper[]{recursiveLeaf});
        recursiveRoot = new CoRecursiveTreeHelper();
        ((CoRecursiveTreeHelper)recursiveRoot).data = "root";
        ((CoRecursiveTreeHelper)recursiveRoot).child = recursiveNode;
        this.testRoundTripSerialize(recursiveRoot, (TProtocolFactory)new TCompactProtocol.Factory());
    }

    @Test
    public void testRecursiveUnion() throws Exception {
        RecursiveUnion recursiveUnion = new RecursiveUnion(new RecursiveUnion("child"));
        this.testRoundTripSerialize(recursiveUnion, (TProtocolFactory)new TCompactProtocol.Factory());
    }

    @Test
    public void testRecursiveDefaultUnion() throws Exception {
        RecursiveDefaultUnion recursiveDefaultUnion = new RecursiveDefaultUnion(new RecursiveDefaultUnion("child"));
        this.testRoundTripSerialize(recursiveDefaultUnion, (TProtocolFactory)new TCompactProtocol.Factory());
    }

    private void assertAllFieldsSet(IsSetBean isSetBean, boolean expected) {
        Assert.assertEquals((boolean)isSetBean.isBooleanSet(), (boolean)expected);
        Assert.assertEquals((boolean)isSetBean.isByteSet(), (boolean)expected);
        Assert.assertEquals((boolean)isSetBean.isShortSet(), (boolean)expected);
        Assert.assertEquals((boolean)isSetBean.isIntegerSet(), (boolean)expected);
        Assert.assertEquals((boolean)isSetBean.isLongSet(), (boolean)expected);
        Assert.assertEquals((boolean)isSetBean.isDoubleSet(), (boolean)expected);
        Assert.assertEquals((boolean)isSetBean.isStringSet(), (boolean)expected);
        Assert.assertEquals((boolean)isSetBean.isStructSet(), (boolean)expected);
        Assert.assertEquals((boolean)isSetBean.isSetSet(), (boolean)expected);
        Assert.assertEquals((boolean)isSetBean.isListSet(), (boolean)expected);
        Assert.assertEquals((boolean)isSetBean.isMapSet(), (boolean)expected);
        Assert.assertEquals((!ByteBuffer.wrap("empty".getBytes(Charsets.UTF_8)).equals(isSetBean.field) ? 1 : 0) != 0, (boolean)expected);
    }

    private <T> T testRoundTripSerialize(T value, TProtocolFactory protocolFactory) throws Exception {
        ThriftCodec readCodec = this.readCodecManager.getCodec(value.getClass());
        ThriftCodec writeCodec = this.writeCodecManager.getCodec(value.getClass());
        return this.testRoundTripSerialize(readCodec, writeCodec, value, protocolFactory);
    }

    private <T> T testRoundTripSerialize(TypeToken<T> typeToken, T value, TProtocolFactory protocolFactory) throws Exception {
        ThriftCodec readCodec = this.readCodecManager.getCodec(typeToken.getType());
        ThriftCodec writeCodec = this.writeCodecManager.getCodec(typeToken.getType());
        return this.testRoundTripSerialize(readCodec, writeCodec, typeToken.getType(), value, protocolFactory);
    }

    private <T> T testRoundTripSerialize(ThriftCodec<T> readCodec, ThriftCodec<T> writeCodec, T structInstance, TProtocolFactory protocolFactory) throws Exception {
        Class<?> structClass = structInstance.getClass();
        return this.testRoundTripSerialize(readCodec, writeCodec, structClass, structInstance, protocolFactory);
    }

    private <T> T testRoundTripSerialize(ThriftCodec<T> readCodec, ThriftCodec<T> writeCodec, Type structType, T structInstance, TProtocolFactory protocolFactory) throws Exception {
        ThriftCatalog readCatalog = this.readCodecManager.getCatalog();
        ThriftStructMetadata readMetadata = readCatalog.getThriftStructMetadata(structType);
        Assert.assertNotNull((Object)readMetadata);
        ThriftCatalog writeCatalog = this.writeCodecManager.getCatalog();
        ThriftStructMetadata writeMetadata = writeCatalog.getThriftStructMetadata(structType);
        Assert.assertNotNull((Object)writeMetadata);
        TMemoryBuffer transport = new TMemoryBuffer(10240);
        TProtocol protocol = protocolFactory.getProtocol((TTransport)transport);
        writeCodec.write(structInstance, protocol);
        Object copy = readCodec.read(protocol);
        Assert.assertNotNull((Object)copy);
        Assert.assertEquals((Object)copy, structInstance);
        return (T)copy;
    }

    private OneOfEverything createOneOfEverything() {
        OneOfEverything one = new OneOfEverything();
        one.aBoolean = true;
        one.aByte = (byte)11;
        one.aShort = (short)22;
        one.aInt = 33;
        one.aLong = 44L;
        one.aDouble = 55.0;
        one.aString = "message";
        one.aStruct = new BonkField("struct", 66);
        one.aEnum = Fruit.CHERRY;
        one.aCustomEnum = Letter.C;
        one.aBooleanSet = ImmutableSet.of((Object)true, (Object)false);
        one.aByteSet = ImmutableSet.of((Object)-1, (Object)0, (Object)1);
        one.aShortSet = ImmutableSet.of((Object)-1, (Object)0, (Object)1);
        one.aIntegerSet = ImmutableSet.of((Object)-1, (Object)0, (Object)1);
        one.aLongSet = ImmutableSet.of((Object)-1L, (Object)0L, (Object)1L);
        one.aDoubleSet = ImmutableSet.of((Object)-42.1, (Object)0.0, (Object)42.1);
        one.aStringSet = ImmutableSet.of((Object)"a", (Object)"string", (Object)"set");
        one.aStructSet = ImmutableSet.of((Object)new BonkField("message", 42), (Object)new BonkField("other", 11));
        one.aEnumSet = ImmutableSet.copyOf((Object[])Fruit.values());
        one.aCustomEnumSet = ImmutableSet.copyOf((Object[])Letter.values());
        one.aBooleanList = ImmutableList.of((Object)true, (Object)false);
        one.aByteList = ImmutableList.of((Object)-1, (Object)0, (Object)1);
        one.aShortList = ImmutableList.of((Object)-1, (Object)0, (Object)1);
        one.aIntegerList = ImmutableList.of((Object)-1, (Object)0, (Object)1);
        one.aLongList = ImmutableList.of((Object)-1L, (Object)0L, (Object)1L);
        one.aDoubleList = ImmutableList.of((Object)-42.1, (Object)0.0, (Object)42.1);
        one.aStringList = ImmutableList.of((Object)"a", (Object)"string", (Object)"list");
        one.aStructList = ImmutableList.of((Object)new BonkField("message", 42), (Object)new BonkField("other", 11));
        one.aEnumList = ImmutableList.copyOf((Object[])Fruit.values());
        one.aCustomEnumList = ImmutableList.copyOf((Object[])Letter.values());
        one.aBooleanValueMap = ImmutableMap.of((Object)"TRUE", (Object)true, (Object)"FALSE", (Object)false);
        one.aByteValueMap = ImmutableMap.of((Object)"-1", (Object)-1, (Object)"0", (Object)0, (Object)"1", (Object)1);
        one.aShortValueMap = ImmutableMap.of((Object)"-1", (Object)-1, (Object)"0", (Object)0, (Object)"1", (Object)1);
        one.aIntegerValueMap = ImmutableMap.of((Object)"-1", (Object)-1, (Object)"0", (Object)0, (Object)"1", (Object)1);
        one.aLongValueMap = ImmutableMap.of((Object)"-1", (Object)-1L, (Object)"0", (Object)0L, (Object)"1", (Object)1L);
        one.aDoubleValueMap = ImmutableMap.of((Object)"neg", (Object)-42.1, (Object)"0", (Object)0.0, (Object)"pos", (Object)42.1);
        one.aStringValueMap = ImmutableMap.of((Object)"1", (Object)"a", (Object)"2", (Object)"string", (Object)"3", (Object)"map");
        one.aStructValueMap = ImmutableMap.of((Object)"main", (Object)new BonkField("message", 42), (Object)"other", (Object)new BonkField("other", 11));
        one.aEnumValueMap = ImmutableMap.of((Object)"apple", (Object)((Object)Fruit.APPLE), (Object)"banana", (Object)((Object)Fruit.BANANA));
        one.aCustomEnumValueMap = ImmutableMap.of((Object)"a", (Object)((Object)Letter.A), (Object)"b", (Object)((Object)Letter.B));
        one.aBooleanKeyMap = ImmutableMap.copyOf((Map)HashBiMap.create(one.aBooleanValueMap).inverse());
        one.aByteKeyMap = ImmutableMap.copyOf((Map)HashBiMap.create(one.aByteValueMap).inverse());
        one.aShortKeyMap = ImmutableMap.copyOf((Map)HashBiMap.create(one.aShortValueMap).inverse());
        one.aIntegerKeyMap = ImmutableMap.copyOf((Map)HashBiMap.create(one.aIntegerValueMap).inverse());
        one.aLongKeyMap = ImmutableMap.copyOf((Map)HashBiMap.create(one.aLongValueMap).inverse());
        one.aDoubleKeyMap = ImmutableMap.copyOf((Map)HashBiMap.create(one.aDoubleValueMap).inverse());
        one.aStringKeyMap = ImmutableMap.copyOf((Map)HashBiMap.create(one.aStringValueMap).inverse());
        one.aStructKeyMap = ImmutableMap.copyOf((Map)HashBiMap.create(one.aStructValueMap).inverse());
        one.aEnumKeyMap = ImmutableMap.of((Object)((Object)Fruit.APPLE), (Object)"apple", (Object)((Object)Fruit.BANANA), (Object)"banana");
        one.aCustomEnumKeyMap = ImmutableMap.of((Object)((Object)Letter.A), (Object)"a", (Object)((Object)Letter.B), (Object)"b");
        one.aSetOfListsOfMaps = ImmutableSet.of((Object)ImmutableList.of((Object)ImmutableMap.of((Object)"1: main", (Object)new BonkField("message", 42), (Object)"1: other", (Object)new BonkField("other", 11)), (Object)ImmutableMap.of((Object)"1: main", (Object)new BonkField("message", 42), (Object)"1: other", (Object)new BonkField("other", 11))), (Object)ImmutableList.of((Object)ImmutableMap.of((Object)"2: main", (Object)new BonkField("message", 42), (Object)"2: other", (Object)new BonkField("other", 11)), (Object)ImmutableMap.of((Object)"2: main", (Object)new BonkField("message", 42), (Object)"2: other", (Object)new BonkField("other", 11))));
        one.aMapOfListToSet = ImmutableMap.of((Object)ImmutableList.of((Object)"a", (Object)"b"), (Object)ImmutableSet.of((Object)new BonkField("1: message", 42), (Object)new BonkField("1: other", 11)), (Object)ImmutableList.of((Object)"c", (Object)"d"), (Object)ImmutableSet.of((Object)new BonkField("2: message", 42), (Object)new BonkField("2: other", 11)));
        one.aUnion = new UnionField("Hello, World");
        one.aUnionSet = ImmutableSet.of((Object)new UnionField("Hello, World"), (Object)new UnionField(123456L), (Object)new UnionField(Fruit.CHERRY));
        one.aUnionList = ImmutableList.of((Object)new UnionField("Hello, World"), (Object)new UnionField(123456L), (Object)new UnionField(Fruit.CHERRY));
        one.aUnionKeyMap = ImmutableMap.of((Object)new UnionField("Hello, World"), (Object)"Eins", (Object)new UnionField(123456L), (Object)"Zwei", (Object)new UnionField(Fruit.CHERRY), (Object)"Drei");
        one.aUnionValueMap = ImmutableMap.of((Object)"Eins", (Object)new UnionField("Hello, World"), (Object)"Zwei", (Object)new UnionField(123456L), (Object)"Drei", (Object)new UnionField(Fruit.CHERRY));
        return one;
    }
}

