/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.codec;

import com.facebook.swift.codec.BasicThriftStruct;
import com.facebook.swift.codec.BonkField;
import com.facebook.swift.codec.BonkFieldThriftCodec;
import com.facebook.swift.codec.Fruit;
import com.facebook.swift.codec.Letter;
import com.facebook.swift.codec.ThriftCodec;
import com.facebook.swift.codec.ThriftCodecManager;
import com.facebook.swift.codec.UnionField;
import com.facebook.swift.codec.UnionFieldThriftCodec;
import com.facebook.swift.codec.internal.EnumThriftCodec;
import com.facebook.swift.codec.internal.ThriftCodecFactory;
import com.facebook.swift.codec.internal.coercion.DefaultJavaCoercions;
import com.facebook.swift.codec.metadata.ThriftCatalog;
import com.facebook.swift.codec.metadata.ThriftEnumMetadata;
import com.facebook.swift.codec.metadata.ThriftEnumMetadataBuilder;
import com.facebook.swift.codec.metadata.ThriftStructMetadata;
import com.facebook.swift.codec.metadata.ThriftType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.security.SecureRandom;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TJSONProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.transport.TMemoryBuffer;
import org.apache.thrift.transport.TTransport;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestThriftCodecManager {
    public static final String UTF8_TEST_STRING = "A\u00ea\u00f1\u00fcC";
    private ThriftCodecManager codecManager;

    @BeforeMethod
    protected void setUp() throws Exception {
        this.codecManager = new ThriftCodecManager(new ThriftCodecFactory(){

            public ThriftCodec<?> generateThriftTypeCodec(ThriftCodecManager codecManager, ThriftStructMetadata metadata) {
                throw new UnsupportedOperationException();
            }
        }, new ThriftCodec[0]);
        ThriftCatalog catalog = this.codecManager.getCatalog();
        catalog.addDefaultCoercions(DefaultJavaCoercions.class);
        ThriftType fruitType = catalog.getThriftType(Fruit.class);
        this.codecManager.addCodec((ThriftCodec)new EnumThriftCodec(fruitType));
    }

    @Test
    public void testBasicTypes() throws Exception {
        this.testRoundTripSerialize(true);
        this.testRoundTripSerialize(false);
        this.testRoundTripSerialize((byte)100);
        this.testRoundTripSerialize((short)1000);
        this.testRoundTripSerialize(10000);
        this.testRoundTripSerialize(10000000L);
        this.testRoundTripSerialize(42.42);
        this.testRoundTripSerialize("some string");
        this.testRoundTripSerialize(UTF8_TEST_STRING);
        this.testRoundTripSerialize("some string", (TProtocolFactory)new TJSONProtocol.Factory());
        this.testRoundTripSerialize(UTF8_TEST_STRING, (TProtocolFactory)new TJSONProtocol.Factory());
    }

    @Test
    public void testBasicThriftTypes() throws Exception {
        this.testRoundTripSerialize(ThriftType.BOOL, true);
        this.testRoundTripSerialize(ThriftType.BOOL, false);
        this.testRoundTripSerialize(ThriftType.BYTE, (byte)100);
        this.testRoundTripSerialize(ThriftType.I16, (short)1000);
        this.testRoundTripSerialize(ThriftType.I32, 10000);
        this.testRoundTripSerialize(ThriftType.I64, 10000000L);
        this.testRoundTripSerialize(ThriftType.DOUBLE, 42.42);
        this.testRoundTripSerialize(ThriftType.STRING, "some string");
        this.testRoundTripSerialize(ThriftType.STRING, UTF8_TEST_STRING);
        this.testRoundTripSerialize(ThriftType.STRING, "some string", (TProtocolFactory)new TJSONProtocol.Factory());
        this.testRoundTripSerialize(ThriftType.STRING, UTF8_TEST_STRING, (TProtocolFactory)new TJSONProtocol.Factory());
    }

    @Test
    public void testEnum() throws Exception {
        ThriftEnumMetadata fruitEnumMetadata = new ThriftEnumMetadataBuilder(Fruit.class).build();
        ThriftEnumMetadata letterEnumMetadata = new ThriftEnumMetadataBuilder(Letter.class).build();
        this.testRoundTripSerialize(Fruit.CHERRY);
        this.testRoundTripSerialize(Letter.C);
        this.testRoundTripSerialize(ThriftType.enumType((ThriftEnumMetadata)fruitEnumMetadata), Fruit.CHERRY);
        this.testRoundTripSerialize(ThriftType.enumType((ThriftEnumMetadata)letterEnumMetadata), Letter.C);
        this.testRoundTripSerialize(ThriftType.list((ThriftType)ThriftType.enumType((ThriftEnumMetadata)fruitEnumMetadata)), ImmutableList.copyOf((Object[])Fruit.values()));
        this.testRoundTripSerialize(ThriftType.list((ThriftType)ThriftType.enumType((ThriftEnumMetadata)letterEnumMetadata)), ImmutableList.copyOf((Object[])Letter.values()));
    }

    @Test
    public void testCollectionThriftTypes() throws Exception {
        this.testRoundTripSerialize(ThriftType.set((ThriftType)ThriftType.STRING), ImmutableSet.of((Object)"some string", (Object)"another string"));
        this.testRoundTripSerialize(ThriftType.list((ThriftType)ThriftType.STRING), ImmutableList.of((Object)"some string", (Object)"another string"));
        this.testRoundTripSerialize(ThriftType.map((ThriftType)ThriftType.STRING, (ThriftType)ThriftType.STRING), ImmutableMap.of((Object)"1", (Object)"one", (Object)"2", (Object)"two"));
    }

    @Test
    public void testCoercedCollection() throws Exception {
        this.testRoundTripSerialize(ThriftType.set((ThriftType)ThriftType.I32.coerceTo(Integer.class)), ImmutableSet.of((Object)1, (Object)2, (Object)3));
        this.testRoundTripSerialize(ThriftType.list((ThriftType)ThriftType.I32.coerceTo(Integer.class)), ImmutableList.of((Object)4, (Object)5, (Object)6));
        this.testRoundTripSerialize(ThriftType.map((ThriftType)ThriftType.I32.coerceTo(Integer.class), (ThriftType)ThriftType.I32.coerceTo(Integer.class)), ImmutableMap.of((Object)1, (Object)2, (Object)2, (Object)4, (Object)3, (Object)9));
    }

    @Test
    public void testAddStructCodec() throws Exception {
        BonkField bonk = new BonkField("message", 42);
        try {
            this.testRoundTripSerialize(bonk);
            Assert.fail((String)"Expected exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        ThriftType type = this.codecManager.getCatalog().getThriftType(BonkField.class);
        this.codecManager.addCodec((ThriftCodec)new BonkFieldThriftCodec(type));
        this.testRoundTripSerialize(bonk);
        this.testRoundTripSerialize(bonk, (TProtocolFactory)new TJSONProtocol.Factory());
    }

    @Test
    public void testAddUnionCodec() throws Exception {
        UnionField union = new UnionField();
        union._id = 1;
        union.stringValue = "Hello, World";
        try {
            this.testRoundTripSerialize(union);
            Assert.fail((String)"Expected exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        ThriftType type = this.codecManager.getCatalog().getThriftType(UnionField.class);
        this.codecManager.addCodec((ThriftCodec)new UnionFieldThriftCodec(type, (ThriftCodec<Fruit>)this.codecManager.getCodec(Fruit.class)));
        this.testRoundTripSerialize(union);
        union = new UnionField();
        union._id = (short)2;
        union.longValue = 4815162342L;
        this.testRoundTripSerialize(union);
        union = new UnionField();
        union._id = (short)3;
        union.fruitValue = Fruit.BANANA;
        this.testRoundTripSerialize(union);
        this.testRoundTripSerialize(union, (TProtocolFactory)new TJSONProtocol.Factory());
    }

    private <T> void testRoundTripSerialize(T value) throws Exception {
        this.testRoundTripSerialize(value, (TProtocolFactory)new TCompactProtocol.Factory());
    }

    private <T> void testRoundTripSerialize(T value, TProtocolFactory protocolFactory) throws Exception {
        this.testRoundTripSerialize(this.codecManager.getCatalog().getThriftType(value.getClass()), value, (TProtocolFactory)new TCompactProtocol.Factory());
    }

    private <T> void testRoundTripSerialize(ThriftType type, T value) throws Exception {
        this.testRoundTripSerialize(type, value, (TProtocolFactory)new TCompactProtocol.Factory());
    }

    private <T> void testRoundTripSerialize(ThriftType type, T value, TProtocolFactory protocolFactory) throws Exception {
        TMemoryBuffer transport = new TMemoryBuffer(10240);
        TProtocol protocol = protocolFactory.getProtocol((TTransport)transport);
        this.codecManager.write(type, value, protocol);
        Object copy = this.codecManager.read(type, protocol);
        Assert.assertNotNull((Object)copy);
        Assert.assertEquals((Object)copy, value);
    }

    public void testWriteToBuffer() {
        SecureRandom random = new SecureRandom();
        BasicThriftStruct tstruct = new BasicThriftStruct(new BigInteger(130, random).toString(), new BigInteger(130, random).toString(), new BigInteger(130, random).toString(), 1337L);
        TBinaryProtocol.Factory protocolFactory = new TBinaryProtocol.Factory();
        ByteArrayOutputStream oStream = new ByteArrayOutputStream();
        this.codecManager.write(BasicThriftStruct.class, oStream, (TProtocolFactory)protocolFactory);
        BasicThriftStruct tstructCopy = (BasicThriftStruct)this.codecManager.read(oStream.toByteArray(), BasicThriftStruct.class, (TProtocolFactory)protocolFactory);
        Assert.assertEquals((Object)tstruct, (Object)tstructCopy);
    }
}

