/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.codec;

import com.facebook.swift.codec.Fruit;
import com.facebook.swift.codec.ThriftConstructor;
import com.facebook.swift.codec.ThriftField;
import com.facebook.swift.codec.ThriftUnion;
import com.facebook.swift.codec.ThriftUnionId;
import com.google.common.base.MoreObjects;
import java.util.Arrays;
import java.util.Objects;

@ThriftUnion(value="Union")
public final class UnionConstructor {
    private Object value;
    private short id = (short)-1;
    private String name;

    @ThriftConstructor
    public UnionConstructor() {
    }

    @ThriftConstructor
    public UnionConstructor(String stringValue) {
        this.value = stringValue;
        this.id = 1;
        this.name = "stringValue";
    }

    @ThriftConstructor
    public UnionConstructor(Long longValue) {
        this.value = longValue;
        this.id = (short)2;
        this.name = "longValue";
    }

    @ThriftConstructor
    public UnionConstructor(Fruit fruitValue) {
        this.value = fruitValue;
        this.id = (short)3;
        this.name = "fruitValue";
    }

    @ThriftUnionId
    public short getThriftId() {
        return this.id;
    }

    public String getThriftName() {
        return this.name;
    }

    @ThriftField(value=1, name="stringValue")
    public String getStringValue() {
        if (this.id != 1) {
            throw new IllegalStateException("not a stringValue");
        }
        return (String)this.value;
    }

    @ThriftField(value=2, name="longValue")
    public Long getLongValue() {
        if (this.id != 2) {
            throw new IllegalStateException("not a longValue");
        }
        return (Long)this.value;
    }

    @ThriftField(value=3, name="fruitValue")
    public Fruit getFruitValue() {
        if (this.id != 3) {
            throw new IllegalStateException("not a fruitValue");
        }
        return (Fruit)((Object)this.value);
    }

    public int hashCode() {
        return Arrays.deepHashCode(new Object[]{this.id, this.value, this.name});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        UnionConstructor that = (UnionConstructor)obj;
        return Objects.equals(this.id, that.id) && Objects.equals(this.value, that.value) && Objects.equals(this.name, that.name);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("value", this.value).add("id", (int)this.id).add("name", (Object)this.name).add("type", (Object)(this.value == null ? "<null>" : this.value.getClass().getSimpleName())).toString();
    }
}

