/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.codec;

import com.facebook.swift.codec.Fruit;
import com.facebook.swift.codec.ThriftCodec;
import com.facebook.swift.codec.UnionField;
import com.facebook.swift.codec.internal.TProtocolReader;
import com.facebook.swift.codec.internal.TProtocolWriter;
import com.facebook.swift.codec.metadata.ThriftType;
import com.google.common.base.Preconditions;
import org.apache.thrift.protocol.TProtocol;

public class UnionFieldThriftCodec
implements ThriftCodec<UnionField> {
    private final ThriftType type;
    private final ThriftCodec<Fruit> fruitCodec;

    public UnionFieldThriftCodec(ThriftType type, ThriftCodec<Fruit> fruitCodec) {
        this.type = type;
        this.fruitCodec = fruitCodec;
    }

    public ThriftType getType() {
        return this.type;
    }

    public UnionField read(TProtocol protocol) throws Exception {
        TProtocolReader reader = new TProtocolReader(protocol);
        UnionField field = new UnionField();
        reader.readStructBegin();
        boolean consumed = false;
        block5: while (reader.nextField()) {
            Preconditions.checkState((!consumed ? 1 : 0) != 0, (Object)"already consumed");
            field._id = reader.getFieldId();
            switch (field._id) {
                case 1: {
                    field.stringValue = reader.readStringField();
                    consumed = true;
                    continue block5;
                }
                case 2: {
                    field.longValue = reader.readI64Field();
                    consumed = true;
                    continue block5;
                }
                case 3: {
                    field.fruitValue = (Fruit)reader.readEnumField(this.fruitCodec);
                    consumed = true;
                    continue block5;
                }
            }
            field._id = (short)-1;
            reader.skipFieldData();
        }
        reader.readStructEnd();
        return field;
    }

    public void write(UnionField value, TProtocol protocol) throws Exception {
        TProtocolWriter writer = new TProtocolWriter(protocol);
        writer.writeStructBegin("union");
        switch (value._id) {
            case 1: {
                writer.writeStringField("stringValue", (short)1, value.stringValue);
                break;
            }
            case 2: {
                writer.writeI64Field("longValue", (short)2, value.longValue.longValue());
                break;
            }
            case 3: {
                writer.writeEnumField("fruitValue", (short)3, this.fruitCodec, (Enum)value.fruitValue);
            }
        }
        writer.writeStructEnd();
    }
}

