/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.codec.generics;

import com.facebook.swift.codec.ThriftConstructor;
import com.facebook.swift.codec.ThriftField;
import com.facebook.swift.codec.ThriftStruct;
import java.util.Objects;

@ThriftStruct(builder=Builder.class)
public final class GenericThriftStructFromBuilder<S, T> {
    private final S firstGenericProperty;
    private final T secondGenericProperty;

    private GenericThriftStructFromBuilder(S firstGenericProperty, T secondGenericProperty) {
        this.firstGenericProperty = firstGenericProperty;
        this.secondGenericProperty = secondGenericProperty;
    }

    @ThriftField(value=1)
    public S getFirstGenericProperty() {
        return this.firstGenericProperty;
    }

    @ThriftField(value=2)
    public T getSecondGenericProperty() {
        return this.secondGenericProperty;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        GenericThriftStructFromBuilder other = (GenericThriftStructFromBuilder)obj;
        return Objects.equals(this.firstGenericProperty, other.firstGenericProperty) && Objects.equals(this.secondGenericProperty, other.secondGenericProperty);
    }

    public static class Builder<X, Y> {
        private X firstGenericProperty;
        private Y secondGenericProperty;

        @ThriftField(value=1)
        public Builder<X, Y> setFirstGenericProperty(X firstGenericProperty) {
            this.firstGenericProperty = firstGenericProperty;
            return this;
        }

        @ThriftField(value=2)
        public Builder<X, Y> setSecondGenericProperty(Y secondGenericProperty) {
            this.secondGenericProperty = secondGenericProperty;
            return this;
        }

        @ThriftConstructor
        public GenericThriftStructFromBuilder<X, Y> build() {
            return new GenericThriftStructFromBuilder(this.firstGenericProperty, this.secondGenericProperty);
        }
    }
}

