/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.codec.metadata;

import com.facebook.swift.codec.ThriftField;
import com.facebook.swift.codec.ThriftStruct;
import com.facebook.swift.codec.ThriftUnion;
import com.facebook.swift.codec.ThriftUnionId;
import com.facebook.swift.codec.metadata.FieldKind;
import com.facebook.swift.codec.metadata.FieldMetadata;
import com.facebook.swift.codec.metadata.MetadataErrorException;
import com.facebook.swift.codec.metadata.MetadataErrors;
import com.facebook.swift.codec.metadata.ReflectionHelper;
import com.facebook.swift.codec.metadata.ThriftCatalog;
import com.facebook.swift.codec.metadata.ThriftFieldMetadata;
import com.facebook.swift.codec.metadata.ThriftStructMetadata;
import com.facebook.swift.codec.metadata.ThriftStructMetadataBuilder;
import com.facebook.swift.codec.metadata.ThriftUnionMetadataBuilder;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.fest.assertions.Assertions;
import org.fest.assertions.BooleanAssert;
import org.fest.assertions.CollectionAssert;
import org.fest.assertions.ListAssert;
import org.fest.assertions.ObjectAssert;
import org.fest.assertions.ShortAssert;
import org.fest.assertions.StringAssert;
import org.testng.annotations.Test;

public class TestLegacyFieldIds {
    @Test
    public void testLegacyIdCorrectlyAnnotated() {
        ThriftStructMetadataBuilder builder = new ThriftStructMetadataBuilder(new ThriftCatalog(), LegacyIdCorrect.class);
        ThriftStructMetadata metadata = builder.build();
        HashSet<Integer> seen = new HashSet<Integer>();
        for (ThriftFieldMetadata field : metadata.getFields()) {
            seen.add(Integer.valueOf(field.getId()));
        }
        ((CollectionAssert)Assertions.assertThat(seen).as("fields found in LegacyIdCorrect")).isEqualTo((Object)LegacyIdCorrect.IDS);
    }

    @Test
    public void testLegacyIdCorrectlyAnnotatedWhitebox() {
        ThriftStructMetadataBuilder builder = new ThriftStructMetadataBuilder(new ThriftCatalog(), LegacyIdCorrect.class);
        HashSet<Integer> seen = new HashSet<Integer>();
        for (FieldMetadata field : builder.fields) {
            String name = field.getName();
            short id = field.getId();
            boolean legacy = field.isLegacyId();
            ((StringAssert)Assertions.assertThat((String)name).as("name of field " + field)).matches("^(notLegacy|legacy).*");
            if (name.startsWith("legacy")) {
                ((ShortAssert)Assertions.assertThat((short)id).as("id of field " + field)).isLessThan((short)0);
                ((BooleanAssert)Assertions.assertThat((boolean)legacy).as("isLegacyId of field " + field)).isTrue();
            } else {
                ((ShortAssert)Assertions.assertThat((short)id).as("id of field " + field)).isGreaterThanOrEqualTo((short)0);
                ((BooleanAssert)Assertions.assertThat((boolean)legacy).as("isLegacyId of field " + field)).isFalse();
            }
            seen.add(Integer.valueOf(id));
        }
        ((CollectionAssert)Assertions.assertThat(seen).as("present fields in the struct")).isEqualTo((Object)LegacyIdCorrect.IDS);
    }

    @Test
    public void testLegacyIdIncorrect() {
        ThriftStructMetadataBuilder builder = new ThriftStructMetadataBuilder(new ThriftCatalog(), LegacyIdIncorrectlyMissing.class);
        MetadataErrors metadataErrors = builder.getMetadataErrors();
        ((ListAssert)Assertions.assertThat((List)metadataErrors.getErrors()).as("metadata errors")).hasSize(1);
        ((ListAssert)Assertions.assertThat((List)metadataErrors.getWarnings()).as("metadata warnings")).isEmpty();
        ((StringAssert)Assertions.assertThat((String)((MetadataErrorException)metadataErrors.getErrors().get(0)).getMessage()).as("error message")).containsIgnoringCase("has a negative field id but not isLegacyId=true");
        builder = new ThriftStructMetadataBuilder(new ThriftCatalog(), LegacyIdIncorrectlyPresent.class);
        metadataErrors = builder.getMetadataErrors();
        ((ListAssert)Assertions.assertThat((List)metadataErrors.getErrors()).as("metadata errors")).hasSize(1);
        ((ListAssert)Assertions.assertThat((List)metadataErrors.getWarnings()).as("metadata warnings")).isEmpty();
        ((StringAssert)Assertions.assertThat((String)((MetadataErrorException)metadataErrors.getErrors().get(0)).getMessage()).as("error message")).containsIgnoringCase("has isLegacyId=true but not a negative field id");
        for (Class klass : Arrays.asList(LegacyIdInconsistent1.class, LegacyIdInconsistent2.class, LegacyIdInconsistent3.class, LegacyIdInconsistent4.class)) {
            ThriftStructMetadataBuilder builder2 = new ThriftStructMetadataBuilder(new ThriftCatalog(), (Type)klass);
            MetadataErrors metadataErrors2 = builder2.getMetadataErrors();
            ((ListAssert)Assertions.assertThat((List)metadataErrors2.getErrors()).as("metadata errors")).isNotEmpty();
            ((ListAssert)Assertions.assertThat((List)metadataErrors2.getWarnings()).as("metadata warnings")).isEmpty();
            ((StringAssert)Assertions.assertThat((String)((MetadataErrorException)metadataErrors2.getErrors().get(0)).getMessage()).as("error message")).containsIgnoringCase("has both isLegacyId=true and isLegacyId=false");
        }
    }

    @Test
    public void testGetThriftFieldIsLegacyId() {
        Function getter = FieldMetadata.getThriftFieldIsLegacyId();
        Function<ThriftField, FieldMetadata> makeFakeFieldMetadata = new Function<ThriftField, FieldMetadata>(){

            public FieldMetadata apply(ThriftField input) {
                return new FieldMetadata(input, FieldKind.THRIFT_FIELD){

                    public Type getJavaType() {
                        throw new UnsupportedOperationException();
                    }

                    public String extractName() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
        for (Field f : ReflectionHelper.findAnnotatedFields(SomeThriftFields.class, ThriftField.class)) {
            Optional expected;
            if (f.getName().startsWith("expectTrue")) {
                expected = Optional.of((Object)true);
            } else if (f.getName().startsWith("expectFalse")) {
                expected = Optional.of((Object)false);
            } else if (f.getName().startsWith("expectNothing")) {
                expected = Optional.absent();
            } else {
                Preconditions.checkArgument((boolean)f.getName().startsWith("broken"));
                continue;
            }
            Optional actual = (Optional)getter.apply(makeFakeFieldMetadata.apply((Object)f.getAnnotation(ThriftField.class)));
            ((ObjectAssert)Assertions.assertThat((Object)actual).as("result of getThriftFieldIsLegacyId on " + f)).isEqualTo((Object)expected);
        }
    }

    @Test
    public void testLegacyIdOnUnion() {
        ThriftUnionMetadataBuilder builder = new ThriftUnionMetadataBuilder(new ThriftCatalog(), LegacyIdUnionCorrect.class);
        ThriftStructMetadata metadata = builder.build();
        HashSet<Integer> seen = new HashSet<Integer>();
        for (ThriftFieldMetadata field : metadata.getFields()) {
            seen.add(Integer.valueOf(field.getId()));
        }
        ((CollectionAssert)Assertions.assertThat(seen).as("fields found in LegacyIdUnionCorrect")).isEqualTo((Object)LegacyIdUnionCorrect.IDS);
    }

    @ThriftUnion
    public static final class LegacyIdUnionCorrect {
        private static final Set<Integer> IDS = ImmutableSet.of((Object)-4, (Object)-3, (Object)-2, (Object)-1, (Object)0, (Object)1, (Object[])new Integer[]{2, Short.MIN_VALUE});
        @ThriftUnionId
        public short unionId;
        @ThriftField(value=0, isLegacyId=false)
        public boolean notLegacyId0;
        @ThriftField(value=1, isLegacyId=false)
        public boolean notLegacyId1;
        @ThriftField(value=2)
        public boolean notLegacyId2;
        @ThriftField(value=-1, isLegacyId=true)
        public boolean legacyIdOnField;

        @ThriftField(value=-2, isLegacyId=true)
        public boolean getLegacyIdOnGetterOnly() {
            return false;
        }

        @ThriftField
        public void setLegacyIdOnGetterOnly(boolean value) {
        }

        @ThriftField
        public boolean getLegacyIdOnSetterOnly() {
            return false;
        }

        @ThriftField(value=-3, isLegacyId=true)
        public void setLegacyIdOnSetterOnly(boolean value) {
        }

        @ThriftField(value=-4, isLegacyId=true)
        public boolean getLegacyIdOnBoth() {
            return false;
        }

        @ThriftField(value=-4, isLegacyId=true)
        public void setLegacyIdOnBoth(boolean value) {
        }
    }

    private static class SomeThriftFields {
        @ThriftField(value=1, isLegacyId=false)
        boolean expectFalse1;
        @ThriftField(value=-1, isLegacyId=false)
        boolean expectFalse2;
        @ThriftField(isLegacyId=false)
        boolean broken;
        @ThriftField(value=1, isLegacyId=true)
        boolean expectTrue1;
        @ThriftField(value=-1, isLegacyId=true)
        boolean expectTrue2;
        @ThriftField(isLegacyId=true)
        boolean expectTrue3;
        @ThriftField
        boolean expectNothing;

        private SomeThriftFields() {
        }
    }

    @ThriftStruct
    public static final class LegacyIdInconsistent4 {
        @ThriftField(value=4, isLegacyId=false)
        public boolean getField() {
            return false;
        }

        @ThriftField(value=4, isLegacyId=true)
        public void setField(boolean value) {
        }
    }

    @ThriftStruct
    public static final class LegacyIdInconsistent3 {
        @ThriftField(value=4, isLegacyId=true)
        public boolean getField() {
            return false;
        }

        @ThriftField(value=4, isLegacyId=false)
        public void setField(boolean value) {
        }
    }

    @ThriftStruct
    public static final class LegacyIdInconsistent2 {
        @ThriftField(value=-4, isLegacyId=false)
        public boolean getField() {
            return false;
        }

        @ThriftField(value=-4, isLegacyId=true)
        public void setField(boolean value) {
        }
    }

    @ThriftStruct
    public static final class LegacyIdInconsistent1 {
        @ThriftField(value=-4, isLegacyId=true)
        public boolean getField() {
            return false;
        }

        @ThriftField(value=-4, isLegacyId=false)
        public void setField(boolean value) {
        }
    }

    @ThriftStruct
    public static final class LegacyIdIncorrectlyPresent {
        @ThriftField(value=4, isLegacyId=true)
        public boolean field;
    }

    @ThriftStruct
    public static final class LegacyIdIncorrectlyMissing {
        @ThriftField(value=-4)
        public boolean field;
    }

    @ThriftStruct
    public static final class LegacyIdCorrect {
        private static final Set<Integer> IDS = ImmutableSet.of((Object)-4, (Object)-3, (Object)-2, (Object)-1, (Object)0, (Object)1, (Object[])new Integer[]{2});
        @ThriftField(value=0, isLegacyId=false)
        public boolean notLegacyId0;
        @ThriftField(value=1, isLegacyId=false)
        public boolean notLegacyId1;
        @ThriftField(value=2)
        public boolean notLegacyId2;
        @ThriftField(value=-1, isLegacyId=true)
        public boolean legacyIdOnField;

        @ThriftField(value=-2, isLegacyId=true)
        public boolean getLegacyIdOnGetterOnly() {
            return false;
        }

        @ThriftField
        public void setLegacyIdOnGetterOnly(boolean value) {
        }

        @ThriftField
        public boolean getLegacyIdOnSetterOnly() {
            return false;
        }

        @ThriftField(value=-3, isLegacyId=true)
        public void setLegacyIdOnSetterOnly(boolean value) {
        }

        @ThriftField(value=-4, isLegacyId=true)
        public boolean getLegacyIdOnBoth() {
            return false;
        }

        @ThriftField(value=-4, isLegacyId=true)
        public void setLegacyIdOnBoth(boolean value) {
        }
    }
}

