/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.codec.metadata;

import com.facebook.swift.codec.ThriftField;
import com.facebook.swift.codec.ThriftUnion;
import com.facebook.swift.codec.ThriftUnionId;
import com.facebook.swift.codec.metadata.MetadataErrorException;
import com.facebook.swift.codec.metadata.MetadataErrors;
import com.facebook.swift.codec.metadata.MetadataWarningException;
import com.facebook.swift.codec.metadata.ThriftCatalog;
import com.facebook.swift.codec.metadata.ThriftUnionMetadataBuilder;
import java.util.List;
import java.util.concurrent.locks.Lock;
import org.fest.assertions.Assertions;
import org.fest.assertions.ListAssert;
import org.fest.assertions.StringAssert;
import org.testng.annotations.Test;

public class TestThriftUnionMetadataBuilder {
    @Test
    public void testNoId() throws Exception {
        ThriftUnionMetadataBuilder builder = new ThriftUnionMetadataBuilder(new ThriftCatalog(), NoId.class);
        MetadataErrors metadataErrors = builder.getMetadataErrors();
        ((ListAssert)Assertions.assertThat((List)metadataErrors.getErrors()).as("metadata errors")).hasSize(1);
        ((ListAssert)Assertions.assertThat((List)metadataErrors.getWarnings()).as("metadata warnings")).isEmpty();
        ((StringAssert)Assertions.assertThat((String)((MetadataErrorException)((Object)metadataErrors.getErrors().get(0))).getMessage()).as("error message")).containsIgnoringCase("not have an id");
    }

    @Test
    public void testMultipleIds() throws Exception {
        ThriftUnionMetadataBuilder builder = new ThriftUnionMetadataBuilder(new ThriftCatalog(), MultipleIds.class);
        MetadataErrors metadataErrors = builder.getMetadataErrors();
        ((ListAssert)Assertions.assertThat((List)metadataErrors.getErrors()).as("metadata errors")).hasSize(1);
        ((ListAssert)Assertions.assertThat((List)metadataErrors.getWarnings()).as("metadata warnings")).isEmpty();
        ((StringAssert)Assertions.assertThat((String)((MetadataErrorException)((Object)metadataErrors.getErrors().get(0))).getMessage()).as("error message")).containsIgnoringCase("multiple ids");
    }

    @Test
    public void testMultipleNames() throws Exception {
        ThriftUnionMetadataBuilder builder = new ThriftUnionMetadataBuilder(new ThriftCatalog(), MultipleNames.class);
        MetadataErrors metadataErrors = builder.getMetadataErrors();
        ((ListAssert)Assertions.assertThat((List)metadataErrors.getErrors()).as("metadata errors")).isEmpty();
        ((ListAssert)Assertions.assertThat((List)metadataErrors.getWarnings()).as("metadata warnings")).hasSize(1);
        ((StringAssert)Assertions.assertThat((String)((MetadataWarningException)metadataErrors.getWarnings().get(0)).getMessage()).as("error message")).containsIgnoringCase("multiple names");
    }

    @Test
    public void testUnsupportedType() throws Exception {
        ThriftUnionMetadataBuilder builder = new ThriftUnionMetadataBuilder(new ThriftCatalog(), UnsupportedJavaType.class);
        MetadataErrors metadataErrors = builder.getMetadataErrors();
        ((ListAssert)Assertions.assertThat((List)metadataErrors.getErrors()).as("metadata errors")).hasSize(1);
        ((ListAssert)Assertions.assertThat((List)metadataErrors.getWarnings()).as("metadata warnings")).isEmpty();
        ((StringAssert)Assertions.assertThat((String)((MetadataErrorException)((Object)metadataErrors.getErrors().get(0))).getMessage()).as("error message")).containsIgnoringCase("not a supported Java type");
    }

    @Test
    public void testMultipleTypes() throws Exception {
        ThriftUnionMetadataBuilder builder = new ThriftUnionMetadataBuilder(new ThriftCatalog(), MultipleTypes.class);
        MetadataErrors metadataErrors = builder.getMetadataErrors();
        ((ListAssert)Assertions.assertThat((List)metadataErrors.getErrors()).as("metadata errors")).hasSize(1);
        ((ListAssert)Assertions.assertThat((List)metadataErrors.getWarnings()).as("metadata warnings")).isEmpty();
        ((StringAssert)Assertions.assertThat((String)((MetadataErrorException)((Object)metadataErrors.getErrors().get(0))).getMessage()).as("error message")).containsIgnoringCase("multiple types");
    }

    @Test
    public void testNonFinalUnionOk() {
        ThriftUnionMetadataBuilder builder = new ThriftUnionMetadataBuilder(new ThriftCatalog(), NotFinalUnion.class);
        builder.build();
    }

    @ThriftUnion
    public static class NotFinalUnion {
        @ThriftUnionId
        public short id;
    }

    @ThriftUnion
    public static final class MultipleTypes {
        @ThriftUnionId
        public void setId(short id) {
        }

        @ThriftField(value=1)
        public int getFoo() {
            return 0;
        }

        @ThriftField
        public void setFoo(short value) {
        }
    }

    @ThriftUnion
    public static final class UnsupportedJavaType {
        @ThriftField(value=1)
        public Lock unsupportedJavaType;

        @ThriftUnionId
        public void setId(short id) {
        }
    }

    @ThriftUnion
    public static final class MultipleNames {
        @ThriftUnionId
        public void setId(short id) {
        }

        @ThriftField(value=1, name="foo")
        public String getFoo() {
            return null;
        }

        @ThriftField(value=1, name="bar")
        public void setFoo(String value) {
        }
    }

    @ThriftUnion
    public static final class MultipleIds {
        @ThriftUnionId
        public void setId(short id) {
        }

        @ThriftField(name="foo", value=1)
        public void setField1(String value) {
        }

        @ThriftField(name="foo", value=2)
        public void setField2(String value) {
        }

        @ThriftField(name="foo")
        public String getField1() {
            return null;
        }

        @ThriftField(name="foo")
        public String getField2() {
            return null;
        }
    }

    @ThriftUnion
    public static final class NoId {
        @ThriftUnionId
        public short id;

        @ThriftField
        public String getField1() {
            return null;
        }

        @ThriftField
        public void setField1(String value) {
        }
    }
}

