/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.codec.internal.builtin;

import com.facebook.swift.codec.ThriftCodec;
import com.facebook.swift.codec.internal.TProtocolReader;
import com.facebook.swift.codec.internal.TProtocolWriter;
import com.facebook.swift.codec.metadata.ThriftType;
import com.google.common.base.Preconditions;
import java.util.Map;
import javax.annotation.concurrent.Immutable;
import org.apache.thrift.protocol.TProtocol;

@Immutable
public class MapThriftCodec<K, V>
implements ThriftCodec<Map<K, V>> {
    private final ThriftType thriftType;
    private final ThriftCodec<K> keyCodec;
    private final ThriftCodec<V> valueCodec;

    public MapThriftCodec(ThriftType type, ThriftCodec<K> keyCodec, ThriftCodec<V> valueCodec) {
        Preconditions.checkNotNull((Object)type, (Object)"type is null");
        Preconditions.checkNotNull(keyCodec, (Object)"keyCodec is null");
        Preconditions.checkNotNull(valueCodec, (Object)"valueCodec is null");
        this.thriftType = type;
        this.keyCodec = keyCodec;
        this.valueCodec = valueCodec;
    }

    @Override
    public ThriftType getType() {
        return this.thriftType;
    }

    @Override
    public Map<K, V> read(TProtocol protocol) throws Exception {
        Preconditions.checkNotNull((Object)protocol, (Object)"protocol is null");
        return new TProtocolReader(protocol).readMap(this.keyCodec, this.valueCodec);
    }

    @Override
    public void write(Map<K, V> value, TProtocol protocol) throws Exception {
        Preconditions.checkNotNull(value, (Object)"value is null");
        Preconditions.checkNotNull((Object)protocol, (Object)"protocol is null");
        new TProtocolWriter(protocol).writeMap(this.keyCodec, this.valueCodec, value);
    }
}

