/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.codec.internal.compiler.byteCode;

import com.facebook.swift.codec.internal.compiler.byteCode.Access;
import com.facebook.swift.codec.internal.compiler.byteCode.ParameterizedType;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.EnumSet;
import javax.annotation.concurrent.Immutable;
import org.objectweb.asm.tree.FieldNode;

@Immutable
public class FieldDefinition {
    private final ImmutableSet<Access> access;
    private final String name;
    private final ParameterizedType type;

    public FieldDefinition(EnumSet<Access> access, String name, ParameterizedType type) {
        this.access = Sets.immutableEnumSet(access);
        this.name = name;
        this.type = type;
    }

    public ImmutableSet<Access> getAccess() {
        return this.access;
    }

    public String getName() {
        return this.name;
    }

    public ParameterizedType getType() {
        return this.type;
    }

    public FieldNode getFieldNode() {
        return new FieldNode(Access.toAccessModifier(this.access), this.name, this.type.getType(), this.type.getGenericSignature(), null);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("FieldDefinition");
        sb.append("{access=").append(this.access);
        sb.append(", name='").append(this.name).append('\'');
        sb.append(", type=").append(this.type);
        sb.append('}');
        return sb.toString();
    }
}

